<?php

namespace App\Services\OBSERVATION;

use App\Http\Resources\OBSERVATION\ObservationReportedByResource;
use App\Models\UserMapSite;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class ObservationMstReportedByServices extends ObservationReportedByResource
{
    public $vvsObservationRecipentModel;
    public function __construct(){
        $this->vvsObservationRecipentModel = new UserMapSite();
    }
    
    public function getObsReportedByList($rawRequest){
        return UserMapSite::select('USERS_MAP_SITE.USER_ID',
                                    'USERS_MAP_SITE.SITE_ID',
                                    'USERS_MAP_ROLE.ROLE_ID',
                                    'USERS_MAP_SITE.MAP_SITE_ID',
                                )
                            ->leftJoin('USERS_MAP_ROLE', 'USERS_MAP_ROLE.USER_ID', '=', 'USERS_MAP_SITE.USER_ID')
                            ->leftJoin('USERS', 'USERS.ID', '=', 'USERS_MAP_SITE.USER_ID')                           
                            ->where('USERS_MAP_SITE.IS_ACTIVE', 1)
                            ->where('USERS_MAP_SITE.IS_DELETED', 0)
                            ->where('USERS_MAP_ROLE.IS_ACTIVE', 1)
                            ->where('USERS_MAP_ROLE.IS_DELETED', 0)
                            ->where('USERS.IS_ACTIVE', 1)
                            ->where('USERS.IS_DELETED', 0)                            
                            ->where("USERS_MAP_SITE.SITE_ID",$rawRequest->SITE_ID)
                            ->where('USERS_MAP_ROLE.MODULE_NAME', 'OBS')
                            ->whereIn('USERS_MAP_ROLE.ROLE_ID', [11])    
                            ->get();
    }

    public function getObsactionOwnerByList($rawRequest){
        return UserMapSite::select('USERS_MAP_SITE.USER_ID',
                                    'USERS_MAP_SITE.SITE_ID',
                                    'USERS_MAP_ROLE.ROLE_ID',
                                    'USERS_MAP_SITE.MAP_SITE_ID',
                                )
                            ->leftJoin('USERS_MAP_ROLE', 'USERS_MAP_ROLE.USER_ID', '=', 'USERS_MAP_SITE.USER_ID')
                            ->leftJoin('USERS', 'USERS.ID', '=', 'USERS_MAP_SITE.USER_ID')                           
                            ->where('USERS_MAP_SITE.IS_ACTIVE', 1)
                            ->where('USERS_MAP_SITE.IS_DELETED', 0)
                            ->where('USERS_MAP_ROLE.IS_ACTIVE', 1)
                            ->where('USERS_MAP_ROLE.IS_DELETED', 0)
                            ->where('USERS.IS_ACTIVE', 1)
                            ->where('USERS.IS_DELETED', 0)                            
                            ->where("USERS_MAP_SITE.SITE_ID",$rawRequest->SITE_ID)
                            ->where('USERS_MAP_ROLE.MODULE_NAME', 'OBS')
                            ->whereIn('USERS_MAP_ROLE.ROLE_ID', [12])    
                            ->get();
    }
    
}
