<?php

namespace App\Services\OBSERVATION;

use App\Http\Resources\OBSERVATION\ObservationMstDeclarationResource;
use App\Models\ObservationMapDeclaration;
use App\Models\ObservationMstDeclaration;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;

class ObservationMstDeclarationServices extends ObservationMstDeclarationResource
{
    public $vvsObservationDeclModel;
    public function __construct(){
        $this->vvsObservationDeclModel = new ObservationMstDeclaration();
    }
    

    public function getObservationInitialDeclListOne(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%OBS_ADD_ONE%')->get();
    }

    public function getObservationInitialDeclListTwo(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%OBS_ADD_TWO%')->get();
    }

    public function getObservationMoveFrwdDeclList(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%MOVE_FORWARD%')->get();
    }

    public function getObservationApproveDeclList(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%ACCEPT_TIMELINE%')->get();
    }

    public function getObservationRejectDeclList(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%REJECT%')->get();
    }

    public function getObservationCloseReqDeclList(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%REQUEST_FOR_CLOSURE%')->get();
    }

    public function getObservationCloseDeclList(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%CLOSE%')->get();
    }

    public function getObservationSuspendReqDeclList(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', '%REQUEST_FOR_SUSPEND%')->get();
    }

    public function getObservationSuspendDeclList(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_GROUP', 'LIKE', 'SUSPEND%')->get();
    }

    public function getObservationRenewDeclList(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', 'RENEWED%')->get();
    }

    public function getObservationDeclListPopOne(){
        return ObservationMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%OBS_ADD_POP_ONE%')->get();
    }

    public function getMapDeclarationOne($obs_id,$afterSubmit){
        if( $afterSubmit == 1 ){

            return ObservationMstDeclaration::select(
                        'OBS_MST_DECLARATION.DECLARATION_ID', 
                        'OBS_MST_DECLARATION.DECLARATION_NAME', 
                        'OBS_MST_DECLARATION.DECLARATION_GROUP', 
                        'OBS_MST_DECLARATION.DECLARATION_SECTION',
                        'OBS_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                        'OBS_MAP_DECLARATION.MAP_DECLARATION_ID',
                        'OBS_MAP_DECLARATION.IS_ACTIVE',
                        'OBS_MAP_DECLARATION.IS_DELETED'
                    )
                    ->leftJoin('OBS_MAP_DECLARATION', function($join) use ($obs_id) {
                        $join->on('OBS_MAP_DECLARATION.DECLARATION_ID', '=', 'OBS_MST_DECLARATION.DECLARATION_ID')
                            ->where('OBS_MAP_DECLARATION.OBS_ID', $obs_id)
                            ->where('OBS_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('OBS_MAP_DECLARATION.IS_DELETED', 0);
                    })
                    ->where('OBS_MST_DECLARATION.IS_ACTIVE', 1)
                    ->where('OBS_MST_DECLARATION.IS_DELETED', 0)                    
                    ->where('OBS_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', 'OBS_ADD_ONE%')
                    ->get();
        }else{
            return ObservationMapDeclaration::select('OBS_MST_DECLARATION.DECLARATION_ID', 'OBS_MST_DECLARATION.DECLARATION_NAME', 'OBS_MST_DECLARATION.DECLARATION_GROUP', 'OBS_MST_DECLARATION.DECLARATION_SECTION','OBS_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                                            'OBS_MAP_DECLARATION.MAP_DECLARATION_ID',
                                            'OBS_MAP_DECLARATION.IS_ACTIVE',
                                            'OBS_MAP_DECLARATION.IS_DELETED'
                                            )
                            ->leftJoin('OBS_MST_DECLARATION', 'OBS_MAP_DECLARATION.DECLARATION_ID', '=', 'OBS_MST_DECLARATION.DECLARATION_ID')
                            ->where('OBS_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('OBS_MAP_DECLARATION.IS_DELETED', 0)
                            ->where("OBS_MAP_DECLARATION.OBS_ID",$obs_id)
                            ->where('OBS_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', '%OBS_ADD_ONE%')
                            ->get();
                  
        }
        
    }

    public function getMapDeclarationTwo($obs_id,$afterSubmit){
        if( $afterSubmit == 1 ){

               return ObservationMstDeclaration::select(
                    'OBS_MST_DECLARATION.DECLARATION_ID', 
                    'OBS_MST_DECLARATION.DECLARATION_NAME', 
                    'OBS_MST_DECLARATION.DECLARATION_GROUP', 
                    'OBS_MST_DECLARATION.DECLARATION_SECTION',
                    'OBS_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                    'OBS_MAP_DECLARATION.MAP_DECLARATION_ID',
                    'OBS_MAP_DECLARATION.IS_ACTIVE',
                    'OBS_MAP_DECLARATION.IS_DELETED'
                )
                ->leftJoin('OBS_MAP_DECLARATION', function($join) use ($obs_id) {
                    $join->on('OBS_MAP_DECLARATION.DECLARATION_ID', '=', 'OBS_MST_DECLARATION.DECLARATION_ID')
                         ->where('OBS_MAP_DECLARATION.OBS_ID', $obs_id)
                         ->where('OBS_MAP_DECLARATION.IS_ACTIVE', 1)
                         ->where('OBS_MAP_DECLARATION.IS_DELETED', 0);
                })
                ->where('OBS_MST_DECLARATION.IS_ACTIVE', 1)
                ->where('OBS_MST_DECLARATION.IS_DELETED', 0)
                ->where('OBS_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', 'OBS_ADD_TWO%')
                ->get();
        }else{
            return ObservationMapDeclaration::select('OBS_MST_DECLARATION.DECLARATION_ID', 'OBS_MST_DECLARATION.DECLARATION_NAME', 'OBS_MST_DECLARATION.DECLARATION_GROUP', 'OBS_MST_DECLARATION.DECLARATION_SECTION','OBS_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                                            'OBS_MAP_DECLARATION.MAP_DECLARATION_ID',
                                            'OBS_MAP_DECLARATION.IS_ACTIVE',
                                            'OBS_MAP_DECLARATION.IS_DELETED'
                                            )
                            ->Join('OBS_MST_DECLARATION', 'OBS_MAP_DECLARATION.DECLARATION_ID', '=', 'OBS_MST_DECLARATION.DECLARATION_ID')
                            ->where('OBS_MST_DECLARATION.IS_ACTIVE', 1)
                            ->where('OBS_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('OBS_MAP_DECLARATION.IS_DELETED', 0)
                            ->where('OBS_MST_DECLARATION.IS_DELETED', 0)
                            ->where("OBS_MAP_DECLARATION.OBS_ID",$obs_id)
                            ->where('OBS_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', '%OBS_ADD_TWO%')
                            ->get();
                  
        }
        
        
        
    }

    public function getMapDeclarationAll($obs_id){
        return ObservationMapDeclaration::select(            
            'OBS_MST_DECLARATION.DECLARATION_NAME', 
            'OBS_MST_DECLARATION.DECLARATION_GROUP', 
            'OBS_MST_DECLARATION.DECLARATION_SECTION'            
        )
        ->Join('OBS_MST_DECLARATION', 'OBS_MAP_DECLARATION.DECLARATION_ID', '=', 'OBS_MST_DECLARATION.DECLARATION_ID')
        ->where('OBS_MST_DECLARATION.IS_ACTIVE', 1)
        ->where('OBS_MAP_DECLARATION.IS_ACTIVE', 1)
        ->where('OBS_MAP_DECLARATION.IS_DELETED', 0)
        ->where('OBS_MST_DECLARATION.IS_DELETED', 0)
        ->where("OBS_MAP_DECLARATION.OBS_ID",$obs_id)        
        ->get();
    }
    
}
