<?php

namespace App\Services\OBSERVATION;

use App\Http\Resources\OBSERVATION\ObservationActionHistoryResource;
use App\Models\ObservationActionHistory;
use App\Models\ObservationActionTakenDetailsLog;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class ObservationActionHistoryServices extends ObservationActionHistoryResource
{
    public $vvsObservationActivityModel;
    public function __construct(){
        $this->vvsObservationActivityModel = new ObservationActionHistory();
    }    
    

    public function getAllActivityLog($obs_id){
        return ObservationActionHistory::select(
            'OBS_ACTION_HISTORY.OBS_ID', 
            'OBS_ACTION_HISTORY.ACTION_TAKER_ID', 
            'OBS_ACTION_HISTORY.STAGE_ID', 
            'OBS_ACTION_HISTORY.COMMENTS',
            'OBS_ACTION_HISTORY.CREATED_BY', 
            'OBS_ACTION_HISTORY.CREATED_ON'           
        )
        ->leftJoin('OBSERVATION', function($join) use ($obs_id) {
            $join->on('OBSERVATION.ID', '=', 'OBS_ACTION_HISTORY.OBS_ID')                
                ->where('OBSERVATION.IS_ACTIVE', 1)
                ->where('OBSERVATION.IS_DELETED', 0);
        })
        ->where('OBS_ACTION_HISTORY.IS_ACTIVE', 1)
        ->where('OBS_ACTION_HISTORY.IS_DELETED', 0)
        ->whereNotNull('OBSERVATION.ID')
        ->get();

    }

    public function actionTakenLog($obs_id) {
        return ObservationActionTakenDetailsLog::select(
            'OBS_ACTION_TAKEN_DETAILS_LOG.OBS_ID',
            'OBS_ACTION_TAKEN_DETAILS_LOG.ACTION_TAKER_ID',
            'OBS_ACTION_TAKEN_DETAILS_LOG.STAGE_ID',
            'OBS_ACTION_TAKEN_DETAILS_LOG.COMMENTS',
            'OBS_ACTION_TAKEN_DETAILS_LOG.CREATED_BY',
            'OBS_ACTION_TAKEN_DETAILS_LOG.CREATED_ON'
        )
        ->where('OBS_ACTION_TAKEN_DETAILS_LOG.IS_ACTIVE', 1)
        ->where('OBS_ACTION_TAKEN_DETAILS_LOG.IS_DELETED', 0)
        ->where('OBS_ACTION_TAKEN_DETAILS_LOG.OBS_ID', $obs_id)
        ->orderBy("OBS_ACTION_TAKEN_DETAILS_LOG.HISTORY_ID", "DESC")
        ->get();

    }

    public function actionTakenLogExport($obs_id) {
        return ObservationActionHistory::select(
            'OBS_ACTION_HISTORY.OBS_ID',
            'OBS_ACTION_HISTORY.ACTION_TAKER_ID',
            'OBS_ACTION_HISTORY.STAGE_ID',
            'OBS_ACTION_HISTORY.CREATED_BY',
            'OBS_ACTION_HISTORY.CREATED_ON'
        )
        ->where('OBS_ACTION_HISTORY.IS_ACTIVE', 1)
        ->where('OBS_ACTION_HISTORY.IS_DELETED', 0)
        ->where('OBS_ACTION_HISTORY.OBS_ID', $obs_id)
        ->orderBy("OBS_ACTION_HISTORY.HISTORY_ID", "DESC")
        ->get();

    }
    
}
