<?php

namespace App\Services\Master;

use App\Http\Resources\Master\MasterUserAccessResource;
use App\Models\User;
use App\Models\MstSite;
use App\Models\UserMapRole;
use App\Models\UserMapSite;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Http\Traits\EncDecService;

class MasterUserAccessServices extends MasterUserAccessResource
{
    use EncDecService;
    public $vvsUserModel;
    public $page;
    public $pageSize;
    public function __construct() {
        $this->vvsUserModel = new User();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'NAME' => ['FIRST_NAME', 'LAST_NAME'],
            'MODULE_NAME' => 'user_roles.MODULE_NAME', // Define 'MODULE_NAME' to search by module name
        ];
    }
    
    public function getMasterUserAccessList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query = User::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['roles','sites'];

         // Join the UserMapRole table to perform the search on MODULE_NAME
        $query->leftJoin('USERS_MAP_ROLE', 'USERS.ID', '=', 'USERS_MAP_ROLE.USER_ID');

        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Special handling for NAME to make it case-insensitive
                if ($key === 'NAME') {
                    $names = explode(' ', $value);
                    // Search for each part in both first and last names
                    $query->where(function ($q) use ($names, $columnMapping) {
                        foreach ($names as $name) {
                            $q->where(function ($q) use ($name, $columnMapping) {
                                $q->where($columnMapping['NAME'][0], 'ILIKE', "%{$name}%")
                                ->orWhere($columnMapping['NAME'][1], 'ILIKE', "%{$name}%");
                            });
                        }
                    });
                } elseif ($key === 'MODULE_NAME') {
                    $query->where('USERS_MAP_ROLE.MODULE_NAME', 'LIKE', "%$value%");
                } else {
                    // Add a where clause for the mapped column name
                    $query->where("USERS.$key", $value); // Explicitly specify USERS table for non-ambiguous columns
                }
            }
        }
    
        $query->where("USERS.IS_DELETED", 0); // Specify USERS table for IS_DELETED column
        $query->orderBy("USERS.ID", "DESC"); // Specify USERS table for ID column
        $query->select('USERS.*')->distinct();
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
    
        $totalCount = $query->count('USERS.ID'); // Specify USERS table for ID column
    

        // Pagination Logic
        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

        $paginatedUserData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedUserData,
            'total' => $totalCount // Total count of distinct User IDs
        ];
    }

    public function getModuleNameList(){
        return UserMapRole::where('IS_DELETED', 0)->where('IS_ACTIVE', 1)
        ->where('MODULE_NAME', '<>', 'MASTER')->distinct('MODULE_NAME')
        ->get('MODULE_NAME');
    }

    public function getSiteList(){
        return MstSite::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)->get();
    }

    public function userAccessAdd($requestData, $vvsUserRole)
    {
        $userId = "";
        $processedUserData = [];
        if(isset($requestData -> USER_ID) && $requestData -> USER_ID){
            $userdata = User::where("ID",$requestData -> USER_ID)->where("IS_DELETED",0)->first();
            $userId = $userdata->ID;
        }
        
        DB::beginTransaction();
        try {
        if($requestData -> ACTION == "SAVE") {
            $requestData->EMAIL =  $requestData->EMAIL ??  $this->customDecrypt($userdata->EMAIL);
            $requestData->FIRST_NAME =  $requestData->FIRST_NAME ??  $this->customDecrypt($userdata->FIRST_NAME);
            $requestData->LAST_NAME =  $requestData->LAST_NAME ??  $this->customDecrypt($userdata->LAST_NAME);
            $processedUserData = [
                "EMAIL" => $this->customEncrypt($requestData->EMAIL),
                "FIRST_NAME" => $this->customEncrypt($requestData->FIRST_NAME),
                "LAST_NAME" => $this->customEncrypt($requestData->LAST_NAME)
            ];
        }

        if($requestData -> ACTION == "ACTIVE"){
            $processedUserData["IS_ACTIVE"] = 1;
        }
        if($requestData -> ACTION == "INACTIVE"){
            $processedUserData["IS_ACTIVE"] = 0;
        }
        if($requestData -> ACTION == "DELETE"){
            $processedUserData["IS_DELETED"] = 1;
        }
        
        if( isset($requestData -> USER_ID) &&  $requestData -> USER_ID > 0){
            $processedUserData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedUserData["MODIFIED_ON"] = currentDateTime();
        }else{
            $processedUserData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedUserData["CREATED_ON"] = currentDateTime();
        }
        
        if( $userId > 0 ){
            if (isset($requestData->STATUS) && $requestData->STATUS == 1) {
                $processedUserData["IS_ACTIVE"] = 1;
            } elseif (isset($requestData->STATUS) && $requestData->STATUS == 0) {
                $processedUserData["IS_ACTIVE"] = 0;
            }
            $processedUserData["TICKET_NO"] =  $requestData->TICKET_NO;
            //update User table
            User::where("ID",$userId)->update($processedUserData);
        }else{
            //insert into User table
            if ($requestData->STATUS == 1) {
                $processedUserData["IS_ACTIVE"] = 1;
            } else {
                $processedUserData["IS_ACTIVE"] = 0;
            }
            // prd($processedUserData);
            $userInsert = User::create($processedUserData);
            $userId = $userInsert->ID;
        }

        if ($requestData->ACTION == "SAVE") {
            // Insert into UserMapRole
            $userMapRoleData = $this->transformUserMapRoleTableData($requestData, $userId);
            if (count($userMapRoleData)) {
                // Soft delete old data if exists
                UserMapRole::where("USER_ID", $userId)->where("IS_DELETED", 0)
                           ->update(["IS_DELETED" => 1, "MODIFIED_BY" => $requestData->CREATED_BY, "MODIFIED_ON" => currentDateTime()]);
                // Insert new data
                UserMapRole::insert($userMapRoleData);
            }
        }

        if ($requestData->ACTION == "SAVE") {
            // Insert into UserMapSite
            $userMapSiteData = $this->transformUserMapSiteTableData($requestData, $userId);
            if (count($userMapSiteData)) {
                // Soft delete old data if exists
                UserMapSite::where("USER_ID", $userId)->where("IS_DELETED", 0)
                    ->update(["IS_DELETED" => 1, "MODIFIED_BY" => $requestData->CREATED_BY,
                     "MODIFIED_ON" => currentDateTime()]);
                // Insert new data
                UserMapSite::insert($userMapSiteData);
            }
        }

        $returnmsg = 'Processed successfully';
        $user = User::where("ID",$userId)->first();
        $firstName = $this->customDecrypt($user->FIRST_NAME);
        $lastName = $this->customDecrypt($user->LAST_NAME);
        if($requestData -> ACTION == "SAVE"){            
            if(isset($requestData -> USER_ID) && $requestData -> USER_ID){
                $returnmsg = 'User ('.$firstName.' '.$lastName.') data has been updated successfully.';
            }else{                
                $returnmsg = 'User ('.$firstName.' '.$lastName.') data has been created successfully.'; 
            }
        }
        if($requestData -> ACTION == "ACTIVE"){
            $returnmsg = 'User ('.$firstName.' '.$lastName.') data has been actived successfully.';
        }
        if($requestData -> ACTION == "INACTIVE"){
            $returnmsg = 'User ('.$firstName.' '.$lastName.') data has been inactived successfully.';
        }
        if($requestData -> ACTION == "DELETE"){
            $returnmsg ='User ('.$firstName.' '.$lastName.') data has been deleted successfully.'; 
        }

        DB::commit();

         // If the transaction is committed successfully, you can return a response or perform other actions
         //return User::where("USER_ID",$userId)->pluck("WORKER_AUTO_GEN_ID")->first();
         return $returnmsg;
        
        } catch (\Exception $e) {
        // If an exception occurs during the transaction, rollback the changes
        DB::rollBack();

        prd($e->getMessage());
        // You can handle the exception here, log it, or return an error response
        return "";
        }
    }

    protected function transformUserMapRoleTableData($requestData, $userId)
    {
        $processedData = [];

        if ($requestData->ADMINISTRATOR_PRIVILEGE == 0) {
            if (isset($requestData->ROLE_DTLS) && is_array($requestData->ROLE_DTLS)) {
                foreach ($requestData->ROLE_DTLS as $roleDetail) {
                    $processedData[] = [
                        "USER_ID" => $userId,
                        "MODULE_NAME" => $roleDetail->MODULE_NAME,
                        "ROLE_ID" => $roleDetail->ROLE_ID,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        } elseif ($requestData->ADMINISTRATOR_PRIVILEGE == 1) {
            $processedData[] = [
                "USER_ID" => $userId,
                "MODULE_NAME" => "MASTER",
                "ROLE_ID" => 10,
                "CREATED_BY" => $requestData->CREATED_BY,
                "CREATED_ON" => currentDateTime()
            ];
        }

        return $processedData;
    }

    // protected function transformUserMapRoleTableData($requestData, $userId)
    // {
    //     $processedData = [];
    //     if (isset($requestData->ROLE_DTLS) && is_array($requestData->ROLE_DTLS)) {
    //         foreach ($requestData->ROLE_DTLS as $roleDetail) {
    //             $processedData[] = [
    //                 "USER_ID" => $userId,
    //                 "MODULE_NAME" => $roleDetail->MODULE_NAME,
    //                 "ROLE_ID" => $roleDetail->ROLE_ID,
    //                 "CREATED_BY" => $requestData->CREATED_BY,
    //                 "CREATED_ON" => currentDateTime()
    //             ];
    //         }
    //     }
    //     return $processedData;
    // }

    protected function transformUserMapSiteTableData($requestData, $userId)
    {
        $processedData = [];
        if (isset($requestData->SITE_DTLS) && is_array($requestData->SITE_DTLS)) {
            foreach ($requestData->SITE_DTLS as $siteDetail) {
                $processedData[] = [
                    "USER_ID" => $userId,
                    "SITE_ID" => $siteDetail,
                    "CREATED_BY" => $requestData->CREATED_BY,
                    "CREATED_ON" => currentDateTime()
                ];
            }
        }
        return $processedData;
    }

    public function getUserDetails($requestData)
    {
        return User::where("ID", $requestData->USER_ID)->first();
    }

}