<?php

namespace App\Services\Master;

use App\Http\Resources\Master\MasterTypeTopicResource;
use App\Models\TrainingMstType;
use App\Models\TrainingMstTopic;
use App\Models\MstSite;
use App\Models\UserMapRole;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterTypeTopicServices extends MasterTypeTopicResource
{
    public $vvsUserModel;
    public $page;
    public $pageSize;
    public function __construct() {
        $this->vvsTrainingMstTopicModel = new TrainingMstType();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'TR_TOPIC_NAME' => 'TR_MST_TOPIC.TR_TOPIC_NAME',
            'TR_TYPE_ID' => 'TR_MST_TYPE.TR_TYPE_ID',
        ];
    }
    
    public function getMasterTypeTopicList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query = TrainingMstType::query();
        $query->with('topicMappings'); // Eager load the topicMappings relationship

        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($columnMapping[$key])) {
                if ($key === 'TR_TYPE_ID') {
                    $query->where('TR_MST_TYPE.TR_TYPE_ID', $value);
                } elseif ($key === 'TR_TOPIC_NAME') {
                    $query->whereHas('topicMappings', function ($query) use ($value) {
                        $query->where('TR_MST_TOPIC.TR_TOPIC_NAME', 'ILIKE', "%$value%");
                    });
                }
            }
        }
    
        $query->where("TR_MST_TYPE.IS_DELETED", 0);
        $query->orderBy("TR_MST_TYPE.TR_TYPE_ID", "DESC");
    
        $totalCount = $query->count('TR_MST_TYPE.TR_TYPE_ID');

        // Pagination Logic
        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

        $paginatedTypeTopicData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedTypeTopicData,
            'total' => $totalCount // Total count of distinct TrainingMstType IDs
        ];
    }

    // public function getModuleNameList(){
    //     return UserMapRole::where('IS_DELETED', 0)->where('IS_ACTIVE', 1)->distinct('MODULE_NAME')
    //     ->get('MODULE_NAME');
    // }

    public function typeTopicAdd($requestData, $vvsUserRole)
    {
        // prd(12);
        $typeId = "";
        $topicId = "";
        $processedTypeData = [];
        $processedTopicData = [];
        if(isset($requestData -> TR_TYPE_ID) && $requestData -> TR_TYPE_ID > 0){
            $typedata = TrainingMstType::where("TR_TYPE_ID",$requestData -> TR_TYPE_ID)->where("IS_DELETED",0)->first();
            $typeId = $typedata->TR_TYPE_ID;
        }
        if(isset($requestData -> TR_TOPIC_ID) && $requestData -> TR_TOPIC_ID > 0){
            $topicdata = TrainingMstTopic::where("TR_TOPIC_ID",$requestData -> TR_TOPIC_ID)->where("IS_DELETED",0)->first();
            $topicId = $topicdata->TR_TOPIC_ID;
        }
        
        DB::beginTransaction();
        try {
        if($requestData -> ACTION == "SAVE"){
            $requestData->TR_TYPE_NAME =  $requestData->TR_TYPE_NAME ??  $typedata->TR_TYPE_NAME;
            $requestData->CATEGORY =  $requestData->CATEGORY ??  $typedata->CATEGORY;
            $processedTypeData = [
                "TR_TYPE_NAME" => $requestData->TR_TYPE_NAME,
                "CATEGORY"     => $requestData->CATEGORY
            ];
        }
        if (isset($requestData -> TR_TYPE_ID) &&  $requestData -> TR_TYPE_ID > 0) {
            $processedTypeData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedTypeData["MODIFIED_ON"] = currentDateTime();
        }else {
            $processedTypeData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedTypeData["CREATED_ON"] = currentDateTime();
        }
        if ($typeId > 0) {
            TrainingMstType::where("TR_TYPE_ID", $typeId)->update($processedTypeData);
        }else {
            $typeInsert = TrainingMstType::create($processedTypeData);
            $typeId = $typeInsert->TR_TYPE_ID;
        }


        if($requestData -> ACTION == "SAVE") {
            $requestData->TR_TOPIC_NAME = $requestData->TR_TOPIC_NAME ??  $typedata->TR_TOPIC_NAME;
            $requestData->TR_TYPE_ID = $typeId;
            $processedTopicData = [
                "TR_TOPIC_NAME" => $requestData->TR_TOPIC_NAME,
                "TR_TYPE_ID"    => (int)$requestData->TR_TYPE_ID
            ];
        }
        if ($requestData -> ACTION == "DELETE") {
            $processedTopicData["IS_DELETED"] = 1;
        }
        if (isset($requestData -> TR_TOPIC_ID) &&  $requestData -> TR_TOPIC_ID > 0) {
            $processedTopicData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedTopicData["MODIFIED_ON"] = currentDateTime();
        }else {
            $processedTopicData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedTopicData["CREATED_ON"] = currentDateTime();
        }
        if ($topicId > 0) {
            TrainingMstTopic::where("TR_TOPIC_ID", $topicId)->update($processedTopicData);
        }else {
            $topicInsert = TrainingMstTopic::create($processedTopicData);
            $topicId = $topicInsert->TR_TOPIC_ID;
        }

        $returnmsg = 'Processed successfully';
        $typeName = TrainingMstType::where("TR_TYPE_ID", $typeId)->pluck("TR_TYPE_NAME")->first();
        $topicName = TrainingMstTopic::where("TR_TOPIC_ID", $topicId)->pluck("TR_TOPIC_NAME")->first();
        if($requestData -> ACTION == "SAVE"){            
            if(isset($requestData -> TR_TOPIC_ID) && $requestData -> TR_TOPIC_ID > 0){
                $returnmsg = 'Type ('.$typeName.') and Topic ('.$topicName.') data has been updated successfully.';
            }else{
                $returnmsg = 'Type ('.$typeName.') and Topic ('.$topicName.') data has been created successfully.'; 
            }
        }
        // if($requestData -> ACTION == "ACTIVE"){
        //     $returnmsg = 'TrainingMstType ('.$firstName.' '.$lastName.') data has been actived successfully.';
        // }
        // if($requestData -> ACTION == "INACTIVE"){
        //     $returnmsg = 'TrainingMstType ('.$firstName.' '.$lastName.') data has been inactived successfully.';
        // }
        if($requestData -> ACTION == "DELETE"){
            $returnmsg ='Type ('.$typeName.') and Topic ('.$topicName.') data has been deleted successfully.';
        }

        DB::commit();

         // If the transaction is committed successfully, you can return a response or perform other actions
         //return TrainingMstType::where("USER_ID",$userId)->pluck("WORKER_AUTO_GEN_ID")->first();
         return $returnmsg;
        
        } catch (\Exception $e) {
        // If an exception occurs during the transaction, rollback the changes
        DB::rollBack();

        prd($e->getMessage());
        // You can handle the exception here, log it, or return an error response
        return "";
        }
    }

    // protected function transformUserMapRoleTableData($requestData, $userId)
    // {
    //     $processedData = [];
    //     if (isset($requestData->ROLE_DTLS) && is_array($requestData->ROLE_DTLS)) {
    //         foreach ($requestData->ROLE_DTLS as $roleDetail) {
    //             $processedData[] = [
    //                 "USER_ID" => $userId,
    //                 "MODULE_NAME" => $roleDetail->MODULE_NAME,
    //                 "ROLE_ID" => $roleDetail->ROLE_ID,
    //                 "CREATED_BY" => $requestData->CREATED_BY,
    //                 "CREATED_ON" => currentDateTime()
    //             ];
    //         }
    //     }
    //     return $processedData;
    // }

    public function getTopicDetails($requestData)
    {
        return TrainingMstTopic::where("TR_TOPIC_ID", $requestData->TR_TOPIC_ID)->first();
    }

}