<?php

namespace App\Services\Master;

use App\Http\Resources\Master\MasterSkillResource;
use App\Models\PtwMstType;
use App\Models\MstSite;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterSkillServices extends MasterSkillResource
{
    public $vvsPtwMstTypeModel;
    public $page;
    public $pageSize;
    public function __construct() {
        $this->vvsPtwMstTypeModel = new PtwMstType();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'TYPE_NAME' => 'TYPE_NAME',
        ];
    }
    
    public function getMasterSkillList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query = PtwMstType::query();

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Special handling for TYPE_NAME to make it case-insensitive
            if ($key === 'TYPE_NAME') {
                $query->where($columnMapping[$key], 'ILIKE', "%$value%");
            } else {
                // Add a where clause for the mapped column name
                $query->where($columnMapping[$key], $value);
            }
            }
        }

        $query->where("IS_DELETED", 0);
        $query->orderBy("TYPE_ID", "DESC");

        $totalCount = $query->count('TYPE_ID');

        // Pagination Logic
        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

        $paginatedSkillData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedSkillData,
            'total' => $totalCount // Total count of distinct worker IDs
        ];
    }

    public function skillAdd($requestData, $vvsUserRole)
    {
        $typeId = "";
        $processedTypeData = [];
        $typedata = null;
        if (isset($requestData -> TYPE_ID) && $requestData -> TYPE_ID > 0) {
            $typedata = PtwMstType::where("TYPE_ID", $requestData -> TYPE_ID)
                                    ->where("IS_DELETED", 0)->first();
            $typeId = $typedata->TYPE_ID;
        }
        
        DB::beginTransaction();
        try {
        if ($requestData -> ACTION == "SAVE") {
            $requestData->TYPE_NAME =  $requestData->TYPE_NAME ??  $typedata->TYPE_NAME;
           
            $processedTypeData = [
                "TYPE_NAME" => $requestData->TYPE_NAME,
            ];
           
        }
        
        if ($requestData -> ACTION == "APPROVE") {
            $processedTypeData["IS_ACTIVE"] = 1;
        }
        if ($requestData -> ACTION == "DELETE") {
            $processedTypeData["IS_DELETED"] = 1;
        }
        
        if (isset($requestData -> TYPE_ID) &&  $requestData -> TYPE_ID > 0) {
            $processedTypeData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedTypeData["MODIFIED_ON"] = currentDateTime();
        }else {
            $processedTypeData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedTypeData["CREATED_ON"] = currentDateTime();
        }
        
        
        if ($typeId > 0) {
            //update PtwMstType table
            PtwMstType::where("TYPE_ID", $typeId)->update($processedTypeData);
        }else {
            //insert into PtwMstType table
            if ($vvsUserRole == 10) {
                $processedTypeData["IS_ACTIVE"] = 1;
            } else {
                $processedTypeData["IS_ACTIVE"] = 0;
            }
            $typeInsert = PtwMstType::create($processedTypeData);
            $typeId = $typeInsert->TYPE_ID;
        }

        $returnmsg = 'Processed successfully';
        $typeName = PtwMstType::where("TYPE_ID", $typeId)->pluck("TYPE_NAME")->first();
        if($requestData -> ACTION == "SAVE"){
            if(isset($requestData -> TYPE_ID) && $requestData -> TYPE_ID > 0){
                $returnmsg = 'Skill ('.$typeName.') data has been updated successfully.';
            }else{                
                $returnmsg = 'Skill ('.$typeName.') data has been created successfully.';
            }
        }
        if($requestData -> ACTION == "APPROVE"){
            $returnmsg = 'Skill ('.$typeName.') data has been approved successfully.';
        }
        if($requestData -> ACTION == "DELETE"){
            $returnmsg ='Skill ('.$typeName.') data has been deleted successfully.';
        }

        DB::commit();

         // If the transaction is committed successfully, you can return a response or perform other actions
         return $returnmsg;
        
        } catch (\Exception $e) {
        // If an exception occurs during the transaction, rollback the changes
        DB::rollBack();

        prd($e->getMessage());
        // You can handle the exception here, log it, or return an error response
        return "Error occurred while saving data.";
        }
    }

    public function getSkillDetails($requestData)
    {
        return PtwMstType::where("TYPE_ID", $requestData->TYPE_ID)->first();
    }
}