<?php

namespace App\Services\Master;

use App\Http\Resources\Master\MasterSOPPolicyResource;
use App\Models\PtwMstSoapPolicies;
use App\Models\MstSite;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterSOPPolicyServices extends MasterSOPPolicyResource
{
    public $vvsPtwMstSoapPoliciesModel;
    public $page;
    public $pageSize;
    public function __construct() {
        $this->vvsPtwMstSoapPoliciesModel = new PtwMstSoapPolicies();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'NAME' => 'NAME',
            'REFRENCE_NO' => 'REFRENCE_NO'
        ];
    }
    
    public function getMasterSOPPolicylList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query = PtwMstSoapPolicies::query();

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Special handling for NAME to make it case-insensitive
            if ($key === 'NAME' || $key === 'REFRENCE_NO') {
                $query->where($columnMapping[$key], 'ILIKE', "%$value%");
            } else {
                // Add a where clause for the mapped column name
                $query->where($columnMapping[$key], $value);
            }
            }
        }

        $query->where("IS_DELETED", 0);
        $query->orderBy("SOP_POLICY_ID", "DESC");

        $totalCount = $query->count('SOP_POLICY_ID');

        // Pagination Logic
        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

        $paginatedSOPPolicyData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedSOPPolicyData,
            'total' => $totalCount // Total count of distinct worker IDs
        ];
    }

    public function sopPolicyAdd($requestData, $vvsUserRole)
    {
        $sopId = "";
        $processedsopPolicyData = [];
        $sopdata = null;
        if (isset($requestData -> SOP_POLICY_ID) && $requestData -> SOP_POLICY_ID > 0) {
            $sopdata = PtwMstSoapPolicies::where("SOP_POLICY_ID", $requestData -> SOP_POLICY_ID)
                                    ->where("IS_DELETED", 0)->first();
            $sopId = $sopdata->SOP_POLICY_ID;
        }
        
        DB::beginTransaction();
        try {
        if ($requestData -> ACTION == "SAVE") {
            $requestData->NAME =  $requestData->NAME ??  $sopdata->NAME;
            $requestData->REFRENCE_NO =  $requestData->REFRENCE_NO ??  $sopdata->REFRENCE_NO;
           
            $processedsopPolicyData = [
                "NAME" => $requestData->NAME,
                "REFRENCE_NO" => $requestData->REFRENCE_NO,
            ];
           
        }
        
        if ($requestData -> ACTION == "APPROVE") {
            $processedsopPolicyData["IS_ACTIVE"] = 1;
        }
        if ($requestData -> ACTION == "DELETE") {
            $processedsopPolicyData["IS_DELETED"] = 1;
        }
        
        if (isset($requestData -> SOP_POLICY_ID) &&  $requestData -> SOP_POLICY_ID > 0) {
            $processedsopPolicyData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedsopPolicyData["MODIFIED_ON"] = currentDateTime();
        }else {
            $processedsopPolicyData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedsopPolicyData["CREATED_ON"] = currentDateTime();
        }
        
        
        if ($sopId > 0) {
            //update PtwMstSoapPolicies table
            PtwMstSoapPolicies::where("SOP_POLICY_ID", $sopId)->update($processedsopPolicyData);
        }else {
            //insert into PtwMstSoapPolicies table
            if ($vvsUserRole == 10) {
                $processedsopPolicyData["IS_ACTIVE"] = 1;
            } else {
                $processedsopPolicyData["IS_ACTIVE"] = 0;
            }
            $sopInsert = PtwMstSoapPolicies::create($processedsopPolicyData);
            $sopId = $sopInsert->SOP_POLICY_ID;
        }

        $returnmsg = 'Processed successfully';
        $sopName = PtwMstSoapPolicies::where("SOP_POLICY_ID", $sopId)->pluck("REFRENCE_NO")->first();
        if($requestData -> ACTION == "SAVE"){
            if(isset($requestData -> SOP_POLICY_ID) && $requestData -> SOP_POLICY_ID > 0){
                $returnmsg = 'Refrence No ('.$sopName.') data has been updated successfully.';
            }else{                
                $returnmsg = 'Refrence No ('.$sopName.') data has been created successfully.';
            }
        }
        if($requestData -> ACTION == "APPROVE"){
            $returnmsg = 'Refrence No ('.$sopName.') data has been approved successfully.';
        }
        if($requestData -> ACTION == "DELETE"){
            $returnmsg ='Refrence No ('.$sopName.') data has been deleted successfully.';
        }

        DB::commit();

         // If the transaction is committed successfully, you can return a response or perform other actions
         return $returnmsg;
        
        } catch (\Exception $e) {
        // If an exception occurs during the transaction, rollback the changes
        DB::rollBack();

        prd($e->getMessage());
        // You can handle the exception here, log it, or return an error response
        return "Error occurred while saving data.";
        }
    }

    public function getSOPPolicyDetails($requestData)
    {
        return PtwMstSoapPolicies::where("SOP_POLICY_ID", $requestData->SOP_POLICY_ID)->first();
    }
}