<?php

namespace App\Services\Master;

use App\Http\Resources\Master\MasterRiskRelatedResource;
use App\Models\HiraMstRiskRelated;
use App\Models\HiraActivity;
use App\Models\MstSite;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterRiskRelatedServices extends MasterRiskRelatedResource
{
    public $vvsHiraMstRiskRelatedModel;
    public $page;
    public $pageSize;
    public function __construct() {
        $this->vvsHiraMstRiskRelatedModel = new HiraMstRiskRelated();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'ACTIVITY_ID' => 'ACTIVITY_ID',
            'RISK_RELATED_NAME' => 'RISK_RELATED_NAME',
        ];
    }
    
    public function getMasterRiskRelatedList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query = HiraMstRiskRelated::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['activity'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Special handling for RISK_RELATED_NAME to make it case-insensitive
            if ($key === 'RISK_RELATED_NAME') {
                $query->where($columnMapping[$key], 'ILIKE', "%$value%");
            } else {
                // Add a where clause for the mapped column name
                $query->where($columnMapping[$key], $value);
            }
            }
        }

        $query->where("IS_DELETED", 0);
        $query->orderBy("RISK_RELATED_ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);

        $totalCount = $query->count('RISK_RELATED_ID');

        // Pagination Logic
        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

        $paginatedRiskRelatedData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedRiskRelatedData,
            'total' => $totalCount // Total count of distinct worker IDs
        ];
    }

    public function getRiskRelatedIdsFromHira()
    {
        return HiraActivity::distinct()->pluck('RISK_RELATED_ID');
    }

    public function riskRelatedSave($requestData, $vvsUserRole)
    {
        $riskRelatedId = "";
        $processedRiskRelatedData = [];
        $riskRelatedData = null;
        if (isset($requestData -> RISK_RELATED_ID) && $requestData -> RISK_RELATED_ID > 0) {
            $riskRelatedData = HiraMstRiskRelated::where("RISK_RELATED_ID", $requestData -> RISK_RELATED_ID)
                                    ->where("IS_DELETED", 0)->first();
            $riskRelatedId = $riskRelatedData->RISK_RELATED_ID;
        }
        
        DB::beginTransaction();
        try {
        if ($requestData -> ACTION == "SAVE") {
            $requestData->RISK_RELATED_NAME =  $requestData->RISK_RELATED_NAME ??  $riskRelatedData->RISK_RELATED_NAME;
            $requestData->ACTIVITY_ID       =  $requestData->ACTIVITY_ID ??  $riskRelatedData->ACTIVITY_ID;
           
            $processedRiskRelatedData = [
                "ACTIVITY_ID"       => (int)$requestData->ACTIVITY_ID,
                "RISK_RELATED_NAME" => $requestData->RISK_RELATED_NAME,
            ];
           
        }
        
        // if ($requestData -> ACTION == "APPROVE") {
        //     $processedRiskRelatedData["IS_ACTIVE"] = 1;
        // }
        if ($requestData -> ACTION == "DELETE") {
            $processedRiskRelatedData["IS_DELETED"] = 1;
        }
        
        if (isset($requestData -> RISK_RELATED_ID) &&  $requestData -> RISK_RELATED_ID > 0) {
            $processedRiskRelatedData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedRiskRelatedData["MODIFIED_ON"] = currentDateTime();
        }else {
            $processedRiskRelatedData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedRiskRelatedData["CREATED_ON"] = currentDateTime();
        }
        
        
        if ($riskRelatedId > 0) {
            //update HiraMstRiskRelated table
            HiraMstRiskRelated::where("RISK_RELATED_ID", $riskRelatedId)->update($processedRiskRelatedData);
        }else {
            //insert into HiraMstRiskRelated table
            // if ($vvsUserRole == 10) {
            //     $processedRiskRelatedData["IS_ACTIVE"] = 1;
            // } else {
            //     $processedRiskRelatedData["IS_ACTIVE"] = 0;
            // }
            $riskRelatedInsert = HiraMstRiskRelated::create($processedRiskRelatedData);
            $riskRelatedId = $riskRelatedInsert->RISK_RELATED_ID;
        }

        $returnmsg = 'Processed successfully';
        $riskRelatedName = HiraMstRiskRelated::where("RISK_RELATED_ID", $riskRelatedId)->pluck("RISK_RELATED_NAME")->first();
        if($requestData -> ACTION == "SAVE"){
            if(isset($requestData -> RISK_RELATED_ID) && $requestData -> RISK_RELATED_ID > 0){
                $returnmsg = 'Risk Related ('.$riskRelatedName.') data has been updated successfully.';
            }else{                
                $returnmsg = 'Risk Related ('.$riskRelatedName.') data has been created successfully.'; 
            }
        }
        // if($requestData -> ACTION == "APPROVE"){
        //     $returnmsg = 'Risk Related ('.$riskRelatedName.') data has been approved successfully.';
        // }
        if($requestData -> ACTION == "DELETE"){
            $returnmsg ='Risk Related ('.$riskRelatedName.') data has been deleted successfully.';
        }

        DB::commit();

         // If the transaction is committed successfully, you can return a response or perform other actions
         return $returnmsg;
        
        } catch (\Exception $e) {
        // If an exception occurs during the transaction, rollback the changes
        DB::rollBack();

        prd($e->getMessage());
        // You can handle the exception here, log it, or return an error response
        return "Error occurred while saving data.";
        }
    }

    public function getRiskRelatedDetails($requestData)
    {
        return HiraMstRiskRelated::where("RISK_RELATED_ID", $requestData->RISK_RELATED_ID)->first();
    }
}