<?php

namespace App\Services\Master;

use App\Http\Resources\Master\MasterLocationResource;
use App\Models\MstLocation;
use App\Models\MstSite;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterLocationServices extends MasterLocationResource
{
    public $vvsMstLocationModel;
    public $page;
    public $pageSize;
    public function __construct() {
        $this->vvsMstLocationModel = new MstLocation();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'LOCATION_NAME' => 'LOCATION_NAME',
        ];
    }
    
    public function getMasterLocationList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query = MstLocation::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Special handling for LOCATION_NAME to make it case-insensitive
            if ($key === 'LOCATION_NAME') {
                $query->where($columnMapping[$key], 'ILIKE', "%$value%");
            } else {
                // Add a where clause for the mapped column name
                $query->where($columnMapping[$key], $value);
            }
            }
        }

        $query->where("IS_DELETED", 0);
        $query->orderBy("LOCATION_ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);

        $totalCount = $query->count('LOCATION_ID');

        // Pagination Logic
        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

        $paginatedLocationData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedLocationData,
            'total' => $totalCount // Total count of distinct worker IDs
        ];
    }

    public function locationSave($requestData, $vvsUserRole)
    {
        $locationId = "";
        $processedLocationData = [];
        $locationdata = null;
        if (isset($requestData -> LOCATION_ID) && $requestData -> LOCATION_ID > 0) {
            $locationdata = MstLocation::where("LOCATION_ID", $requestData -> LOCATION_ID)
                                    ->where("IS_DELETED", 0)->first();
            $locationId = $locationdata->LOCATION_ID;
        }
        
        DB::beginTransaction();
        try {
        if ($requestData -> ACTION == "SAVE") {
            $requestData->LOCATION_NAME =  $requestData->LOCATION_NAME ??  $locationdata->LOCATION_NAME;
            $requestData->SITE_ID       =  $requestData->SITE_ID ??  $locationdata->SITE_ID;
            $requestData->BUILDING = (isset($requestData->BUILDING) && $requestData->BUILDING !== "") ? $requestData->BUILDING : 
                ((isset($locationdata->BUILDING) && $locationdata->BUILDING !== "") ? $locationdata->BUILDING : "");

            $requestData->FLOOR = (isset($requestData->FLOOR) && $requestData->FLOOR !== "") ? $requestData->FLOOR : 
                ((isset($locationdata->FLOOR) && $locationdata->FLOOR !== "") ? $locationdata->FLOOR : "");

            $requestData->WING = (isset($requestData->WING) && $requestData->WING !== "") ? $requestData->WING : 
                ((isset($locationdata->WING) && $locationdata->WING !== "") ? $locationdata->WING : "");

            $requestData->DEPARTMENT = (isset($requestData->DEPARTMENT) && $requestData->DEPARTMENT !== "") ? $requestData->DEPARTMENT : 
               ((isset($locationdata->DEPARTMENT) && $locationdata->DEPARTMENT !== "") ? $locationdata->DEPARTMENT : "");

            $requestData->CHECKLIST = (isset($requestData->CHECKLIST) && $requestData->CHECKLIST !== "") ? $requestData->CHECKLIST : 
                ((isset($locationdata->CHECKLIST) && $locationdata->CHECKLIST !== "") ? $locationdata->CHECKLIST : "");

            $requestData->ASSIGNED_DEPT = (isset($requestData->ASSIGNED_DEPT) && $requestData->ASSIGNED_DEPT !== "") ? $requestData->ASSIGNED_DEPT : 
                ((isset($locationdata->ASSIGNED_DEPT) && $locationdata->ASSIGNED_DEPT !== "") ? $locationdata->ASSIGNED_DEPT : "");

            $requestData->QR_CODE = (isset($requestData->QR_CODE) && $requestData->QR_CODE !== "") ? $requestData->QR_CODE : 
                ((isset($locationdata->QR_CODE) && $locationdata->QR_CODE !== "") ? $locationdata->QR_CODE : "");

            
            $processedLocationData = [
                "SITE_ID"       => (int)$requestData->SITE_ID,
                "LOCATION_NAME" => $requestData->LOCATION_NAME,
                "BUILDING"      => $requestData->BUILDING,
                "FLOOR"         => $requestData->FLOOR,
                "WING"          => $requestData->WING,
                "DEPARTMENT"    => $requestData->DEPARTMENT,
                "CHECKLIST"     => $requestData->CHECKLIST,
                "ASSIGNED_DEPT" => $requestData->ASSIGNED_DEPT,
                "QR_CODE"       => $requestData->QR_CODE,
            ];
           
        }
        
        if ($requestData -> ACTION == "APPROVE") {
            $processedLocationData["IS_ACTIVE"] = 1;
        }
        if ($requestData -> ACTION == "DELETE") {
            $processedLocationData["IS_DELETED"] = 1;
        }
        
        if (isset($requestData -> LOCATION_ID) &&  $requestData -> LOCATION_ID > 0) {
            $processedLocationData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedLocationData["MODIFIED_ON"] = currentDateTime();
        }else {
            $processedLocationData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedLocationData["CREATED_ON"] = currentDateTime();
        }
        
        
        if ($locationId > 0) {
            //update MstLocation table
            MstLocation::where("LOCATION_ID", $locationId)->update($processedLocationData);
        }else {
            //insert into MstLocation table
            if ($vvsUserRole == 10) {
                $processedLocationData["IS_ACTIVE"] = 1;
            } else {
                $processedLocationData["IS_ACTIVE"] = 0;
            }
            $locationInsert = MstLocation::create($processedLocationData);
            $locationId = $locationInsert->LOCATION_ID;
        }

        $returnmsg = 'Processed successfully';
        $locationName = MstLocation::where("LOCATION_ID", $locationId)->pluck("LOCATION_NAME")->first();
        if($requestData -> ACTION == "SAVE"){
            if(isset($requestData -> LOCATION_ID) && $requestData -> LOCATION_ID > 0){
                $returnmsg = 'Location ('.$locationName.') data has been updated successfully.';
            }else{                
                $returnmsg = 'Location ('.$locationName.') data has been created successfully.'; 
            }
        }
        if($requestData -> ACTION == "APPROVE"){
            $returnmsg = 'Location ('.$locationName.') data has been approved successfully.';
        }
        if($requestData -> ACTION == "DELETE"){
            $returnmsg ='Location ('.$locationName.') data has been deleted successfully.';
        }

        DB::commit();

         // If the transaction is committed successfully, you can return a response or perform other actions
         return $returnmsg;
        
        } catch (\Exception $e) {
        // If an exception occurs during the transaction, rollback the changes
        DB::rollBack();

        prd($e->getMessage());
        // You can handle the exception here, log it, or return an error response
        return "Error occurred while saving data.";
        }
    }

    public function getLocationDetails($requestData)
    {
        return MstLocation::where("LOCATION_ID", $requestData->LOCATION_ID)->first();
    }
}