<?php

namespace App\Services\Master;

use App\Http\Resources\Master\MasterJobResource;
use App\Models\HiraMstJob;
use App\Models\HiraActivity;
use App\Models\HiraMstActivity;
use App\Models\MstSite;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterJobServices extends MasterJobResource
{
    public $vvsHiraMstJobModel;
    public $page;
    public $pageSize;
    public function __construct() {
        $this->vvsHiraMstJobModel = new HiraMstJob();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'JOB_NAME' => 'JOB_NAME',
        ];
    }
    
    public function getMasterJobList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query = HiraMstJob::query();
        // Define the relationships to eager load
        // $relationshipsToLoad = ['site'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Special handling for JOB_NAME to make it case-insensitive
            if ($key === 'JOB_NAME') {
                $query->where($columnMapping[$key], 'ILIKE', "%$value%");
            } else {
                // Add a where clause for the mapped column name
                $query->where($columnMapping[$key], $value);
            }
            }
        }

        $query->where("IS_DELETED", 0);
        $query->orderBy("JOB_ID", "DESC");
        // Eager load the specified relationships
        // $query->with($relationshipsToLoad);

        $totalCount = $query->count('JOB_ID');

        // Pagination Logic
        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

        $paginatedJobData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedJobData,
            'total' => $totalCount // Total count of distinct worker IDs
        ];
    }

    public function getJobIdsFromHira()
    {
        return HiraActivity::distinct()->pluck('JOB_ID');
    }

    public function getJobIdsFromActivity()
    {
        return HiraMstActivity::distinct()->pluck('JOB_ID');
    }

    public function jobSave($requestData, $vvsUserRole)
    {
        $jobId = "";
        $processedJobData = [];
        $jobdata = null;
        if (isset($requestData -> JOB_ID) && $requestData -> JOB_ID > 0) {
            $jobdata = HiraMstJob::where("JOB_ID", $requestData -> JOB_ID)
                                    ->where("IS_DELETED", 0)->first();
            $jobId = $jobdata->JOB_ID;
        }
        
        DB::beginTransaction();
        try {
        if ($requestData -> ACTION == "SAVE") {
            $requestData->JOB_NAME =  $requestData->JOB_NAME ??  $jobdata->JOB_NAME;
           
            $processedJobData = [
                "JOB_NAME" => $requestData->JOB_NAME,
            ];
           
        }
        
        // if ($requestData -> ACTION == "APPROVE") {
        //     $processedJobData["IS_ACTIVE"] = 1;
        // }
        if ($requestData -> ACTION == "DELETE") {
            $processedJobData["IS_DELETED"] = 1;
        }
        
        if (isset($requestData -> JOB_ID) &&  $requestData -> JOB_ID > 0) {
            $processedJobData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedJobData["MODIFIED_ON"] = currentDateTime();
        }else {
            $processedJobData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedJobData["CREATED_ON"] = currentDateTime();
        }
        
        
        if ($jobId > 0) {
            //update HiraMstJob table
            HiraMstJob::where("JOB_ID", $jobId)->update($processedJobData);
        }else {
            //insert into HiraMstJob table
            // if ($vvsUserRole == 10) {
            //     $processedJobData["IS_ACTIVE"] = 1;
            // } else {
            //     $processedJobData["IS_ACTIVE"] = 0;
            // }
            $jobInsert = HiraMstJob::create($processedJobData);
            $jobId = $jobInsert->JOB_ID;
        }

        $returnmsg = 'Processed successfully';
        $jobName = HiraMstJob::where("JOB_ID", $jobId)->pluck("JOB_NAME")->first();
        if($requestData -> ACTION == "SAVE"){
            if(isset($requestData -> JOB_ID) && $requestData -> JOB_ID > 0){
                $returnmsg = 'Job ('.$jobName.') data has been updated successfully.';
            }else{
                $returnmsg = 'Job ('.$jobName.') data has been created successfully.';
            }
        }
        // if($requestData -> ACTION == "APPROVE"){
        //     $returnmsg = 'Job ('.$jobName.') data has been approved successfully.';
        // }
        if($requestData -> ACTION == "DELETE"){
            $returnmsg ='Job ('.$jobName.') data has been deleted successfully.';
        }

        DB::commit();

         // If the transaction is committed successfully, you can return a response or perform other actions
         return $returnmsg;
        
        } catch (\Exception $e) {
        // If an exception occurs during the transaction, rollback the changes
        DB::rollBack();

        prd($e->getMessage());
        // You can handle the exception here, log it, or return an error response
        return "Error occurred while saving data.";
        }
    }

    public function getJobDetails($requestData)
    {
        return HiraMstJob::where("JOB_ID", $requestData->JOB_ID)->first();
    }
}