<?php

namespace App\Services\Master;

use App\Http\Resources\Master\MasterContractorResource;
use App\Models\PtwMstContractor;
use App\Models\MstSite;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterContractorServices extends MasterContractorResource
{
    public $vvsPtwMstContractorModel;
    public $page;
    public $pageSize;
    public function __construct() {
        $this->vvsPtwMstContractorModel = new PtwMstContractor();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'CONTRACTOR_NAME' => 'CONTRACTOR_NAME',
        ];
    }
    
    public function getMasterContractorList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query = PtwMstContractor::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Special handling for CONTRACTOR_NAME to make it case-insensitive
            if ($key === 'CONTRACTOR_NAME') {
                $query->where($columnMapping[$key], 'ILIKE', "%$value%");
            } else {
                // Add a where clause for the mapped column name
                $query->where($columnMapping[$key], $value);
            }
            }
        }

        $query->where("IS_DELETED", 0);
        $query->orderBy("CONTRACTOR_ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);

        $totalCount = $query->count('CONTRACTOR_ID');

        // Pagination Logic
        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

        $paginatedContractorData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedContractorData,
            'total' => $totalCount // Total count of distinct worker IDs
        ];
    }

    public function contractorSave($requestData, $vvsUserRole)
    {
        $contractorId = "";
        $processedContractorData = [];
        $contractordata = null;
        if (isset($requestData -> CONTRACTOR_ID) && $requestData -> CONTRACTOR_ID > 0) {
            $contractordata = PtwMstContractor::where("CONTRACTOR_ID", $requestData -> CONTRACTOR_ID)
                                    ->where("IS_DELETED", 0)->first();
            $contractorId = $contractordata->CONTRACTOR_ID;
        }
        
        DB::beginTransaction();
        try {
        if ($requestData -> ACTION == "SAVE") {
            $requestData->CONTRACTOR_NAME =  $requestData->CONTRACTOR_NAME ??  $contractordata->CONTRACTOR_NAME;
            $requestData->SITE_ID       =  $requestData->SITE_ID ??  $contractordata->SITE_ID;
           
            $processedContractorData = [
                "SITE_ID"       => (int)$requestData->SITE_ID,
                "CONTRACTOR_NAME" => $requestData->CONTRACTOR_NAME,
            ];
           
        }
        
        if ($requestData -> ACTION == "APPROVE") {
            $processedContractorData["IS_ACTIVE"] = 1;
        }
        if ($requestData -> ACTION == "DELETE") {
            $processedContractorData["IS_DELETED"] = 1;
        }
        
        if (isset($requestData -> CONTRACTOR_ID) &&  $requestData -> CONTRACTOR_ID > 0) {
            $processedContractorData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedContractorData["MODIFIED_ON"] = currentDateTime();
        }else {
            $processedContractorData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedContractorData["CREATED_ON"] = currentDateTime();
        }
        
        
        if ($contractorId > 0) {
            //update PtwMstContractor table
            PtwMstContractor::where("CONTRACTOR_ID", $contractorId)->update($processedContractorData);
        }else {
            //insert into PtwMstContractor table
            if ($vvsUserRole == 10) {
                $processedContractorData["IS_ACTIVE"] = 1;
            } else {
                $processedContractorData["IS_ACTIVE"] = 0;
            }
            $contractorInsert = PtwMstContractor::create($processedContractorData);
            $contractorId = $contractorInsert->CONTRACTOR_ID;
        }

        $returnmsg = 'Processed successfully';
        $contractorName = PtwMstContractor::where("CONTRACTOR_ID", $contractorId)->pluck("CONTRACTOR_NAME")->first();
        if($requestData -> ACTION == "SAVE"){
            if(isset($requestData -> CONTRACTOR_ID) && $requestData -> CONTRACTOR_ID > 0){
                $returnmsg = 'Contractor ('.$contractorName.') data has been updated successfully.';
            }else{                
                $returnmsg = 'Contractor ('.$contractorName.') data has been created successfully.'; 
            }
        }
        if($requestData -> ACTION == "APPROVE"){
            $returnmsg = 'Contractor ('.$contractorName.') data has been approved successfully.';
        }
        if($requestData -> ACTION == "DELETE"){
            $returnmsg ='Contractor ('.$contractorName.') data has been deleted successfully.';
        }

        DB::commit();

         // If the transaction is committed successfully, you can return a response or perform other actions
         return $returnmsg;
        
        } catch (\Exception $e) {
        // If an exception occurs during the transaction, rollback the changes
        DB::rollBack();

        prd($e->getMessage());
        // You can handle the exception here, log it, or return an error response
        return "Error occurred while saving data.";
        }
    }

    public function getContractorDetails($requestData)
    {
        return PtwMstContractor::where("CONTRACTOR_ID", $requestData->CONTRACTOR_ID)->first();
    }
}