<?php

namespace App\Services\Master;

use App\Http\Resources\Master\MasterActivityResource;
use App\Models\HiraMstActivity;
use App\Models\HiraMstRiskRelated;
use App\Models\HiraMapActivityType;
use App\Models\MstSite;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class MasterActivityServices extends MasterActivityResource
{
    public $vvsHiraMstActivityModel;
    public $page;
    public $pageSize;
    public function __construct() {
        $this->vvsHiraMstActivityModel = new HiraMstActivity();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'JOB_ID' => 'JOB_ID',
            'ACTIVITY_NAME' => 'ACTIVITY_NAME',
        ];
    }
    
    public function getMasterActivityList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query = HiraMstActivity::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['job'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Special handling for ACTIVITY_NAME to make it case-insensitive
            if ($key === 'ACTIVITY_NAME') {
                $query->where($columnMapping[$key], 'ILIKE', "%$value%");
            } else {
                // Add a where clause for the mapped column name
                $query->where($columnMapping[$key], $value);
            }
            }
        }

        $query->where("IS_DELETED", 0);
        $query->orderBy("ACTIVITY_ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);

        $totalCount = $query->count('ACTIVITY_ID');

        // Pagination Logic
        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

        $paginatedActivityData = $query->paginate($this->pageSize, ['*'], 'page', $this->page);

        return [
            'data' => $paginatedActivityData,
            'total' => $totalCount // Total count of distinct worker IDs
        ];
    }

    public function getActivityIdsFromHira()
    {
        return HiraMapActivityType::distinct()->pluck('MST_ACTIVITY_TYPE_ID');
    }

    public function getActivityIdsFromRisk()
    {
        return HiraMstRiskRelated::distinct()->pluck('ACTIVITY_ID');
    }

    public function activitySave($requestData, $vvsUserRole)
    {
        $activityId = "";
        $processedActivityData = [];
        $activitydata = null;
        if (isset($requestData -> ACTIVITY_ID) && $requestData -> ACTIVITY_ID > 0) {
            $activitydata = HiraMstActivity::where("ACTIVITY_ID", $requestData -> ACTIVITY_ID)
                                    ->where("IS_DELETED", 0)->first();
            $activityId = $activitydata->ACTIVITY_ID;
        }
        
        DB::beginTransaction();
        try {
        if ($requestData -> ACTION == "SAVE") {
            $requestData->ACTIVITY_NAME =  $requestData->ACTIVITY_NAME ??  $activitydata->ACTIVITY_NAME;
            $requestData->JOB_ID       =  $requestData->JOB_ID ??  $activitydata->JOB_ID;
           
            $processedActivityData = [
                "JOB_ID"       => (int)$requestData->JOB_ID,
                "ACTIVITY_NAME" => $requestData->ACTIVITY_NAME,
            ];
           
        }
        
        // if ($requestData -> ACTION == "APPROVE") {
        //     $processedActivityData["IS_ACTIVE"] = 1;
        // }
        if ($requestData -> ACTION == "DELETE") {
            $processedActivityData["IS_DELETED"] = 1;
        }
        
        if (isset($requestData -> ACTIVITY_ID) &&  $requestData -> ACTIVITY_ID > 0) {
            $processedActivityData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedActivityData["MODIFIED_ON"] = currentDateTime();
        }else {
            $processedActivityData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedActivityData["CREATED_ON"] = currentDateTime();
        }
        
        
        if ($activityId > 0) {
            //update HiraMstActivity table
            HiraMstActivity::where("ACTIVITY_ID", $activityId)->update($processedActivityData);
        }else {
            //insert into HiraMstActivity table
            // if ($vvsUserRole == 10) {
            //     $processedActivityData["IS_ACTIVE"] = 1;
            // } else {
            //     $processedActivityData["IS_ACTIVE"] = 0;
            // }
            $contractorInsert = HiraMstActivity::create($processedActivityData);
            $activityId = $contractorInsert->ACTIVITY_ID;
        }

        $returnmsg = 'Processed successfully';
        $activityName = HiraMstActivity::where("ACTIVITY_ID", $activityId)->pluck("ACTIVITY_NAME")->first();
        if($requestData -> ACTION == "SAVE"){
            if(isset($requestData -> ACTIVITY_ID) && $requestData -> ACTIVITY_ID > 0){
                $returnmsg = 'Activity ('.$activityName.') data has been updated successfully.';
            }else{                
                $returnmsg = 'Activity ('.$activityName.') data has been created successfully.'; 
            }
        }
        // if($requestData -> ACTION == "APPROVE"){
        //     $returnmsg = 'Activity ('.$activityName.') data has been approved successfully.';
        // }
        if($requestData -> ACTION == "DELETE"){
            $returnmsg ='Activity ('.$activityName.') data has been deleted successfully.';
        }

        DB::commit();

         // If the transaction is committed successfully, you can return a response or perform other actions
         return $returnmsg;
        
        } catch (\Exception $e) {
        // If an exception occurs during the transaction, rollback the changes
        DB::rollBack();

        prd($e->getMessage());
        // You can handle the exception here, log it, or return an error response
        return "Error occurred while saving data.";
        }
    }

    public function getActivityDetails($requestData)
    {
        return HiraMstActivity::where("ACTIVITY_ID", $requestData->ACTIVITY_ID)->first();
    }
}