<?php

namespace App\Services\INSPECTION;

use App\Http\Requests\INSPECTION\AddRequest;
use App\Http\Resources\INSPECTION\InspectionResource;
use App\Models\MstSite;
use App\Models\Inspection;
use App\Models\InspectionActionHistory;
use App\Models\InspectionMapCaptcha;
use App\Models\InspectionMapChecklist;
use App\Models\InspectionMapDeclaration;
use App\Models\InspectionMapFiles;
use App\Models\InspectionMapHira;
use App\Models\InspectionMapPrecautions;
use App\Models\InspectionMapSopPolicies;
use App\Models\InspectionMapSopPolicy;
use App\Models\InspectionMapRecipent;
use App\Models\InspectionMstChecklist;
use App\Models\InspectionMstChecklistOption;
use App\Models\InspectionMstDeclaration;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\InspectionMstType;
use App\Models\MstLocation;
use App\Models\HiraMstLocation;
use App\Services\INSPECTION\InspectionSendMailServices;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class InspectionServices extends InspectionResource
{
    public $vvsInspectionModel;
    public $page;
    public $pageSize;
    public $vvsInspSendMailService;
    public function __construct()
    {
        $this->vvsInspectionModel = new Inspection();
        $this->vvsInspSendMailService = new InspectionSendMailServices();
    }
    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'TYPE_ID' => 'TYPE_ID',
            'SITE_ID' => 'SITE_ID',
            'INSPECTION_REFERENCE_NO' => 'ID',
            'LOCATION_ID' => 'LOCATION_ID',
            'INSP_START_TIME'=>'INSP_START_TIME',
            'INSP_END_TIME'=>'INSP_END_TIME',
            'STAGE_ID'=>'STAGE_ID'
        ];
    }

    protected function mapRoleStageTab($requestData,$roleId){
        $tab = strtoupper($requestData->TAB);
        $stageId = (!empty( $requestData ->STAGE_ID)) ? $requestData ->STAGE_ID : "";
        if( $stageId == "" &&  $tab == "DRAFT") $tab = "DRAFT";
        if( $roleId == 10 ) $tab = "REVIEWED";
        else if($stageId){

            if( $stageId == 1 ){
                if($roleId == 7) $tab = "DRAFT";
            }
            else if( $stageId == 2 ){
                if($roleId == 7) $tab = "REVIEWED";
                else if($roleId == 8) $tab = "REVIEWED";
                else if($roleId == 9) $tab = "REVIEWED";
                else if($roleId == 10) $tab = "REVIEWED";
            }            
        }
        
        return $tab;
    }

    public function calculatedTab($requestData){
        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "INSP")->pluck("ROLE_ID")->first();
        return $this -> mapRoleStageTab($requestData,$userRoles);
    }
    public function getInspectionList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $tab = strtoupper($requestData->TAB) ?? "DRAFT";

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "INSP")->pluck("ROLE_ID")->first();


        if(!empty($requestData->STAGE_ID)){
            $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        }

        $query = Inspection::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location','stage'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "INSPECTION_REFERENCE_NO") {
                    //$query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                    $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "INSP_START_TIME") {
                    $query->whereDate('INSP_DATE', '>=',$value);
                }
                else if ($columnMapping[$key] == "INSP_END_TIME") {
                    $query->whereDate('INSP_DATE', '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        if (strtoupper($tab) == "REVIEWED") {
            if ($userRoles == 7) {
                $query->whereIn('STAGE_ID', [2]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 8) {
                $query->whereIn('STAGE_ID', [2]);
            } elseif ($userRoles == 9) {
                $query->whereIn('STAGE_ID', [2]);
            } elseif ($userRoles == 10) {
                $query->whereNotIn('STAGE_ID', [1]);
            }
        }elseif(strtoupper($tab) == "DRAFT"){
            if ($userRoles == 7) {
                $query->whereIn('STAGE_ID', [1]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            }
        }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);


        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        return $query->paginate($this->pageSize, ['*'], 'page', $this->page);
    }
    public function getInspectionListTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        $tab = strtoupper($requestData->TAB) ?? "DRAFT";
        $query = Inspection::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location', 'stage'];

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)->where("MODULE_NAME", "INSP")->pluck("ROLE_ID")->first();

        if(!empty($requestData->STAGE_ID)){
            $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        }


        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "INSPECTION_REFERENCE_NO") {
                    //$query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                    $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "INSP_START_TIME") {
                    $query->whereDate('INSP_DATE', '>=',$value);
                }
                else if ($columnMapping[$key] == "INSP_END_TIME") {
                    $query->whereDate('INSP_DATE', '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        if (strtoupper($tab) == "REVIEWED") {
            if ($userRoles == 7) {
                $query->whereIn('STAGE_ID', [2]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 8) {
                $query->whereIn('STAGE_ID', [2]);
            } elseif ($userRoles == 9) {
                $query->whereIn('STAGE_ID', [2]);
            }elseif ($userRoles == 10) {
                $query->whereNotIn('STAGE_ID', [1]);
            }
        }elseif(strtoupper($tab) == "DRAFT"){
            if ($userRoles == 7) {
                $query->whereIn('STAGE_ID', [1]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            }
        }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->count();
    }

    public function getInspectionDetails($requestData)
    {
        return Inspection::where("ID", $requestData->INSP_ID)->first();
    }

    public function getLastInspection($requestData)
    {
        return Inspection::where("SITE_ID", $requestData->SITE_ID)->latest()->first();
    }

    public function getAllInspection($requestData)
    {
        return Inspection::where("SITE_ID", $requestData->SITE_ID)->where("IS_DELETED", 0)->get();
    }
    
    protected function getStages($requestAction)
    {
        $stageId = 1;
        if (strtoupper($requestAction) == "DRAFT") {
            $stageId = 1;
        } elseif (strtoupper($requestAction) == "SAVE") {
            $stageId = 2;
        } elseif (strtoupper($requestAction) == "MOVE_FORWARD") {
            $stageId = 3;
        } elseif (strtoupper($requestAction) == "SEND_BACK") {
            $stageId = 4;
        } elseif (strtoupper($requestAction) == "APPROVE") {
            $stageId = 5;
        } elseif (strtoupper($requestAction) == "REJECT") {
            $stageId = 6;
        } elseif (strtoupper($requestAction) == "REQUEST_FOR_CLOSURE") {
            $stageId = 7;
        } elseif (strtoupper($requestAction) == "CLOSE") {
            $stageId = 8;
        } elseif (strtoupper($requestAction) == "REQUEST_FOR_SUSPEND") {
            $stageId = 10;
        } elseif (strtoupper($requestAction) == "SUSPEND") {
            $stageId = 11;
        }
        elseif (strtoupper($requestAction) == "RENEW") {
            $stageId = 13;
        }
        return $stageId;
    }

    protected function transformInspectionMapRecipentTableData($requestData, $inspectionId)
    {
        $processedData = [];
        if (isset($requestData->USER_ID)) {
            if (count($requestData->USER_ID) > 0) {
                foreach ($requestData->USER_ID as $value) {
                    $processedData[] = [
                        "INSP_ID" => $inspectionId,
                        "USER_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }
    protected function transformInspectionMapDeclarationTableData($requestData, $inspectionId)
    {
        $processedData = [];
        if (isset($requestData->DECLARATION_ID)) {
            if (count($requestData->DECLARATION_ID) > 0) {
                foreach ($requestData->DECLARATION_ID as $value) {
                    $processedData[] = [
                        "INSPECTION_ID" => $inspectionId,
                        "DECLARATION_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    protected function transformInspectionMapCheckListTableData($requestData, $inspectionId)
    {
        $processedData = [];
        if (isset($requestData->CHECKLIST)) {
            if (count($requestData->CHECKLIST)) {
                foreach ($requestData->CHECKLIST as $value) {
                    if($value->CHECKLIST_ID === 999 ){
                        $checkListname = $value->CHECKLIST_NAME;
                        $checkListoption = $value->OPTION_NAME ?? "";
                    }else{
                        $checkListname =  InspectionMstChecklist::where("CHECKLIST_ID", $value->CHECKLIST_ID)->pluck("CHECKLIST_NAME")->first();
                        $checkListoption =  InspectionMstChecklistOption::where("CHECKLIST_OPTION_ID", $value->OPTION_ID)->pluck("CHECKLIST_OPTION_NAME")->first();
                    }                    
                    
                    $processedData[] = [
                        "INSPECTION_ID" => $inspectionId,
                        "CHECKLIST_ID" => $value->CHECKLIST_ID ?? 999,                        
                        "CHECKLIST_NAME" => $checkListname ?? "",
                        "OPTION_ID" => $value->OPTION_ID ?? 999,                        
                        "OPTION_NAME" => $checkListoption ?? "",                        
                        "REMARKS"=>$value->REMARKS ?? "",
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }        
        return $processedData;
    }

    public function InspectionFileUpload($request, $inspectionId)
    {

        if ($inspectionId) {
            $uploadPath = './' . config('constants.INSP_FILE_UPLOAD_PATH');
            $absoluteBasePath = public_path(config('constants.INSP_FILE_UPLOAD_PATH'));
            if (!file_exists($uploadPath)) {
                mkdir($uploadPath, 0755, true);
            }

            $fileList = (isset($request->FILES)) ? $request->FILES : [];


            if (count($fileList)) {
                foreach ($fileList as $fileData) {
                    if ($fileData->FILE_ID == 0) {
                        $file = new InspectionMapFiles([
                            'INSP_ID' => $inspectionId,
                            'FILE_NAME' => basename($fileData->FILE),
                            'FILE_CAPTION' => $fileData->FILE_CAPTION,
                            'FILE_PATH' => $fileData->FILE,
                            'CREATED_BY' => $request->CREATED_BY,
                            'CREATED_ON' => currentDateTime()
                        ]);
                        $file->save();
                    } else {
                        //request for deletion of the file
                        $fileDetails = InspectionMapFiles::where('MAP_FILE_ID', $fileData->FILE_ID)->first();
                        if ($fileDetails) {
                            $fileDeleted = InspectionMapFiles::where('MAP_FILE_ID', $fileData->FILE_ID)->delete();
                            if ($fileDeleted) {
                                @unlink($absoluteBasePath . $fileDetails->FILE_NAME);
                            }
                        }
                    }
                }
            }
        }
    }


    public function softDeleteForAssociatedInspectionTables($model, $inspectionId, $requestData)
    {
        return $model::where("Inspection_ID", $inspectionId)->where("IS_DELETED", 0)
            ->update([
                "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                "MODIFIED_ON" => currentDateTime()
            ]);
    }

    protected function autoGenNumberGeneration($requestedData)
    {        
        if($requestedData->ID > 0){
            $siteId = Inspection::where("ID",$requestedData->ID)->pluck("LOCATION_ID")->first();
        }else{
            $siteId = $requestedData -> LOCATION_ID;
        }
        //$siteAlias   = MstSite::where("SITE_ID", $siteId)->pluck("SITE_ALIAS")->first();
        $siteAlias   = HiraMstLocation::where("LOCATION_ID", $siteId)->pluck("LOCATION_ALIAS")->first();   
        $initialSearch = "";
        //$initialSearch = "SHW_IND_";
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            $initialSearch = "DRAFT_";
        }
        else{
            $initialSearch = "SHW_IND_";
        }
        $previousNumber = DB::table('INSP')
                            ->where("LOCATION_ID", $siteId)
                            ->where("INSPECTION_REFERENCE_NO", "LIKE", $initialSearch . strtoupper($siteAlias) . "%")
                            ->max(DB::raw("CAST(regexp_replace(\"INSPECTION_REFERENCE_NO\", '\\D', '', 'g') AS INTEGER)"));
        $previousNumber = $previousNumber ?: 0;

        // Define prefix and suffix
        $prefix = config("constants.INSP_REFERENCE_PREFIX");
        $prefixMod = config("constants.INSP_PREFIX");
        $typeAlias = InspectionMstType::where("INSP_TYPE_ID", $requestedData -> TYPE_ID)->pluck("TYPE_ALIAS")->first();
        
        $middle = "_".$prefixMod.$typeAlias."_";      
        
        // Increment the last digit based on the value of $previousNumber
        $lastDigit = $previousNumber + 1;

        // Concatenate all parts to form the output
        //return $prefix . strtoupper($siteAlias) . $middle . $lastDigit;
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            return $initialSearch.strtoupper($siteAlias)."-".$lastDigit;
        }else{
            return $prefix . strtoupper($siteAlias) . $middle . $lastDigit;
        }
    }

    protected function transformInspectionTableData($requestData)
    {
        if (in_array(strtoupper($requestData->ACTION), ["DRAFT", "SAVE","RENEW"])) {

            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];

            if (isset($requestData->SITE_ID)) {
                $processedData["SITE_ID"]  =  $requestData->SITE_ID;
            }
            if (isset($requestData->TYPE_ID)) {
                $processedData["TYPE_ID"]  =  $requestData->TYPE_ID;
            }
            if (isset($requestData->LOCATION_ID)) {
                $processedData["LOCATION_ID"]  =  $requestData->LOCATION_ID;
            }
            if (isset($requestData->INSP_DATE)) {
                $processedData["INSP_DATE"]  = createSlashDate($requestData->INSP_DATE, config("constants.DATE_TIME_FORMAT"));
            }            
            if (isset($requestData->DESCRIPTION)) {
                $processedData["DESCRIPTION"]  =  $requestData->DESCRIPTION;
            }
            if( strtoupper($requestData->ACTION) == "DRAFT"){
                if ($requestData->ID == 0 ) {               
                    $processedData["INSPECTION_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                }
            }
            if( strtoupper($requestData->ACTION) == "SAVE"){
                if ($requestData->ID == 0 ) {               
                    $processedData["INSPECTION_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                }
                if ($requestData->ID > 0 ) { 
                    $inspDraftAlready = Inspection::where("ID",$requestData->ID)->where("INSPECTION_REFERENCE_NO","LIKE","DRAFT_%");              
                    if($inspDraftAlready -> exists()){
                        $processedData["INSPECTION_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" ) ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                    }                                        
                }               
            }             
        } else {            
            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];
            
        }

        if (isset($requestData->ID) &&  $requestData->ID > 0) {
            $processedData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedData["MODIFIED_ON"] = currentDateTime();
        } else {
            $processedData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedData["CREATED_ON"] = currentDateTime();
        }
        return $processedData;
    }
    public function save($requestData)
    {        
        $inspectionId = "";        
        if (isset($requestData->ID) && $requestData->ID) {
            $inspectionId = Inspection::where("ID", $requestData->ID)->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->pluck("ID")->first();
            $inspectionStageId = Inspection::where("ID", $requestData->ID)->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->pluck("STAGE_ID")->first();
            $requestedStageId = $this -> getStages($requestData->ACTION);
            
            if( in_array($inspectionStageId,[4,6])){
                if( $requestedStageId ==1 ){

                }else{
                    if($inspectionStageId > $requestedStageId){
                        return "";
                    }
                }                
            }else if($inspectionStageId !=1 && ($inspectionStageId  == $requestedStageId)){
                return "";
            }
            else{
                if($inspectionStageId > $requestedStageId){
                    return "";
                }
            }
        } 
       
        DB::beginTransaction();
        try {
            if (isset($requestData->ACTION) && strtoupper($requestData->ACTION) == "RENEW") {
                $inspectionId = $this -> renewal($requestData);
            }else{
                $processedData = $this->transformInspectionTableData($requestData);           
                if ($inspectionId > 0) {
                    //update Inspection tables and upsert all associated tables
                    Inspection::where("ID", $inspectionId)->update($processedData);
                } else {
                    //insert Inspection tables and insert all associated tables
                    //insert into Inspection table
                    $inspectionInsert = Inspection::create($processedData);
                    $inspectionId = $inspectionInsert->ID;
                } 
                
                //insert into INSP_MAP_RECIPENT
                $inspectionMapRecipentData = $this->transformInspectionMapRecipentTableData($requestData, $inspectionId);                
                if (count($inspectionMapRecipentData)) {
                    //soft delete old data if exists                    
                    InspectionMapRecipent::where("INSP_ID", $inspectionId)->where("IS_DELETED", 0)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                ]);
                    //insert new data
                    InspectionMapRecipent::insert($inspectionMapRecipentData);
                }

                //insert into INSP_MAP_DECLARATION
                $inspectionMapDeclarationData = $this->transformInspectionMapDeclarationTableData($requestData, $inspectionId);                
                if (count($inspectionMapDeclarationData)) {
                    //soft delete old data if exists
                    $addRequestClass = new AddRequest();
                    $declarationSectionId = $addRequestClass->getDeclarationSectionbyAction($requestData->ACTION);
                    
                    if ($declarationSectionId == 1) {
                        $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "INSP_ADD")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 2) {
                        $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "INSP_MOVE_FORWARD")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 3) {
                        $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "INSP_APPROVE")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 4) {
                        $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "INSP_REJECT")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 5) {
                        $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "INSP_REQUEST_FOR_CLOSURE")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 6) {
                        $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "INSP_CLOSE")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 7) {
                        $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "INSP_SUSPEND")->pluck("DECLARATION_ID")->all();
                    } elseif ($declarationSectionId == 8) {
                        $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->where("DECLARATION_GROUP", "INSP_REQUEST_FOR_SUSPEND")->pluck("DECLARATION_ID")->all();
                    } else {
                        $allDeclarationData = InspectionMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                            ->whereNot("DECLARATION_GROUP", "INSP_ADD")->pluck("DECLARATION_ID")->all();
                    }                   
                   
                    InspectionMapDeclaration::where("INSPECTION_ID", $inspectionId)->where("IS_DELETED", 0)
                        ->whereIn("DECLARATION_ID", $allDeclarationData)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                        ]);
                    //insert new data
                    InspectionMapDeclaration::insert($inspectionMapDeclarationData);
                }
                
                //insert into Inspection_MAP_CHECKLIST
                $inspectionMapCheckListData = $this->transformInspectionMapCheckListTableData($requestData, $inspectionId);                
                if (count($inspectionMapCheckListData)) {
                    //soft delete old data if exists
                    //$this -> softDeleteForAssociatedInspectionTables("InspectionMapChecklist",$inspectionId,$requestData);
                    InspectionMapChecklist::where("INSPECTION_ID", $inspectionId)->where("IS_DELETED", 0)
                        ->update([
                            "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                            "MODIFIED_ON" => currentDateTime()
                        ]);
                    //insert new data
                    InspectionMapChecklist::insert($inspectionMapCheckListData);
                }
                //insert into Inspection_MAP_FILES
                $this->InspectionFileUpload($requestData, $inspectionId);
                //insert into log table
                InspectionActionHistory::insert(
                    [
                        "INSPECTION_ID" => $inspectionId,
                        "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                        "STAGE_ID"  => $this->getStages($requestData->ACTION),
                        "COMMENTS"  => $requestData->REMARKS ?? "",
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ]
                );
            }
            $stage_id = $this->getStages($requestData->ACTION);
             //  $this->vvsInspSendMailService->inspSendMail($stage_id,$inspectionId);   
             DB::commit();

            // If the transaction is committed successfully, you can return a response or perform other actions
            if($inspectionId != ""){
                return Inspection::where("ID", $inspectionId)->pluck("INSPECTION_REFERENCE_NO")->first();
            }else{
                return "";
            }
        } catch (\Exception $e) {
            // If an exception occurs during the transaction, rollback the changes
             DB::rollBack();
            prd($e->getMessage());
            // You can handle the exception here, log it, or return an error response
             return "";
         }
    }

    public function getInspectionDownloadableList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = Inspection::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location','stage',
                            'actionDraftedHistory','actionReportedHistory','files'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "INSPECTION_REFERENCE_NO") {
                    //$query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                    $query->where('ID', $value);
                }
                else if ($columnMapping[$key] == "INSP_START_TIME") {
                    $query->whereDate('INSP_DATE', '>=',$value);
                }
                else if ($columnMapping[$key] == "INSP_END_TIME") {
                    $query->whereDate('INSP_DATE', '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        $query->with(['actionDraftedHistory.actionTracker']);
        $query->with(['actionReportedHistory.actionTracker']);

        // Fetch action history data
        return  $query->get();
    }

    public function getSearchCriteriaList($requestData)
    {
        $searchCriteria =[];
        if (!empty($requestData->TYPE_ID) && isset($requestData->TYPE_ID)) {
            $type = InspectionMstType::find($requestData->TYPE_ID);
            if ($type) {
                $typeName = $type->INSP_TYPE_NAME;
            }
        }
        if (!empty($requestData->LOCATION_ID) && isset($requestData->LOCATION_ID)) {
            $location = HiraMstLocation::find($requestData->LOCATION_ID);
            if ($location) {
                $locationName = $location->LOCATION_NAME;
            }
        }
        if (!empty($requestData->SITE_ID) && isset($requestData->SITE_ID)) {
            $site = MstSite::find($requestData->SITE_ID);
            if ($site) {
                $siteName = $site->SITE_NAME;
            }
        }

        if(isset($requestData->SITE_ID)){
            $searchCriteria["SITE_NAME"] = $siteName;
        }
        if(isset($requestData->TYPE_ID)){
            $searchCriteria["INSP_TYPE"] = $typeName;
        }
        if(isset($requestData->INSPECTION_REFERENCE_NO)){
            $searchCriteria["INSPECTION_REFERENCE_NO"] = $requestData->INSPECTION_REFERENCE_NO;
        }
        if(isset($requestData->LOCATION_ID)){
            $searchCriteria["LOCATION_NAME"] = $locationName;
        }

        return $searchCriteria;
    }

    public function getInspectionDetailsExport($requestData)
    {
        $query = Inspection::query();

        // Define the relationships to eager load
        $relationshipsToLoad = ['type', 'site', 'location','stage',
                                'actionDraftedHistory','actionReportedHistory','files', 'mapRecipent'];
    
        // Add where clause for the inspection ID
        $query->where("ID", $requestData->INSP_ID);
    
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        $query->with(['actionDraftedHistory.actionTracker']);
        $query->with(['actionReportedHistory.actionTracker']);
        $query->with(['mapRecipent.recipent']);
    
        // Fetch the inspection details
        return $query->first();
    }
}
