<?php

namespace App\Services\INSPECTION;

use App\Http\Requests\INSPECTION\AddRequest;
use App\Http\Resources\INSPECTION\InspectionResource;
use App\Models\MstSite;
use App\Models\Inspection;
use App\Models\User;
use App\Models\UserMapRole;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;

class InspectionSendMailServices extends InspectionResource
{
    public $vvsInspModel;    
    public function __construct()
    {
        $this->vvsInspModel = new Inspection();
    }

    public function inspSendMail($stage_id,$insp_id){
        if($stage_id == 2){
            $this->sendNotificationMail($insp_id);
        }
    }

    protected function getInspRecipentsUserList($insp_id) {
        return User::select(
            'USERS.ID', 
            'USERS.FIRST_NAME', 
            'USERS.LAST_NAME', 
            'USERS.EMAIL',                        
            )
            ->leftJoin('INSP_MAP_RECIPENT', 'INSP_MAP_RECIPENT.USER_ID', '=', 'USERS.ID')
            ->where("INSP_MAP_RECIPENT.INSP_ID",$insp_id)            
            ->where("USERS.IS_ACTIVE",1)
            ->where("USERS.IS_DELETED",0)
            ->where("INSP_MAP_RECIPENT.IS_ACTIVE",1)
            ->where("INSP_MAP_RECIPENT.IS_DELETED",0)                        
            ->get();    
    }

    protected function sendNotificationMail($insp_id){
        $inspdetails = Inspection::where("ID", $insp_id)->first();
        $reportedby = $inspdetails->draftedby;
        $mapRole = $reportedby->inspectionroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:green;">INSPECTION NOTIFICATION</h1></p>';
        $mailBody.="<p>The Inspection as referred below has been submitted by 
        ".$this->customDecrypt($inspdetails->draftedby->FIRST_NAME).' '.$this->customDecrypt($inspdetails->draftedby->LAST_NAME)." [".$roleName."] 
        .</p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$inspdetails->INSPECTION_REFERENCE_NO.'</td></tr>';
        $mailBody.='<tr><td>Date:</td><td>'.showDate($inspdetails->INSP_DATE, config("constants.DATE_FORMAT")).'</td></tr>';
        $mailBody.='<tr><td>Type:</td><td>'.$inspdetails->type->INSP_TYPE_NAME.'</td></tr>';
        $mailBody.='<tr><td>Inspection Details:</td><td>'.$inspdetails->DESCRIPTION.'</td></tr>';
        $mailBody.='<tr><td>Location:</td><td>'.$inspdetails->location->LOCATION_NAME.'</td></tr>';
        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';        
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";

        $userlist = $this->getInspRecipentsUserList($insp_id);
        foreach($userlist as $value){
            $to_email = $this->customDecrypt($value->EMAIL);            
            $data = array('body' => $mailBody,'to_email'=>$to_email);
            Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('INSPECTION NOTIFICATION');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
            });
        }
    }

}
