<?php

namespace App\Services\INSPECTION;

use App\Http\Resources\INSPECTION\InspectionRecipentResource;
use App\Models\UserMapSite;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class InspectionMstRecipentServices extends InspectionRecipentResource
{
    public $vvsInspectionRecipentModel;
    public function __construct(){
        $this->vvsInspectionRecipentModel = new UserMapSite();
    }
    
    public function getInspectionRecipentList($rawRequest){
        return UserMapSite::select('USERS_MAP_SITE.USER_ID',
                                    'USERS_MAP_SITE.SITE_ID',
                                    'USERS_MAP_ROLE.ROLE_ID',
                                    'USERS_MAP_SITE.MAP_SITE_ID',
                                )
                            ->leftJoin('USERS_MAP_ROLE', 'USERS_MAP_ROLE.USER_ID', '=', 'USERS_MAP_SITE.USER_ID')
                            ->leftJoin('USERS', 'USERS.ID', '=', 'USERS_MAP_SITE.USER_ID')                           
                            ->where('USERS_MAP_SITE.IS_ACTIVE', 1)
                            ->where('USERS_MAP_SITE.IS_DELETED', 0)
                            ->where('USERS_MAP_ROLE.IS_ACTIVE', 1)
                            ->where('USERS_MAP_ROLE.IS_DELETED', 0)
                            ->where('USERS.IS_ACTIVE', 1)
                            ->where('USERS.IS_DELETED', 0)                            
                            ->where("USERS_MAP_SITE.SITE_ID",$rawRequest->SITE_ID)
                            ->where('USERS_MAP_ROLE.MODULE_NAME', 'INSP')
                            ->whereIn('USERS_MAP_ROLE.ROLE_ID', [8,9])    
                            ->get();
    }
    
}
