<?php

namespace App\Services\INSPECTION;

use App\Http\Resources\INSPECTION\InspectionMstDeclarationResource;
use App\Models\InspectionMapDeclaration;
use App\Models\InspectionMstDeclaration;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;

class InspectionMstDeclarationServices extends InspectionMstDeclarationResource
{
    public $vvsInspectionDeclModel;
    public function __construct(){
        $this->vvsInspectionDeclModel = new InspectionMstDeclaration();
    }
    

    public function getInspectionInitialDeclListOne(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%INSP_ADD_ONE%')->get();
    }

    public function getInspectionInitialDeclListTwo(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%INSP_ADD_TWO%')->get();
    }

    public function getInspectionMoveFrwdDeclList(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%MOVE_FORWARD%')->get();
    }

    public function getInspectionApproveDeclList(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%APPROVE%')->get();
    }

    public function getInspectionRejectDeclList(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%REJECT%')->get();
    }

    public function getInspectionCloseReqDeclList(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%REQUEST_FOR_CLOSURE%')->get();
    }

    public function getInspectionCloseDeclList(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%CLOSE%')->get();
    }

    public function getInspectionSuspendReqDeclList(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%REQUEST_FOR_SUSPEND%')->get();
    }

    public function getInspectionSuspendDeclList(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', 'SUSPEND%')->get();
    }

    public function getInspectionRenewDeclList(){
        return InspectionMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', 'RENEWED%')->get();
    }

    public function getMapDeclarationOne($inspection_id,$afterSubmit){
        if( $afterSubmit == 1 ){

            return InspectionMstDeclaration::select(
                        'INSP_MST_DECLARATION.DECLARATION_ID', 
                        'INSP_MST_DECLARATION.DECLARATION_NAME', 
                        'INSP_MST_DECLARATION.DECLARATION_GROUP', 
                        'INSP_MST_DECLARATION.DECLARATION_SECTION',
                        'INSP_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                        'INSP_MAP_DECLARATION.MAP_DECLARATION_ID',
                        'INSP_MAP_DECLARATION.IS_ACTIVE',
                        'INSP_MAP_DECLARATION.IS_DELETED'
                    )
                    ->leftJoin('INSP_MAP_DECLARATION', function($join) use ($inspection_id) {
                        $join->on('INSP_MAP_DECLARATION.DECLARATION_ID', '=', 'INSP_MST_DECLARATION.DECLARATION_ID')
                            ->where('INSP_MAP_DECLARATION.INSPECTION_ID', $inspection_id)
                            ->where('INSP_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('INSP_MAP_DECLARATION.IS_DELETED', 0);
                    })
                    ->where('INSP_MST_DECLARATION.IS_ACTIVE', 1)
                    ->where('INSP_MST_DECLARATION.IS_DELETED', 0)                    
                    ->where('INSP_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', 'INSP_ADD_ONE%')
                    ->get();
        }else{
            return InspectionMapDeclaration::select('INSP_MST_DECLARATION.DECLARATION_ID', 'INSP_MST_DECLARATION.DECLARATION_NAME', 'INSP_MST_DECLARATION.DECLARATION_GROUP', 'INSP_MST_DECLARATION.DECLARATION_SECTION','INSP_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                                            'INSP_MAP_DECLARATION.MAP_DECLARATION_ID',
                                            'INSP_MAP_DECLARATION.IS_ACTIVE',
                                            'INSP_MAP_DECLARATION.IS_DELETED'
                                            )
                            ->leftJoin('INSP_MST_DECLARATION', 'INSP_MAP_DECLARATION.DECLARATION_ID', '=', 'INSP_MST_DECLARATION.DECLARATION_ID')
                            //->where('INSP_MST_DECLARATION.IS_ACTIVE', 1)
                            ->where('INSP_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('INSP_MAP_DECLARATION.IS_DELETED', 0)
                            //->where('INSP_MST_DECLARATION.IS_DELETED', 0)
                            ->where("INSP_MAP_DECLARATION.INSPECTION_ID",$inspection_id)
                            ->where('INSP_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', '%INSP_ADD_ONE%')
                            ->get();
                  
        }
        
    }

    public function getMapDeclarationTwo($inspection_id,$afterSubmit){
        if( $afterSubmit == 1 ){

               return InspectionMstDeclaration::select(
                    'INSP_MST_DECLARATION.DECLARATION_ID', 
                    'INSP_MST_DECLARATION.DECLARATION_NAME', 
                    'INSP_MST_DECLARATION.DECLARATION_GROUP', 
                    'INSP_MST_DECLARATION.DECLARATION_SECTION',
                    'INSP_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                    'INSP_MAP_DECLARATION.MAP_DECLARATION_ID',
                    'INSP_MAP_DECLARATION.IS_ACTIVE',
                    'INSP_MAP_DECLARATION.IS_DELETED'
                )
                ->leftJoin('INSP_MAP_DECLARATION', function($join) use ($inspection_id) {
                    $join->on('INSP_MAP_DECLARATION.DECLARATION_ID', '=', 'INSP_MST_DECLARATION.DECLARATION_ID')
                         ->where('INSP_MAP_DECLARATION.INSPECTION_ID', $inspection_id)
                         ->where('INSP_MAP_DECLARATION.IS_ACTIVE', 1)
                         ->where('INSP_MAP_DECLARATION.IS_DELETED', 0);
                })
                ->where('INSP_MST_DECLARATION.IS_ACTIVE', 1)
                ->where('INSP_MST_DECLARATION.IS_DELETED', 0)
                ->where('INSP_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', 'INSP_ADD_TWO%')
                ->get();
        }else{
            return InspectionMapDeclaration::select('INSP_MST_DECLARATION.DECLARATION_ID', 'INSP_MST_DECLARATION.DECLARATION_NAME', 'INSP_MST_DECLARATION.DECLARATION_GROUP', 'INSP_MST_DECLARATION.DECLARATION_SECTION','INSP_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                                            'INSP_MAP_DECLARATION.MAP_DECLARATION_ID',
                                            'INSP_MAP_DECLARATION.IS_ACTIVE',
                                            'INSP_MAP_DECLARATION.IS_DELETED'
                                            )
                            ->Join('INSP_MST_DECLARATION', 'INSP_MAP_DECLARATION.DECLARATION_ID', '=', 'INSP_MST_DECLARATION.DECLARATION_ID')
                            ->where('INSP_MST_DECLARATION.IS_ACTIVE', 1)
                            ->where('INSP_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('INSP_MAP_DECLARATION.IS_DELETED', 0)
                            ->where('INSP_MST_DECLARATION.IS_DELETED', 0)
                            ->where("INSP_MAP_DECLARATION.INSPECTION_ID",$inspection_id)
                            ->where('INSP_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', '%INSP_ADD_TWO%')
                            ->get();
                  
        }
        
        
        
    }

    public function getMapDeclarationAll($inspection_id){
        return InspectionMapDeclaration::select(            
            'INSP_MST_DECLARATION.DECLARATION_NAME', 
            'INSP_MST_DECLARATION.DECLARATION_GROUP', 
            'INSP_MST_DECLARATION.DECLARATION_SECTION'            
        )
        ->Join('INSP_MST_DECLARATION', 'INSP_MAP_DECLARATION.DECLARATION_ID', '=', 'INSP_MST_DECLARATION.DECLARATION_ID')
        ->where('INSP_MST_DECLARATION.IS_ACTIVE', 1)
        ->where('INSP_MAP_DECLARATION.IS_ACTIVE', 1)
        ->where('INSP_MAP_DECLARATION.IS_DELETED', 0)
        ->where('INSP_MST_DECLARATION.IS_DELETED', 0)
        ->where("INSP_MAP_DECLARATION.INSPECTION_ID",$inspection_id)        
        ->get();
    }
    
}
