<?php

namespace App\Services\INSPECTION;

use App\Http\Resources\INSPECTION\InspectionCheckListResource;
use App\Models\InspectionMstChecklist;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class InspectionCheckListServices extends InspectionCheckListResource
{
    public $vvsInspectionCheckListModel;
    public function __construct(){
        $this->vvsInspectionCheckListModel = new InspectionMstChecklist();
    }
    
    public function getInspectionCheckList($rawRequest){
        return InspectionMstChecklist::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
        ->where("TYPE_ID", $rawRequest->TYPE_ID)->get();
    }
    

    public function getMapInspectionCheckList($inspection_id,$type_id,$afterSubmit){
        if( $afterSubmit == 1 ){
            return InspectionMstChecklist::select(
                        'INSP_MST_CHECKLIST.CHECKLIST_ID', 
                        'INSP_MST_CHECKLIST.CHECKLIST_NAME', 
                        'INSP_MST_CHECKLIST.TYPE_ID', 
                        'INSP_MAP_CHECKLIST.MAP_CHECKLIST_ID',
                        'INSP_MAP_CHECKLIST.OPTION_ID',
                        'INSP_MAP_CHECKLIST.OPTION_NAME',
                        'INSP_MAP_CHECKLIST.IS_ACTIVE',
                        'INSP_MAP_CHECKLIST.IS_DELETED',
                        'INSP_MAP_CHECKLIST.REMARKS'
                    )
                    ->leftJoin('INSP_MAP_CHECKLIST', function($join) use ($inspection_id) {
                        $join->on('INSP_MST_CHECKLIST.CHECKLIST_ID', '=', 'INSP_MAP_CHECKLIST.CHECKLIST_ID')
                            ->where('INSP_MAP_CHECKLIST.INSPECTION_ID', $inspection_id)
                            ->where('INSP_MAP_CHECKLIST.IS_ACTIVE', 1)
                            ->where('INSP_MAP_CHECKLIST.IS_DELETED', 0) ;
                    })
                    ->where('INSP_MST_CHECKLIST.IS_ACTIVE', 1)
                    ->where('INSP_MST_CHECKLIST.IS_DELETED', 0) 
                    ->get();
        }else{
            return InspectionMstChecklist::select(
                'INSP_MST_CHECKLIST.CHECKLIST_ID', 
                'INSP_MST_CHECKLIST.CHECKLIST_NAME', 
                'INSP_MST_CHECKLIST.TYPE_ID',  
                'INSP_MAP_CHECKLIST.MAP_CHECKLIST_ID',
                'INSP_MAP_CHECKLIST.OPTION_ID',
                'INSP_MAP_CHECKLIST.OPTION_NAME',
                'INSP_MAP_CHECKLIST.IS_ACTIVE',
                'INSP_MAP_CHECKLIST.IS_DELETED',
                'INSP_MAP_CHECKLIST.REMARKS'
                )
                ->leftJoin('INSP_MAP_CHECKLIST', 'INSP_MST_CHECKLIST.CHECKLIST_ID', '=', 'INSP_MAP_CHECKLIST.CHECKLIST_ID')                            
                ->where('INSP_MAP_CHECKLIST.IS_ACTIVE', 1)
                ->where('INSP_MAP_CHECKLIST.IS_DELETED', 0)                            
                ->where("INSP_MAP_CHECKLIST.INSPECTION_ID",$inspection_id) 
                ->get();                  
        }       
    }

    
    
}
