<?php

namespace App\Services\INSPECTION;

use App\Http\Resources\INSPECTION\InspectionActionHistoryResource;
use App\Models\InspectionActionHistory;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class InspectionActionHistoryServices extends InspectionActionHistoryResource
{
    public $vvsInspectionActivityModel;
    public function __construct(){
        $this->vvsInspectionActivityModel = new InspectionActionHistory();
    }    
    

    public function getAllActivityLog($inspection_id){
        return InspectionActionHistory::select(
            'INSP_ACTION_HISTORY.INSPECTION_ID', 
            'INSP_ACTION_HISTORY.ACTION_TAKER_ID', 
            'INSP_ACTION_HISTORY.STAGE_ID', 
            'INSP_ACTION_HISTORY.COMMENTS',
            'INSP_ACTION_HISTORY.CREATED_BY', 
            'INSP_ACTION_HISTORY.CREATED_ON'           
        )
        ->leftJoin('INSP', function($join) use ($inspection_id) {
            $join->on('INSP.ID', '=', 'INSP_ACTION_HISTORY.INSPECTION_ID')                
                ->where('INSP.IS_ACTIVE', 1)
                ->where('INSP.IS_DELETED', 0)
                ->where('INSP.ID', $inspection_id);                
        })
        ->where('INSP_ACTION_HISTORY.IS_ACTIVE', 1)
        ->where('INSP_ACTION_HISTORY.IS_DELETED', 0)
        ->whereNotNull('INSP.ID')
        ->get();

    }
    
}
