<?php

namespace App\Services\HIRA;
use App\Http\Requests\HIRA\AddRequest;
use App\Http\Resources\HIRA\HiraResource;
use App\Models\MstSite;
use App\Models\HiraMstStage;
use App\Models\Hira;
use App\Models\HiraActivity;
use App\Models\HiraMapControlInPlace;
use App\Models\HiraMapRefDoc;
use App\Models\HiraMapDeclaration;
use App\Models\HiraMapDeclarationForM;
use App\Models\HiraMstDeclaration;
use App\Models\HiraActionHistory;
use App\Models\HiraMapActivityType;
use App\Models\User;
use App\Models\MstLocation;
use App\Models\UserMapRole;
use App\Models\HiraMstJob;
use App\Models\HiraMstRiskRelated;
use App\Models\HiraMstSeverity;
use App\Models\HiraMstLikelihood;
use App\Models\PtwMstType;
use App\Models\HiraMstActivity;
use App\Models\HiraAuditLog;
use App\Models\HiraChangeLog;
use App\Models\HiraMstLocation;
use App\Services\HIRA\HiraSendMailServices;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class HiraServices extends HiraResource
{
    public $vvsHiraModel;
    public $vvsHiraSendMailService;
    public function __construct()
    {
        $this->vvsHiraModel = new Hira();
        $this->vvsHiraSendMailService = new HiraSendMailServices();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'HIRA_REFERENCE_NO' => 'HIRA_REFERENCE_NO',
            'LOCATION_ID' => 'LOCATION_ID',
            'HIRA_START_DATE'=>'HIRA_START_DATE',
            'HIRA_END_DATE'=>'HIRA_END_DATE',
            'STAGE_ID'=>'STAGE_ID'
        ];
    }

    //code
    protected function mapRoleStageTab($requestData,$roleId){
        $tab = $requestData->TAB;
        $stageId = (!empty( $requestData ->STAGE_ID)) ? $requestData ->STAGE_ID : "";
        if( $stageId == "" &&  $tab == "DRAFT") $tab = "DRAFT";
        if( $roleId == 10 ) $tab = "REVIEWED";
        else if($stageId){

            if( $stageId == 1 ){
                if($roleId == 4) $tab = "DRAFT";
            }
            else if( $stageId == 3 ){
                if($roleId == 4) $tab = "REVIEWED";
                else if($roleId == 5) $tab = "REVIEWED";
                else if($roleId == 6) $tab = "PENDING";
                else if($roleId == 10) $tab = "REVIEWED";
                else if(!in_array($roleId,[4,5,6])) $tab = "";
            }
            else if( $stageId == 2 ){
                if($roleId == 4) $tab = "REVIEWED";
                else if($roleId == 5) $tab = "PENDING";
                else if($roleId == 10) $tab = "REVIEWED";
                else if($roleId == 6) $tab = "";
                else if(!in_array($roleId,[4,5,6])) $tab = "";
            }
            else if( $stageId == 4){
                if($roleId == 4) $tab = "PENDING";
                else if($roleId == 5) $tab = "REVIEWED";
                else if($roleId == 10) $tab = "REVIEWED";
                else if($roleId == 6) $tab = "";
                else if(!in_array($roleId,[4,5,6])) $tab = "";
            }
            else if( $stageId == 5){
                if($roleId == 4) $tab = "PENDING";
                else if($roleId == 5) $tab = "REVIEWED";
                else if($roleId == 6) $tab = "REVIEWED";
                else if($roleId == 10) $tab = "REVIEWED";
                else if(!in_array($roleId,[4,5,6]) && $stageId == 5) $tab = "PENDING";                
            }
            else if($stageId == 6){
                if($roleId == 4) $tab = "REVIEWED";
                else if($roleId == 5) $tab = "PENDING";
                else if($roleId == 6) $tab = "REVIEWED";
                else if($roleId == 10) $tab = "REVIEWED";                
                else if(!in_array($roleId,[4,5,6]) && $stageId == 6) $tab = "";
            }            
            else if( $stageId == 7 ||  $stageId == 8 ||  $stageId == 9){
                if($roleId == 4) $tab = "REVIEWED";
                else if($roleId == 5) $tab = "REVIEWED";
                else if($roleId == 6) $tab = "REVIEWED";
                else if($roleId == 10) $tab = "REVIEWED";
                else if(!in_array($roleId,[4,5,6])) $tab = "REVIEWED";
            }            
        }
        
        return $tab;
    }

    public function calculatedTab($requestData){
        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "HIRA")->pluck("ROLE_ID")->first();
        return $this -> mapRoleStageTab($requestData,$userRoles);
    }
    
    public function getHiraList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $tab = $requestData->TAB ?? "PENDING";

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "HIRA")->pluck("ROLE_ID")->first();
        
        if(!empty($requestData->STAGE_ID)){
            $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        }        
        $query = Hira::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "HIRA_REFERENCE_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "HIRA_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "HIRA_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        if (strtoupper($tab) == "PENDING") { 
            if ($userRoles == 4) {
                $query->whereIn('STAGE_ID', [4,5]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 5) {
                $query->whereIn('STAGE_ID', [2,6]);
            } elseif ($userRoles == 6) {                
                $query->whereIn('STAGE_ID', [3]);               
            }else if(!in_array($userRoles,[4,5,6])){
                $activitylist = HiraActivity::where('IS_ACTIVE',1)->where('IS_DELETED',0)->where('STAGE_ID',1)
                ->where('ACTION_OWNER_ID',$requestData->CREATED_BY)->pluck('HIRA_ID')->unique()->toArray();
                $activitylist = array_unique($activitylist);
                $query->where(function($query3) use ($activitylist) {                   
                    $query3->whereIn('STAGE_ID', [3]);
                    $query3->orWhere(function($query3) use ($activitylist) {
                        $query3->whereIn('STAGE_ID', [5]);
                        $query3->whereIn('ID', $activitylist);
                    });                   
                });
            }
        } elseif (strtoupper($tab) == "REVIEWED") {
            if ($userRoles == 4) {
                $query->whereIn('STAGE_ID', [2,6,7,8,9]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 5) {
                $query->whereIn('STAGE_ID', [3,4,5,7,8,9]);
            } elseif ($userRoles == 6) {
                $query->whereIn('STAGE_ID', [5,6,7,8,9]);
            }else if(!in_array($userRoles,[4,5,6])){
                $activitylist = HiraActivity::where('IS_ACTIVE',1)->where('IS_DELETED',0)->where('STAGE_ID',2)
                ->where('ACTION_OWNER_ID',$requestData->CREATED_BY)->pluck('HIRA_ID')->unique()->toArray();
                $activitylist = array_unique($activitylist);
                $query->where(function($query3) use ($activitylist) {                   
                    $query3->whereIn('STAGE_ID', [3]);
                    $query3->orWhere(function($query3) use ($activitylist) {
                        $query3->whereIn('STAGE_ID', [5]);
                        $query3->whereIn('ID', $activitylist);
                    });                   
                });
            }elseif ($userRoles == 10) {
                $query->whereNotIn('STAGE_ID', [1]);
            }
        }elseif(strtoupper($tab) == "DRAFT"){
            if ($userRoles == 4) {
                $query->whereIn('STAGE_ID', [1]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            }
        }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);


        /////////////////////////////PAGINATION LOGIC incorporation/////////////////////////////////////

        $this->page = $requestData->PAGE_NUM ?? 1; // Default to page 1 if not provided
        $this->pageSize = $requestData->PAGE_SIZE ?? config("constants.PAGINATION_PER_PAGE");

       
        /////////////////////////////END OF PAGINATION LOGIC incorporation/////////////////////////////////////
        return $query->paginate($this->pageSize, ['*'], 'page', $this->page);
    }

    public function getHiraListTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        $tab = $requestData->TAB ?? "PENDING";
        $query = Hira::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage'];

        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY)
                    ->where("MODULE_NAME", "HIRA")->pluck("ROLE_ID")->first();

        if(!empty($requestData->STAGE_ID)){
            $tab = $this -> mapRoleStageTab($requestData,$userRoles);
        }


        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "HIRA_REFERENCE_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "HIRA_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "HIRA_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        if (strtoupper($tab) == "PENDING") {            
            if ($userRoles == 4) {
                $query->whereIn('STAGE_ID', [4,5]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 5) {               
                $query->whereIn('STAGE_ID', [2,6]);               
            } elseif ($userRoles == 6) {               
                $query->whereIn('STAGE_ID', [3]);               
            }else if(!in_array($userRoles,[4,5,6])){
                $activitylist = HiraActivity::where('IS_ACTIVE',1)->where('IS_DELETED',0)->where('STAGE_ID',1)
                ->where('ACTION_OWNER_ID',$requestData->CREATED_BY)->pluck('HIRA_ID')->unique()->toArray();
                $activitylist = array_unique($activitylist);
                $query->where(function($query3) use ($activitylist) {                   
                    $query3->whereIn('STAGE_ID', [3]);
                    $query3->orWhere(function($query3) use ($activitylist) {
                        $query3->whereIn('STAGE_ID', [5]);
                        $query3->whereIn('ID', $activitylist);
                    });                   
                });
            }
        } elseif (strtoupper($tab) == "REVIEWED") {
            if ($userRoles == 4) {
                $query->whereIn('STAGE_ID', [2,6,7,8,9]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            } elseif ($userRoles == 5) {
                $query->whereIn('STAGE_ID', [3,4,5,7,8,9]);
            } elseif ($userRoles == 6) {
                $query->whereIn('STAGE_ID', [5,6,7,8,9]);
            }else if(!in_array($userRoles,[4,5,6])){
                $activitylist = HiraActivity::where('IS_ACTIVE',1)->where('IS_DELETED',0)->where('STAGE_ID',2)
                ->where('ACTION_OWNER_ID',$requestData->CREATED_BY)->pluck('HIRA_ID')->unique()->toArray();
                $activitylist = array_unique($activitylist);
                $query->where(function($query3) use ($activitylist) {                   
                    $query3->whereIn('STAGE_ID', [3]);
                    $query3->orWhere(function($query3) use ($activitylist) {
                        $query3->whereIn('STAGE_ID', [5]);
                        $query3->whereIn('ID', $activitylist);
                    });                   
                });
            }elseif ($userRoles == 10) {
                $query->whereNotIn('STAGE_ID', [1]);
            }
        }elseif(strtoupper($tab) == "DRAFT"){
            if ($userRoles == 4) {
                $query->whereIn('STAGE_ID', [1]);
                $query->where("CREATED_BY", $requestData->CREATED_BY);
            }
        }
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->count();
    }

    public function getHiraDetails($requestData)
    {
        return Hira::where("ID", $requestData->HIRA_ID)->first();
    }

    public function getAllHiraDetails($hiraData)
    {
        return Hira::where("TOP_PARENT_HIRA_ID", $hiraData->TOP_PARENT_HIRA_ID)->get();
    }

    protected function autoGenNumberGeneration($requestedData)
    {        
        if($requestedData->ID > 0){
            $siteId = Hira::where("ID",$requestedData->ID)->pluck("LOCATION_ID")->first();
        }else{
            $siteId = $requestedData -> LOCATION_ID;
        }
        $siteName   = HiraMstLocation::where("LOCATION_ID", $siteId)->pluck("LOCATION_ALIAS")->first();
        //$initialSearch = "SHW_IND_"; 
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            $initialSearch = "DRAFT_";
        }
        else{
            $initialSearch = "SHW_IND_";
        }
        $previousNumber = DB::table('HIRA')
                            ->where("LOCATION_ID", $siteId)
                            ->where("HIRA_REFERENCE_NO", "LIKE", $initialSearch . strtoupper($siteName) . "%")
                            ->max(DB::raw("CAST(regexp_replace(\"HIRA_REFERENCE_NO\", '\\D', '', 'g') AS INTEGER)"));        
        $previousNumber = $previousNumber ?: 0;

        // Define prefix and suffix
        $prefix = config("constants.HIRA_REFERENCE_PREFIX");
        $siteMappingArray = typeIdTextMapping();
        //$middle = "_".$siteMappingArray[$requestedData -> SITE_ID]."_";  
        $middle = "_";       
        
        // Increment the last digit based on the value of $previousNumber
        $lastDigit = $previousNumber + 1;

        // Concatenate all parts to form the output
        //return $prefix . strtoupper($siteName) . $middle . $lastDigit;
        if( strtoupper($requestedData -> ACTION) == "DRAFT" ){
            return $initialSearch.strtoupper($siteName)."-".$lastDigit;
        }else{
            return $prefix . strtoupper($siteName) . $middle . $lastDigit;
        }
    }

    protected function getStages($requestAction)
    {
        $stageId = 1;
        if (strtoupper($requestAction) == "DRAFT") {
            $stageId = 1;
        } elseif (strtoupper($requestAction) == "SAVE") {
            $stageId = 2;
        } elseif (strtoupper($requestAction) == "MOVE_FORWARD") {
            $stageId = 3;
        } elseif (strtoupper($requestAction) == "SEND_BACK") {
            $stageId = 4;
        } elseif (strtoupper($requestAction) == "APPROVE") {
            $stageId = 5;
        } elseif (strtoupper($requestAction) == "REJECT") {
            $stageId = 6;
        } elseif (strtoupper($requestAction) == "RENEW") {
            $stageId = 9;
        } elseif (strtoupper($requestAction) == "REVISE") {
            $stageId = 7;
        }
        return $stageId;
    }
    protected function transformHIRATableData($requestData)
    {
        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY) ->where("MODULE_NAME", "HIRA")->pluck("ROLE_ID")->first();
        if (in_array(strtoupper($requestData->ACTION), ["DRAFT", "SAVE","RENEW", "REVISE"])) {

            if($requestData->ID == 0){
                $processedData = [
                    "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
                ];
            }elseif($userRoles == 4 && in_array(strtoupper($requestData->ACTION), ["DRAFT", "SAVE"])){
                $hiraExistAlready = Hira::where("ID",$requestData->ID)->first();
                if($hiraExistAlready->STAGE_ID == 5){
                    $processedData = [
                        "STAGE_ID"  =>  $this->getStages("SAVE")
                    ];
                }                
            }
                        
            if (isset($requestData->SITE_ID)) {
                $processedData["SITE_ID"]  =  $requestData->SITE_ID;
            }            
            if (isset($requestData->LOCATION_ID)) {
                $processedData["LOCATION_ID"]  =  $requestData->LOCATION_ID;
            }
            if (isset($requestData->HIRA_START_DATE)) {
                $processedData["HIRA_START_DATE"]  = createSlashDate($requestData->HIRA_START_DATE, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->HIRA_END_DATE)) {
                $processedData["HIRA_END_DATE"]  =  createSlashDate($requestData->HIRA_END_DATE, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->TITLE)) {
                $processedData["TITLE"]  =  $requestData->TITLE;
            }
            if ($requestData->ID == 0) {               
                $processedData["HIRA_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" && strtoupper($requestData->ACTION) != "RVISE") ? 
                                                        $this->autoGenNumberGeneration($requestData) : "";
            } 
            if( strtoupper($requestData->ACTION) == "SAVE"){
                $hiraDraftAlready = Hira::where("ID",$requestData->ID)->where("HIRA_REFERENCE_NO","LIKE","DRAFT_%");
                if($hiraDraftAlready -> exists()){
                    $processedData["HIRA_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" && strtoupper($requestData->ACTION) != "RVISE") ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                }
            }             
        } else {                      
            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];            
        }        

        if (isset($requestData->ID) &&  $requestData->ID > 0) {
            $processedData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedData["MODIFIED_ON"] = currentDateTime();
        } else {
            $processedData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedData["CREATED_ON"] = currentDateTime();
        }
        return $processedData;
    }

    protected function transformHIRAInfoTableData($requestData)
    {
        $userRoles = UserMapRole::where("USER_ID", $requestData->CREATED_BY) ->where("MODULE_NAME", "HIRA")->pluck("ROLE_ID")->first();
        if (in_array(strtoupper($requestData->ACTION), ["DRAFT", "SAVE","RENEW", "REVISE"])) {

            if($userRoles == 4){
                $processedData = [
                    "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
                ];
            }if($userRoles == 5){
                $processedData = [
                    "STAGE_ID"  =>  $this->getStages("MOVE_FORWARD")
                ];
            }if($userRoles == 6){
                $processedData = [
                    "STAGE_ID"  =>  $this->getStages("APPROVE")
                ];
            }elseif($requestData->ID == 0){
                $processedData = [
                    "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
                ];
            }
                        
            if (isset($requestData->SITE_ID)) {
                $processedData["SITE_ID"]  =  $requestData->SITE_ID;
            }            
            if (isset($requestData->LOCATION_ID)) {
                $processedData["LOCATION_ID"]  =  $requestData->LOCATION_ID;
            }
            if (isset($requestData->HIRA_START_DATE)) {
                $processedData["HIRA_START_DATE"]  = createSlashDate($requestData->HIRA_START_DATE, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->HIRA_END_DATE)) {
                $processedData["HIRA_END_DATE"]  =  createSlashDate($requestData->HIRA_END_DATE, config("constants.DATE_TIME_FORMAT"));
            }
            if (isset($requestData->TITLE)) {
                $processedData["TITLE"]  =  $requestData->TITLE;
            }
            if ($requestData->ID == 0) {               
                $processedData["HIRA_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" && strtoupper($requestData->ACTION) != "RVISE") ? 
                                                        $this->autoGenNumberGeneration($requestData) : "";
            } 
            if( strtoupper($requestData->ACTION) == "SAVE"){
                $hiraDraftAlready = Hira::where("ID",$requestData->ID)->where("HIRA_REFERENCE_NO","LIKE","DRAFT_%");
                if($hiraDraftAlready -> exists()){
                    $processedData["HIRA_REFERENCE_NO"]  =  (strtoupper($requestData->ACTION) != "RENEW" && strtoupper($requestData->ACTION) != "RVISE") ? 
                                                            $this->autoGenNumberGeneration($requestData) : "";
                }
            }             
        } else {                      
            $processedData = [
                "STAGE_ID"  =>  $this->getStages($requestData->ACTION)
            ];            
        }        

        if (isset($requestData->ID) &&  $requestData->ID > 0) {
            $processedData["MODIFIED_BY"] = $requestData->CREATED_BY;
            $processedData["MODIFIED_ON"] = currentDateTime();
        } else {
            $processedData["CREATED_BY"] = $requestData->CREATED_BY;
            $processedData["CREATED_ON"] = currentDateTime();
        }
        return $processedData;
    }

    public function save($requestData)
    {  
        DB::beginTransaction();
        try { 
        if (isset($requestData->ACTION) && strtoupper($requestData->ACTION) == "RENEW") {
            $hiraId = $this -> renewal($requestData);
        }elseif (isset($requestData->ACTION) && strtoupper($requestData->ACTION) == "REVISE") {
            $hiraId = $this -> renewal($requestData);
        }else{ 
            $hiraId = $requestData->ID;        
            if($requestData->ACTION != "DELETE"){
                $processedData = $this->transformHIRATableData($requestData);
            }else{
                $processedData["IS_ACTIVE"] = 0;
                $processedData["IS_DELETED"] = 1;
                $processedData["MODIFIED_BY"] = $requestData->CREATED_BY;
                $processedData["MODIFIED_ON"] = currentDateTime();
            }             
            if ($hiraId > 0) {
                //update ptw tables and upsert all associated tables
                Hira::where("ID", $hiraId)->update($processedData);
            } else {
                //insert hira tables and insert all associated tables
                //insert into Hira table
                $hiraInsert = Hira::create($processedData);
                $hiraId = $hiraInsert->ID;
            }        
            
            if(in_array(strtoupper($requestData->ACTION), ["DRAFT", "SAVE"])){           
                //insert into log table
                HiraActionHistory::insert(
                    [
                        "HIRA_ID" => $hiraId,
                        "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                        "STAGE_ID"  => $this->getStages($requestData->ACTION),
                        "COMMENTS"  => $requestData->REMARKS ?? "",                
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ]
                );
            }
        }      
        
        $this->auditSave($requestData,$hiraId);
        DB::commit();      
        
        if($hiraId != ""){
            return HIRA::where("ID", $hiraId)->first();
        }else{
            return "";
        }
        } catch (\Exception $e) {
            //     // If an exception occurs during the transaction, rollback the changes
                DB::rollBack();
                prd($e->getMessage());
            //     // You can handle the exception here, log it, or return an error response
                return "";
        }
    }

    public function saveInfo($requestData)
    {
        $hiraId = $requestData->ID;
        DB::beginTransaction();
        try {
            
        if (isset($requestData->ACTION) && strtoupper($requestData->ACTION) == "RENEW") {
            $hiraId = $this -> renewal($requestData);
        }if(isset($requestData->ACTION) && strtoupper($requestData->ACTION) == "REVISE") {
            $hiraId = $this -> renewal($requestData);
        }else{
            //insert into HIRA_MAP_WORKERS
           
            $hiraMapActivityData = $this->transformHiraMapActivityTableData($requestData, $hiraId);
                

            //insert into HIRA_MAP_DECLARATION

            $hiraMapDeclarationData = $this->transformHiraMapDeclarationTableData($requestData, $hiraId);
            if (count($hiraMapDeclarationData)) {
                //soft delete old data if exists
                $addRequestClass = new AddRequest();
                $declarationSectionId = $addRequestClass->getDeclarationSectionbyAction($requestData->ACTION);

                if ($declarationSectionId == 1) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_ADD")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 2) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_MOVE_FORWARD")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 3) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_APPROVE")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 4) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_REJECT")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 5) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_REQUEST_FOR_CLOSURE")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 6) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_CLOSE")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 7) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_SUSPEND")->pluck("DECLARATION_ID")->all();
                } elseif ($declarationSectionId == 8) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_REQUEST_FOR_SUSPEND")->pluck("DECLARATION_ID")->all();
                }elseif ($declarationSectionId == 9) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_RENEW")->pluck("DECLARATION_ID")->all();
                }elseif ($declarationSectionId == 10) {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->where("DECLARATION_GROUP", "HIRA_ACCEPT_CONTROL_MEASURES")->pluck("DECLARATION_ID")->all();
                } else {
                    $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                        ->whereNot("DECLARATION_GROUP", "HIRA_ADD")->pluck("DECLARATION_ID")->all();
                }

                HiraMapDeclaration::where("HIRA_ID", $hiraId)->where("IS_DELETED", 0)
                    ->whereIn("DECLARATION_ID", $allDeclarationData)
                    ->update([
                        "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                        "MODIFIED_ON" => currentDateTime()
                    ]);
                //insert new data
                HiraMapDeclaration::insert($hiraMapDeclarationData);
            }

            $processedData = $this->transformHIRAInfoTableData($requestData);
                    
            if ($hiraId > 0) {
                //update ptw tables and upsert all associated tables
                Hira::where("ID", $hiraId)->update($processedData);
            }

            //insert into log table
            HiraActionHistory::insert(
                [
                    "HIRA_ID" => $hiraId,
                    "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                    "STAGE_ID"  => $this->getStages($requestData->ACTION),
                    "COMMENTS"  => $requestData->REMARKS ?? "",
                    "CREATED_BY" => $requestData->CREATED_BY,
                    "CREATED_ON" => currentDateTime()
                ]
            );

            $this->auditSave($requestData,$hiraId); 
            $stage_id = $this->getStages($requestData->ACTION);
            // $this->vvsHiraSendMailService->hiraSendMail($stage_id,$hiraId);
            DB::commit();  
        }
        
        if($hiraId != ""){
            return Hira::where("ID", $hiraId)->first();
        }else{
            return "";
        }
        } catch (\Exception $e) {
            //     // If an exception occurs during the transaction, rollback the changes
                DB::rollBack();
                prd($e->getMessage());
            //     // You can handle the exception here, log it, or return an error response
                return "";
        }
    }

    protected function transformHiraMapActivityTableData($requestData, $hiraId)
    {       
        if (isset($requestData->ACTIVITY_DTLS)) {
            if (count($requestData->ACTIVITY_DTLS) > 0) {
                // HiraActivity::where("HIRA_ID", $hiraId)->where("IS_DELETED", 0)
                // ->update([
                //     "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                //     "MODIFIED_ON" => currentDateTime()
                // ]);
                HiraMapControlInPlace::where("HIRA_ID", $hiraId)->where("IS_DELETED", 0)
                ->update([
                    "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                    "MODIFIED_ON" => currentDateTime()
                ]);
                HiraMapRefDoc::where("HIRA_ID", $hiraId)->where("IS_DELETED", 0)
                ->update([
                    "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                    "MODIFIED_ON" => currentDateTime()
                ]);
                HiraMapActivityType::where("HIRA_ID", $hiraId)->where("IS_DELETED", 0)
                ->update([
                    "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                    "MODIFIED_ON" => currentDateTime()
                ]);
                foreach ($requestData->ACTIVITY_DTLS as $value) {
                    $severity = HiraMstSeverity::where("SEVERITY_ID", $value->SEVERITY_ID)->pluck("SEVERITY_NAME")->first();
                    $likelihood = HiraMstLikelihood::where("LIKELIHOOD_ID", $value->LIKELIHOOD_ID)->pluck("LIKELIHOOD_NAME")->first();
                    $orderByRank = getSeverityLikehoodOrderBy($severity,$likelihood);
                    $processedData = [
                        "HIRA_ID" => $hiraId,
                        "JOB_ID" => $value->JOB_ID,
                        "RISK_RELATED_ID" => $value->RISK_RELATED_ID,
                        "DESCRIPTION" => $value->DESCRIPTION,
                        "IS_PTW_REQUIRED" => $value->IS_PTW_REQUIRED,
                        "PTW_TYPE_ID" => $value->PTW_TYPE_ID??null,
                        "SEVERITY_ID" => $value->SEVERITY_ID,
                        "LIKELIHOOD_ID" => $value->LIKELIHOOD_ID,
                        "ADDTNL_CONTROL_MEASURE" => $value->ADDTNL_CONTROL_MEASURE,
                        "ACTION_OWNER_ID" => $value->ACTION_OWNER_ID,
                        "ORD_BY_SEVERITY" => $orderByRank,
                        "STAGE_ID" => 1,
                        "IS_ACTIVE" => (($value->IS_DELETED == 1)? 0 : 1),
                        "IS_DELETED" => (($value->IS_DELETED == 1)? 1 : 0),
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                    //$processedData  = array_filter($processedData);//prd($processedData);  
                    //$activityInsert = HiraActivity::create($processedData);
                    //$activityId = $activityInsert->ID;
                    $recordCount = HiraActivity::where("HIRA_ID", $hiraId)->where("ID",$value->HIRA_ACTIVITY_ID)->get()->toArray();
                    if(count($recordCount)){
                        HiraActivity::where("HIRA_ID", $hiraId)->where("ID",$value->HIRA_ACTIVITY_ID)
                        ->update($processedData);
                        $activityId = $value->HIRA_ACTIVITY_ID;
                    }else{
                        $activityInsert = HiraActivity::create($processedData);
                        $activityId = $activityInsert->ID;
                    }
                    $processedDataAct = [];
                    if (isset($value->ACTIVITY_ID)) {
                        if (count($value->ACTIVITY_ID)) {
                            foreach ($value->ACTIVITY_ID as $cvValue) {
                                $processedDataAct[] = [
                                    "HIRA_ID" => $hiraId,
                                    "ACTIVITY_ID" => $activityId,
                                    "MST_ACTIVITY_TYPE_ID" => $cvValue,
                                    "CREATED_BY" => $requestData->CREATED_BY,
                                    "CREATED_ON" => currentDateTime()
                                ];
                            }
                            HiraMapActivityType::insert($processedDataAct);
                        }
                    }
                    $processedDataCP=[];
                    if (isset($value->CONTROL_IN_PLACE)) {
                        if (count($value->CONTROL_IN_PLACE)) {
                            foreach ($value->CONTROL_IN_PLACE as $cvValue) {
                                $processedDataCP[] = [
                                    "HIRA_ID" => $hiraId,
                                    "ACTIVITY_ID" => $activityId,
                                    "CONTROL_IN_PLACE_NAME" => $cvValue->CONTROL_IN_PLACE_NAME,
                                    "CREATED_BY" => $requestData->CREATED_BY,
                                    "CREATED_ON" => currentDateTime()
                                ];
                            }
                            HiraMapControlInPlace::insert($processedDataCP);
                        }
                    }
                    $processedDataRD = [];
                    if (isset($value->REF_DOC)) {
                        if (count($value->REF_DOC)) {
                            foreach ($value->REF_DOC as $cvValue) {
                                $processedDataRD[] = [
                                    "HIRA_ID" => $hiraId,
                                    "ACTIVITY_ID" => $activityId,
                                    "HIRA_MAP_REF_DOC_NAME" => $cvValue->REF_DOC_NAME,
                                    "CREATED_BY" => $requestData->CREATED_BY,
                                    "CREATED_ON" => currentDateTime()
                                ];
                            }
                            HiraMapRefDoc::insert($processedDataRD);
                        }
                    }

                    // insert into log table (special)
                    if (isset($requestData->JSON_VALUE)) {
                        HiraChangeLog::create(
                            [
                                "HIRA_ID" => $hiraId,
                                "HIRA_ACTIVITY_ID" => $activityId,
                                "CREATED_BY"  => $requestData->CREATED_BY,
                                "CREATED_ON"  => currentDateTime(),
                                "JSON_VALUE" => json_encode($requestData->JSON_VALUE)
                            ]
                        );
                    }
                    
                }
            }
        }
        return $hiraId;
    }

    protected function transformHiraMapDeclarationTableData($requestData, $hiraId)
    {
        $processedData = [];
        if (isset($requestData->DECLARATION)) {
            if (count($requestData->DECLARATION) > 0) {
                foreach ($requestData->DECLARATION as $value) {
                    $processedData[] = [
                        "HIRA_ID" => $hiraId,
                        "DECLARATION_ID" => $value,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                }
            }
        }
        return $processedData;
    }

    protected function autoGenNumberGenerationRevise($hiradata)
    {        
        $siteId = $hiradata -> LOCATION_ID;
        $siteName   = HiraMstLocation::where("LOCATION_ID", $siteId)->pluck("LOCATION_ALIAS")->first();        
        $initialSearch = "SHW_IND_"; 
        //$initialSearch = "DRAFT_";
        $previousNumber = DB::table('HIRA')
                            ->where("LOCATION_ID", $siteId)
                            ->where("HIRA_REFERENCE_NO", "LIKE", $initialSearch . strtoupper($siteName) . "%")
                            ->max(DB::raw("CAST(regexp_replace(\"HIRA_REFERENCE_NO\", '\\D', '', 'g') AS INTEGER)"));        
        $previousNumber = $previousNumber ?: 0;        
        // Define prefix and suffix
        $prefix = config("constants.HIRA_REFERENCE_PREFIX");
        $siteMappingArray = typeIdTextMapping();
        //$middle = "_".$siteMappingArray[$requestedData -> SITE_ID]."_";  
        $middle = "_";       
        
        // Increment the last digit based on the value of $previousNumber
        $lastDigit = $previousNumber + 1;

        // Concatenate all parts to form the output
        return $prefix . strtoupper($siteName) . $middle . $lastDigit;
    }

    public function renewal($requestData){
        DB::beginTransaction();
        try {
        $hiraQuery = Hira::where("IS_DELETED",0)->where("IS_ACTIVE",1)->where("ID",$requestData->PARENT_HIRA_ID)->where("STAGE_ID",5);
        $renewdHiraId = 0;
        if($hiraQuery-> exists()){
            $hiraData = $hiraQuery -> first();
            $prevHira = Hira::where("ID", $requestData->PARENT_HIRA_ID)->where("IS_DELETED", 0)->where("IS_ACTIVE", 1)->first();

            $hira["SITE_ID"] = $hiraData->SITE_ID;
            $hira["HIRA_REFERENCE_NO"] = $hiraData->HIRA_REFERENCE_NO;
            if(strtoupper($requestData->ACTION) == "RENEW"){
                $hira["HIRA_REFERENCE_NO"] = $this->autoGenNumberGenerationRevise($hiraData); 
            }
                       
            $hira["LOCATION_ID"] = $requestData->LOCATION_ID;
            $hira["TITLE"] = $requestData->TITLE;
            $hira_start_date = date("Y-m-d 00:00:00",strtotime($requestData->HIRA_START_DATE)); 
            $hira_end_date = date("Y-m-d 00:00:00",strtotime($requestData->HIRA_END_DATE));           
            $hira['HIRA_START_DATE'] = createSlashDate($hira_start_date, config("constants.DATE_FORMAT"));
            $hira['HIRA_END_DATE'] = createSlashDate($hira_end_date, config("constants.DATE_FORMAT"));            
            $hira['STAGE_ID'] = 2;
            $hira["PARENT_HIRA_ID"] = $requestData->PARENT_HIRA_ID ?? null;
            $hira['TOP_PARENT_HIRA_ID'] = ($prevHira->RENEWAL_COUNT == 0) ? 
                                                $requestData->PARENT_HIRA_ID : $prevHira-> TOP_PARENT_HIRA_ID;
            $hira['RENEWAL_COUNT'] = ($prevHira->RENEWAL_COUNT + 1);           
            $hira['CREATED_BY'] = $requestData->CREATED_BY;
            $hira["CREATED_ON"] = currentDateTime();
           
            
            $renewdHiraIdInsert = Hira::create($hira);
            $renewdHiraId = $renewdHiraIdInsert->ID;

            //HIRA_ACTIVITY
            $hiraMapActivityData = $this->transformHiraMapActivityTableData($requestData, $renewdHiraId);

            //HIRA ACTIVITY MAP INSERT            
            /*if($prevHira->activities->count() > 0){ 
                foreach($prevHira->activities as $k => $v){
                    $processedData = [
                        "HIRA_ID" => $renewdHiraId,
                        "JOB_ID" => $v->JOB_ID,                        
                        "RISK_RELATED_ID" => $v->RISK_RELATED_ID,
                        "DESCRIPTION" => $v->DESCRIPTION,
                        "IS_PTW_REQUIRED" => $v->IS_PTW_REQUIRED,
                        "PTW_TYPE_ID" => $v->PTW_TYPE_ID,
                        "SEVERITY_ID" => $v->SEVERITY_ID,
                        "LIKELIHOOD_ID" => $v->LIKELIHOOD_ID,
                        "ADDTNL_CONTROL_MEASURE" => $v->ADDTNL_CONTROL_MEASURE,
                        "ACTION_OWNER_ID" => $v->ACTION_OWNER_ID,
                        "STAGE_ID" => 1,
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ];
                    $processedData  = array_filter($processedData);//prd($processedData);  
                    $activityInsert = HiraActivity::create($processedData);
                    $activityId = $activityInsert->ID;
                    $processedDataAct=[];                    
                    if ($v->activitytype->count() > 0) {
                        foreach ($v->activitytype as $cvValue) {
                            $processedDataAct[] = [
                                "HIRA_ID" => $renewdHiraId,
                                "ACTIVITY_ID" => $activityId,
                                "MST_ACTIVITY_TYPE_ID" => $cvValue->MST_ACTIVITY_TYPE_ID,
                                "CREATED_BY" => $requestData->CREATED_BY,
                                "CREATED_ON" => currentDateTime()
                            ];
                        }
                        HiraMapActivityType::insert($processedDataAct);
                    } 
                    $processedDataCP=[];                    
                    if ($v->controlinplaces->count() > 0) {
                        foreach ($v->controlinplaces as $cvValue) {
                            $processedDataCP[] = [
                                "HIRA_ID" => $renewdHiraId,
                                "ACTIVITY_ID" => $activityId,
                                "CONTROL_IN_PLACE_NAME" => $cvValue->CONTROL_IN_PLACE_NAME,
                                "CREATED_BY" => $requestData->CREATED_BY,
                                "CREATED_ON" => currentDateTime()
                            ];
                        }
                        HiraMapControlInPlace::insert($processedDataCP);
                    }                    
                    $processedDataRD = [];
                    if ($v->refdocs->count() > 0) {
                        foreach ($v->refdocs as $cvValue) {
                            $processedDataRD[] = [
                                "HIRA_ID" => $renewdHiraId,
                                "ACTIVITY_ID" => $activityId,
                                "HIRA_MAP_REF_DOC_NAME" => $cvValue->HIRA_MAP_REF_DOC_NAME,
                                "CREATED_BY" => $requestData->CREATED_BY,
                                "CREATED_ON" => currentDateTime()
                            ];
                        }
                        HiraMapRefDoc::insert($processedDataRD);
                    }
                }
            }*/

            //HIRA_MAP_DECLARATION
            $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                ->where("DECLARATION_GROUP", "HIRA_ADD")->pluck("DECLARATION_ID")->all();
            $hiraMapDeclarationExists = HiraMapDeclaration::where("HIRA_ID",$requestData->PARENT_HIRA_ID)
                                        ->where("IS_ACTIVE",1)->where("IS_DELETED",0)
                                        ->whereIn("DECLARATION_ID",$allDeclarationData);
            if($hiraMapDeclarationExists ->exists()){
                $hiraMapDeclarationData = $hiraMapDeclarationExists -> get();
                foreach($hiraMapDeclarationData -> toArray() as $k => $v){
                    $hiraSopPol3["HIRA_ID"] = $renewdHiraId;
                    $hiraSopPol3["DECLARATION_ID"] = $v["DECLARATION_ID"];
                    $hiraSopPol3["CREATED_BY"] = $requestData->CREATED_BY;
                    $hiraSopPol3["CREATED_ON"] = currentDateTime();
                    HiraMapDeclaration::create($hiraSopPol3);
                }
            }            

            if(strtoupper($requestData->ACTION) == "RENEW"){
                //update parent ptw id
                Hira::where("ID", $prevHira->ID)->update([
                    "STAGE_ID"  => 9,
                    "MODIFIED_BY" => $requestData->CREATED_BY,
                    "MODIFIED_ON" => currentDateTime()
                ]);

                HiraActionHistory::insert(
                    [
                        "HIRA_ID" => $prevHira->ID,
                        "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                        "STAGE_ID"  => 9,
                        "COMMENTS"  => $requestData->REMARKS ?? "",
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ]
                );
            }else{
                //update parent ptw id
                Hira::where("ID", $prevHira->ID)->update([
                    "STAGE_ID"  => 7,
                    "MODIFIED_BY" => $requestData->CREATED_BY,
                    "MODIFIED_ON" => currentDateTime()
                ]);

                HiraActionHistory::insert(
                    [
                        "HIRA_ID" => $prevHira->ID,
                        "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                        "STAGE_ID"  => 7,
                        "COMMENTS"  => $requestData->REMARKS ?? "",
                        "CREATED_BY" => $requestData->CREATED_BY,
                        "CREATED_ON" => currentDateTime()
                    ]
                );
            }
            

            HiraActionHistory::insert(
                [
                    "HIRA_ID" => $renewdHiraId,
                    "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                    "STAGE_ID"  => 2,
                    "COMMENTS"  => $requestData->REMARKS ?? "",
                    "CREATED_BY" => $requestData->CREATED_BY,
                    "CREATED_ON" => currentDateTime()
                ]
            );
        }
        DB::commit();
        return $renewdHiraId;
        } catch (\Exception $e) {
            // If an exception occurs during the transaction, rollback the changes
             DB::rollBack();
            prd($e->getMessage());
            // You can handle the exception here, log it, or return an error response
             return "";
        }
    }

    public function saveHiraAcm($requestData)
    {
        $hiraId = $requestData->ID;
        $hiraMapDeclarationData = $this->transformHiraMapDeclarationTableData($requestData, $hiraId);
        $allDeclarationData = HiraMstDeclaration::where("IS_DELETED", 0)->where("IS_ACTIVE", 1)
                                ->where("DECLARATION_GROUP", "HIRA_ACCEPT_CONTROL_MEASURES")
                                ->pluck("DECLARATION_ID")->all();
        HiraMapDeclaration::where("HIRA_ID", $hiraId)->where("IS_DELETED", 0)
                            ->whereIn("DECLARATION_ID", $allDeclarationData)
                            ->update([
                                "IS_DELETED" => 1, "IS_ACTIVE" => 0, "MODIFIED_BY" => $requestData->CREATED_BY,
                                "MODIFIED_ON" => currentDateTime()
                            ]);
        //insert new data
        HiraMapDeclaration::insert($hiraMapDeclarationData);
        
        $hiraActiviy["ACM_REMARKS"] = $requestData->ACM_REMARKS;
        $hiraActiviy["STAGE_ID"] = 2;
        $hiraActiviy["MODIFIED_BY"] = $requestData->CREATED_BY;
        $hiraActiviy["MODIFIED_ON"] = currentDateTime();
        HiraActivity::where("ID", $requestData->ACTIVITY_ID)->update($hiraActiviy);
        
        $processedData["MODIFIED_BY"] = $requestData->CREATED_BY;
        $processedData["MODIFIED_ON"] = currentDateTime();
        Hira::where("ID", $hiraId)->update($processedData);
                    
        
        //insert into log table
        HiraActionHistory::insert(
            [
                "HIRA_ID" => $hiraId,
                "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                "STAGE_ID"  => 5,
                "COMMENTS"  => $requestData->ACM_REMARKS ?? "",
                "CREATED_BY" => $requestData->CREATED_BY,
                "CREATED_ON" => currentDateTime()
            ]
        );

        
        if($hiraId != ""){
            return Hira::where("ID", $hiraId)->first();
        }else{
            return "";
        }
    }  

    protected function gethiraAuditDetails($requestData){        
        if (isset($requestData->SITE_ID)) {            
            $requestData->SITE = MstSite::where('SITE_ID',$requestData->SITE_ID)->pluck("SITE_NAME")->first();            
        }
       
        if (isset($requestData->LOCATION_ID)) {            
            $requestData->LOCATION = HiraMstLocation::where('LOCATION_ID',$requestData->LOCATION_ID)->pluck("LOCATION_NAME")->first();            
        }
        
        if (isset($requestData->DECLARATION_ID)) {
            if (count($requestData->DECLARATION_ID)) {
                $requestData->DECLARATIONS = HiraMstDeclaration::whereIn('DECLARATION_ID',$requestData->DECLARATION_ID)
                                            ->get(["DECLARATION_NAME","DECLARATION_SECTION","DECLARATION_GROUP",
                                            "IS_MANDATORY_DURING_ADD"]);
            }
        }
        if (isset($requestData->ACTIVITY_DTLS)) {
            if (count($requestData->ACTIVITY_DTLS) > 0) {
                foreach ($requestData->ACTIVITY_DTLS as $value) {
                    if($value->JOB_ID){
                        $value->JOB_NAME = HiraMstJob::where('JOB_ID',$value->JOB_ID)->pluck("JOB_NAME")->first();  
                    }
                    if($value->RISK_RELATED_ID){
                        $value->RISK_RELATED_NAME = HiraMstRiskRelated::where('RISK_RELATED_ID',$value->RISK_RELATED_ID)->pluck("RISK_RELATED_NAME")->first();  
                    }
                    if($value->SEVERITY_ID){
                        $value->SEVERITY_NAME = HiraMstSeverity::where('SEVERITY_ID',$value->SEVERITY_ID)->pluck("SEVERITY_NAME")->first();  
                    }
                    if($value->LIKELIHOOD_ID){
                        $value->LIKELIHOOD_NAME = HiraMstLikelihood::where('LIKELIHOOD_ID',$value->LIKELIHOOD_ID)->pluck("LIKELIHOOD_NAME")->first();  
                    }
                    if(isset($value->PTW_TYPE_ID)){
                        $value->PTW_TYPE_NAME = PtwMstType::where('TYPE_ID',$value->PTW_TYPE_ID)->pluck("TYPE_NAME")->first();  
                    }
                    if (isset($value->ACTIVITY_ID)) {
                        if (count($value->ACTIVITY_ID)) {
                            $value->ACTIVITY_NAME = HiraMstActivity::whereIn('ACTIVITY_ID',$value->ACTIVITY_ID)->pluck("ACTIVITY_NAME");
                        }
                    }
                }
            }
        }
        unset($requestData->FILES);
        return json_encode($requestData);
    }

    public function auditSave($requestData,$hiraId){
        $auditdata = $this->gethiraAuditDetails($requestData);

        $lastLogData = HiraAuditLog::where('HIRA_ID',$hiraId)->latest()->pluck("REQUESTED_DATA")->first();

        //insert into log table
        HiraAuditLog::insert(
            [
                "HIRA_ID" => $hiraId,
                "ACTION_TAKER_ID" => $requestData->CREATED_BY,
                "OLD_DATA"  => json_encode($lastLogData),
                "REQUESTED_DATA"  => json_encode($auditdata),
                "CREATED_BY" => $requestData->CREATED_BY,
                "CREATED_ON" => currentDateTime()
            ]
        );
        
    }

    public function getHiraDownloadableList($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = Hira::query();
        // Define the relationships to eager load
        $relationshipsToLoad = ['site', 'location', 'stage','hiraactives','refdocs',
                'controlinplaces','activities','preparedby','approvedby','reviewedby','renewedhira'];

        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "HIRA_REFERENCE_NO") {
                    $query->where($columnMapping[$key], 'LIKE', '%' . $value . '%');
                }
                else if ($columnMapping[$key] == "HIRA_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=',$value);
                }
                else if ($columnMapping[$key] == "HIRA_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=',$value);
                }
                 else {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        
        $query->where("IS_ACTIVE", 1);
        $query->where("IS_DELETED", 0);
        $query->whereNotIn("STAGE_ID", [1]);
        $query->orderBy("ID", "DESC");
        // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        $query->with(['approvedby.actionTracker']);
        $query->with(['reviewedby.actionTracker']);
        $query->with(['hiraactives.hira']);
        $query->with(['hiraactives.job']);
        $query->with(['hiraactives.riskrelated']);
        $query->with(['hiraactives.severity']);
        $query->with(['hiraactives.likelihood']);
        $query->with(['hiraactives.ptwtype']);
        $query->with(['hiraactives.controlinplaces']);
        $query->with(['hiraactives.refdocs']);
        $query->with(['hiraactives.activitytype']);
        

        // Fetch action history data
        return  $query->get();
    }

    public function getSearchCriteriaList($requestData)
    {
        $searchCriteria =[];
        if (!empty($requestData->LOCATION_ID) && isset($requestData->LOCATION_ID)) {
            $location = HiraMstLocation::find($requestData->LOCATION_ID);
            if ($location) {
                $locationName = $location->LOCATION_NAME;
            }
        }
        if (!empty($requestData->SITE_ID) && isset($requestData->SITE_ID)) {
            $site = MstSite::find($requestData->SITE_ID);
            if ($site) {
                $siteName = $site->SITE_NAME;
            }
        }
        if (!empty($requestData->STAGE_ID) && isset($requestData->STAGE_ID)) {
            $stage = HiraMstStage::find($requestData->STAGE_ID);
            if ($stage) {
                $stageName = $stage->STAGE_NAME;
            }
        }

        if(isset($requestData->SITE_ID)){
            $searchCriteria["SITE_NAME"] = $siteName;
        }
        if(isset($requestData->HIRA_REFERENCE_NO)){
            $searchCriteria["HIRA_REFERENCE_NO"] = $requestData->HIRA_REFERENCE_NO;
        }
        if(isset($requestData->LOCATION_ID)){
            $searchCriteria["LOCATION_NAME"] = $locationName;
        }
        if(isset($requestData->STAGE_ID)){
            $searchCriteria["STAGE_NAME"] = $stageName;
        }
        if(isset($requestData->HIRA_START_DATE) && isset($requestData->HIRA_END_DATE) ){
            $searchCriteria["DURATION"] = $requestData->HIRA_START_DATE . " To " . $requestData->HIRA_END_DATE;
        }

        return $searchCriteria;
    }

    public function getHiraLogDetails($hiraId, $hiraActivityId) {
        $hiraIds = [$hiraId];
        $topHiraId = Hira::select("TOP_PARENT_HIRA_ID")->where("ID",$hiraId)->pluck("TOP_PARENT_HIRA_ID")->first();
        if($topHiraId ){
            $hiraIds  = Hira::select("ID")->where("TOP_PARENT_HIRA_ID",$topHiraId)->pluck("ID")->toArray();
            array_push($hiraIds,$topHiraId);
        }
       
        $query = HiraChangeLog::select("JSON_VALUE", "CREATED_ON")->whereIn("HIRA_ID", $hiraIds);
       
        if ($hiraActivityId > 0) {
            $query->where("HIRA_ACTIVITY_ID", $hiraActivityId);
        }
        $query->distinct()->orderBy("CREATED_ON", "DESC"); 
        $logs = $query->pluck('JSON_VALUE')->toArray();
        $logData = [];
    
        foreach ($logs as $value) {
            $decodedValue = json_decode($value, true);
            // If HIRA_ACTIVITY_ID is provided, filter the log data
            if ($hiraActivityId > 0) {
                foreach ($decodedValue as $data) {
                    if ($data['ID'] == $hiraActivityId) {
                        $hiraIsDeletedFlag = HiraActivity::select("IS_DELETED")->where("ID",$hiraActivityId)->pluck('IS_DELETED')->first();
                        $data["IS_DELETED"] = $hiraIsDeletedFlag;
                        $logData[] = $data;
                    }
                }
            } else {
                // If HIRA_ACTIVITY_ID is not provided, add all log data
                foreach ($decodedValue as &$element) {
                    $hiraIsDeletedFlag = HiraActivity::select("IS_DELETED")->where("ID",$element['ID'])->pluck('IS_DELETED')->first();
                    $element['IS_DELETED'] = $hiraIsDeletedFlag; 
                }
                $logData = array_merge($logData, $decodedValue);
            }
        }
        return $logData;
    }

    public function saveHiraDeclarationM($requestData)
    {
        $hiraId = 0;
        $hiraMapDeclarationData = $this->transformHiraMapDeclarationTableData($requestData, $hiraId);
        //insert new data
        $hinsert = HiraMapDeclarationForM::insert($hiraMapDeclarationData);
        
        if($hinsert){
            return 1;
        }else{
            return "";
        }
        
    }
    
}