<?php

namespace App\Services\HIRA;

use App\Http\Requests\HIRA\AddRequest;
use App\Http\Resources\HIRA\HiraResource;
use App\Models\MstSite;
use App\Models\Hira;
use App\Models\User;
use App\Models\UserMapRole;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Mail;

class HiraSendMailServices extends HiraResource
{
    public $vvsHiraModel;    
    public function __construct()
    {
        $this->vvsHiraModel = new Hira();
    }

    public function hiraSendMail($stage_id,$hira_id){
        if($stage_id == 2 || $stage_id == 3){
            $this->sendApprovalMail($hira_id);
        }
        if($stage_id == 4 || $stage_id == 6){
            $this->sendSendBackMail($hira_id);
        }
        if($stage_id == 5){
            $this->sendApprovedMail($hira_id);
        }        
        if($stage_id == 7){
            $this->sendRenewedMail($hira_id);
        }
        if($stage_id == 9){
            $this->sendRevisedMail($hira_id);
        }
    }

    protected function getHiraUserList($site_id,$role_id) {
        return User::select(
            'USERS.ID', 
            'USERS.FIRST_NAME', 
            'USERS.LAST_NAME', 
            'USERS.EMAIL',
            'MST_ROLE.ROLE_NAME'            
            )
            ->leftJoin('USERS_MAP_ROLE', 'USERS_MAP_ROLE.USER_ID', '=', 'USERS.ID')
            ->leftJoin('USERS_MAP_SITE', 'USERS_MAP_SITE.USER_ID', '=', 'USERS.ID')
            ->leftJoin('MST_ROLE', 'USERS_MAP_ROLE.ROLE_ID', '=', 'MST_ROLE.ROLE_ID')                                  
            ->where("USERS_MAP_SITE.SITE_ID",$site_id)
            ->where("USERS_MAP_ROLE.MODULE_NAME","HIRA")
            ->where("USERS_MAP_ROLE.ROLE_ID",$role_id)
            ->where("USERS.IS_ACTIVE",1)
            ->where("USERS.IS_DELETED",0)
            ->where("USERS_MAP_ROLE.IS_ACTIVE",1)
            ->where("USERS_MAP_ROLE.IS_DELETED",0)
            ->where("USERS_MAP_SITE.IS_ACTIVE",1)
            ->where("USERS_MAP_SITE.IS_DELETED",0)
            ->where("MST_ROLE.IS_ACTIVE",1)
            ->where("MST_ROLE.IS_DELETED",0)            
            ->get();    
    }

    protected function sendApprovalMail($hira_id){
        $hiradetails = Hira::where("ID", $hira_id)->first();
        $preparedBy = $hiradetails->preparedby;
        $mapRole = $preparedBy->hiraroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:blue;">HIRA PENDING FOR REVIEWER / APPROVAL</h1></p>';
        $mailBody.="<p>Hira as referred below has been submitted by 
        ".$this->customDecrypt($hiradetails->preparedby->FIRST_NAME).' '.$this->customDecrypt($hiradetails->preparedby->LAST_NAME)." [".$roleName."] 
        and now pending for your Review / approval.
        </p>";
        $mailBody.='<table border="1">';
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$hiradetails->HIRA_REFERENCE_NO.'</td></tr>';
        $mailBody.='<tr><td>Validity period:</td><td>'.showDate($hiradetails->HIRA_START_DATE, config("constants.DATE_FORMAT")).
        ' - '.showDate($hiradetails->HIRA_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';        
        $mailBody.='<tr><td>Title:</td><td>'.$hiradetails->TITLE.'</td></tr>';
        $mailBody.='<tr><td>Location:</td><td>'.$hiradetails->location->LOCATION_NAME.'</td></tr>';
        $mailBody.='</table>';
        $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';        
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";

        if($hiradetails->STAGE_ID == 3){
            $userlist = $this->getHiraUserList($hiradetails->SITE_ID,6);
        }else{
            $userlist = $this->getHiraUserList($hiradetails->SITE_ID,5);
        }        
        foreach($userlist as $value){
            $to_email = $this->customDecrypt($value->EMAIL);
            $data = array('body' => $mailBody,'to_email'=>$to_email);
            Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('HIRA PENDING FOR REVIEWER / APPROVAL');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
            });
        }
    }

    protected function sendSendBackMail($hira_id){
        $hiradetails = Hira::where("ID", $hira_id)->first();
        if($hiradetails->STAGE_ID == 6){
            $firstRejectedHistory = $hiradetails->sendbackedby->first();
            $actionTracker = $firstRejectedHistory->actionTracker;
        }else{
            $firstRejectedHistory = $hiradetails->sendbackedInitiatorby->first();
            $actionTracker = $firstRejectedHistory->actionTracker;
        }        
        $mapRole = $actionTracker->hiraroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:red;">HIRA SENT FOR CORRECTION</h1></p>';
        $mailBody.="<p>Hira as referred below has been rejected by ".$this->customDecrypt($actionTracker->FIRST_NAME) . " " . $this->customDecrypt($actionTracker->LAST_NAME)." [".$roleName."]
         and now pending for necessary correction and resubmission.</p>";
         $mailBody.='<table border="1">';
         $mailBody.='<tr><td>Ref. No.:</td><td>'.$hiradetails->HIRA_REFERENCE_NO.'</td></tr>';
         $mailBody.='<tr><td>Validity period:</td><td>'.showDate($hiradetails->HIRA_START_DATE, config("constants.DATE_FORMAT")).
         ' - '.showDate($hiradetails->HIRA_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';        
         $mailBody.='<tr><td>Title:</td><td>'.$hiradetails->TITLE.'</td></tr>';
         $mailBody.='<tr><td>Location:</td><td>'.$hiradetails->location->LOCATION_NAME.'</td></tr>'; 
         $mailBody.='</table>'; 
         $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        if($hiradetails->STAGE_ID == 6){
            $userlist = $this->getHiraUserList($hiradetails->SITE_ID,5);
            foreach($userlist as $value){
                $to_email = $this->customDecrypt($value->EMAIL);
                $data = array('body' => $mailBody,'to_email'=>$to_email);
                Mail::send([], $data, function($message) use($data) {
                    $message->to($data['to_email']);
                    $message->subject('HIRA SENT FOR CORRECTION');
                    $message->html($data['body']);
                    $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
                });
            }
        }else{
            $to_email = $this->customDecrypt($hiradetails->preparedby->EMAIL);
            $data = array('body' => $mailBody,'to_email'=>$to_email);
            Mail::send([], $data, function($message) use($data) {
                    $message->to($data['to_email']);
                    $message->subject('HIRA SENT FOR CORRECTION');
                    $message->html($data['body']);
                    $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
            });
        }
        
    }

    protected function sendApprovedMail($hira_id){
        $hiradetails = Hira::where("ID", $hira_id)->first();
        $approvedData = $hiradetails->approvedby->first();
        $approvedBy = $approvedData->actionTracker;
        $mapRole = $approvedBy->hiraroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $approvedByName = $this->customDecrypt($approvedData->actionTracker->FIRST_NAME).' '.$this->customDecrypt($approvedData->actionTracker->LAST_NAME);
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1 style="color:green;">HIRA APPROVED</h1></p>';
        $mailBody.="<p>Hira as referred below has been approved by ".$approvedByName." [".$roleName."].</p>";
        $mailBody.='<table border="1">';    
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$hiradetails->HIRA_REFERENCE_NO.'</td></tr>';
        $mailBody.='<tr><td>Validity period:</td><td>'.showDate($hiradetails->HIRA_START_DATE, config("constants.DATE_FORMAT")).
         ' - '.showDate($hiradetails->HIRA_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';        
        $mailBody.='<tr><td>Title:</td><td>'.$hiradetails->TITLE.'</td></tr>';
        $mailBody.='<tr><td>Location:</td><td>'.$hiradetails->location->LOCATION_NAME.'</td></tr>';
         $mailBody.='</table>';
         $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $to_email = $this->customDecrypt($hiradetails->preparedby->EMAIL);
        $data = array('body' => $mailBody,'to_email'=>$to_email);
        Mail::send([], $data, function($message) use($data) {
            $message->to($data['to_email']);
            $message->subject('HIRA APPROVED');
            $message->html($data['body']);
            $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
        });
    }

    

    protected function sendRenewedMail($hira_id){
        $hiradetails = Hira::where("ID", $hira_id)->first();
        $preparedBy = $hiradetails->preparedby;
        $mapRole = $preparedBy->hiraroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1  style="color:blue;">HIRA RENEWED</h1></p>';
        $mailBody.="<p>Hira as referred below has been Renewed by ".$this->customDecrypt($hiradetails->preparedby->FIRST_NAME).
        ' '.$this->customDecrypt($hiradetails->preparedby->LAST_NAME)." [".$roleName."] and now pending for your Review / approval.</p>";
        $mailBody.='<table border="1">';    
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$hiradetails->HIRA_REFERENCE_NO.'</td></tr>';
        $mailBody.='<tr><td>Validity period:</td><td>'.showDate($hiradetails->HIRA_START_DATE, config("constants.DATE_FORMAT")).
         ' - '.showDate($hiradetails->HIRA_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';        
        $mailBody.='<tr><td>Title:</td><td>'.$hiradetails->TITLE.'</td></tr>';
        $mailBody.='<tr><td>Location:</td><td>'.$hiradetails->location->LOCATION_NAME.'</td></tr>';
         $mailBody.='</table>';
         $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $userlist = $this->getHiraUserList($hiradetails->SITE_ID,5);
        foreach($userlist as $value){
            $to_email = $this->customDecrypt($value->EMAIL);
            $data = array('body' => $mailBody,'to_email'=>$to_email);
            Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('HIRA RENEWED');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
            });
        }
    }

    protected function sendRevisedMail($hira_id){
        $hiradetails = Hira::where("ID", $hira_id)->first();
        $preparedBy = $hiradetails->preparedby;
        $mapRole = $preparedBy->hiraroles;
        $roleName = $mapRole[0]->userroles->ROLE_NAME;
        $vvsImagePath = asset('images/vois_logo.png');
        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
        $mailBody="<html><body>";
        $mailBody.='<p><h1  style="color:blue;">HIRA REVISED</h1></p>';
        $mailBody.="<p>Hira as referred below has been Revised by ".$this->customDecrypt($hiradetails->preparedby->FIRST_NAME).
        ' '.$this->customDecrypt($hiradetails->preparedby->LAST_NAME)." [".$roleName."] and now pending for your Review / approval.</p>";
        $mailBody.='<table border="1">';    
        $mailBody.='<tr><td>Ref. No.:</td><td>'.$hiradetails->HIRA_REFERENCE_NO.'</td></tr>';
        $mailBody.='<tr><td>Validity period:</td><td>'.showDate($hiradetails->HIRA_START_DATE, config("constants.DATE_FORMAT")).
         ' - '.showDate($hiradetails->HIRA_END_DATE, config("constants.DATE_FORMAT")).'</td></tr>';        
        $mailBody.='<tr><td>Title:</td><td>'.$hiradetails->TITLE.'</td></tr>';
        $mailBody.='<tr><td>Location:</td><td>'.$hiradetails->location->LOCATION_NAME.'</td></tr>';
         $mailBody.='</table>';
         $mailBody.='<img src='.$vvsImagePath.' alt="Image" style="width: 100px;">';
        $mailBody.="<p>Recipient should carry out own virus checks before opening the e-mail or attachment. 
        E-mail transmission cannot be guaranteed to be secure or error-free as information could be intercepted, 
        corrupted, lost, destroyed, arrive late or incomplete, or contain viruses. The sender therefore does not 
        accept liability for any errors or omissions in the contents of this message, which arise as a result of 
        e-mail transmission.</p>";
        $mailBody.="</body></html>";
        $userlist = $this->getHiraUserList($hiradetails->SITE_ID,5);
        foreach($userlist as $value){
            $to_email = $this->customDecrypt($value->EMAIL);
            $data = array('body' => $mailBody,'to_email'=>$to_email);
            Mail::send([], $data, function($message) use($data) {
                $message->to($data['to_email']);
                $message->subject('HIRA REVISED');
                $message->html($data['body']);
                $message->from(config("constants.MAIL_FROM_EMAIL"), config("constants.MAIL_FROM_NAME"));
            });
        }
    }


}
