<?php

namespace App\Services\HIRA;

use App\Http\Resources\HIRA\HiraMstDeclarationResource;
use App\Models\HiraMstDeclaration;
use App\Models\HiraMapDeclaration;

class HiraMstDeclarationServices extends HiraMstDeclarationResource
{
    public $vvsHiraMstDeclModel;
    public function __construct(){
        $this->vvsHiraMstDeclModel = new HiraMstDeclaration();
    }

    public function getHiraInitialDeclListOne(){
        return HiraMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%HIRA_ADD_ONE%')->get();
    }

    public function getHiraInitialDeclListTwo(){
        return HiraMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%HIRA_ADD_TWO%')->get();
    }

    public function getHiraInitialDeclListPopOne(){
        return HiraMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%HIRA_ADD_POP_ONE%')->get();
    }

    public function getHiraMoveFrwdDeclList(){
        return HiraMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%MOVE_FORWARD%')->get();
    }

    public function getHiraApproveDeclList(){
        return HiraMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%APPROVE%')->get();
    }

    public function getHiraRejectDeclList(){
        return HiraMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', '%REJECT%')->get();
    }    

    public function getHiraRenewDeclList(){
        return HiraMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', 'RENEWED%')->get();
    }

    public function getHiraACMlList(){
        return HiraMstDeclaration::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where('DECLARATION_SECTION', 'LIKE', 'HIRA_ACM_ONE%')->get();
    }
    
    public function getMapDeclaration($hira_id,$afterSubmit){
        if( $afterSubmit == 1 ){

            return HiraMstDeclaration::select(
                        'HIRA_MST_DECLARATION.DECLARATION_ID',
                        'HIRA_MST_DECLARATION.DECLARATION_NAME', 
                        'HIRA_MST_DECLARATION.DECLARATION_GROUP', 
                        'HIRA_MST_DECLARATION.DECLARATION_SECTION',
                        'HIRA_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                        'HIRA_MAP_DECLARATION.MAP_DECLARATION_ID',
                        'HIRA_MAP_DECLARATION.IS_ACTIVE',
                        'HIRA_MAP_DECLARATION.IS_DELETED'
                    )
                    ->leftJoin('HIRA_MAP_DECLARATION', function ($join) use ($hira_id) {
                        $join->on('HIRA_MAP_DECLARATION.DECLARATION_ID', '=', 'HIRA_MST_DECLARATION.DECLARATION_ID')
                            ->where('HIRA_MAP_DECLARATION.HIRA_ID', $hira_id)
                            ->where('HIRA_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('HIRA_MAP_DECLARATION.IS_DELETED', 0);
                    })
                    ->where('HIRA_MST_DECLARATION.IS_ACTIVE', 1)
                    ->where('HIRA_MST_DECLARATION.IS_DELETED', 0)
                    ->where('HIRA_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', 'HIRA_ADD_ONE%')
                    ->get();
        }else{
            return HiraMapDeclaration::select('HIRA_MST_DECLARATION.DECLARATION_ID',
                                            'HIRA_MST_DECLARATION.DECLARATION_NAME',
                                            'HIRA_MST_DECLARATION.DECLARATION_GROUP',
                                            'HIRA_MST_DECLARATION.DECLARATION_SECTION',
                                            'HIRA_MST_DECLARATION.IS_MANDATORY_DURING_ADD',
                                            'HIRA_MAP_DECLARATION.MAP_DECLARATION_ID',
                                            'HIRA_MAP_DECLARATION.IS_ACTIVE',
                                            'HIRA_MAP_DECLARATION.IS_DELETED'
                                            )
                            ->leftJoin('HIRA_MST_DECLARATION', 'HIRA_MAP_DECLARATION.DECLARATION_ID', '=', 'HIRA_MST_DECLARATION.DECLARATION_ID')
                            //->where('HIRA_MST_DECLARATION.IS_ACTIVE', 1)
                            ->where('HIRA_MAP_DECLARATION.IS_ACTIVE', 1)
                            ->where('HIRA_MAP_DECLARATION.IS_DELETED', 0)
                            //->where('HIRA_MST_DECLARATION.IS_DELETED', 0)
                            ->where("HIRA_MAP_DECLARATION.HIRA_ID",$hira_id)
                            ->where('HIRA_MST_DECLARATION.DECLARATION_SECTION', 'LIKE', '%HIRA_ADD_ONE%')
                            ->get();
                  
        }
    }
    
}
