<?php

namespace App\Services\HIRA;

use App\Http\Resources\HIRA\HiraActivityResource;
use App\Models\HiraActivity;

class HiraActivityServices extends HiraActivityResource
{
    public $vvsHiraActivityModel;
    public function __construct(){
        $this->vvsHiraActivityModel = new HiraActivity();
    }
    
    public function getHiraActivityList($requestData){
        return HiraActivity::where("HIRA_ID", $requestData->HIRA_ID)->orderBy("ORD_BY_SEVERITY")->get();
    }

    public function getHiraActivityFirstList($requestData){
        return HiraActivity::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)->where("HIRA_ID", $requestData->HIRA_ID)->first();
    }

    public function getHiraActionControl($hiraDetails,$userId){
        return HiraActivity::where('IS_DELETED', 0)->where("IS_ACTIVE", 1)
                ->where("HIRA_ID", $hiraDetails->ID)
                ->where("ACTION_OWNER_ID", $userId)->count();
    }
    
}
