<?php

namespace App\Services\HIRA;

use App\Http\Resources\HIRA\HiraActionOwnerResource;
use App\Models\UserMapSite;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class HiraActionOwnerServices extends HiraActionOwnerResource
{
    public $vvsHiraActionOwnerModel;
    public function __construct(){
        $this->vvsHiraActionOwnerModel = new UserMapSite();
    }
    
    public function getActionOwnerList($rawRequest){
        return UserMapSite::select('USERS_MAP_SITE.USER_ID',
                                    'USERS_MAP_SITE.SITE_ID',
                                    'USERS_MAP_ROLE.ROLE_ID',
                                    'USERS_MAP_SITE.MAP_SITE_ID',
                                )
                            ->leftJoin('USERS_MAP_ROLE', 'USERS_MAP_ROLE.USER_ID', '=', 'USERS_MAP_SITE.USER_ID')
                            ->leftJoin('USERS', 'USERS.ID', '=', 'USERS_MAP_SITE.USER_ID')                           
                            ->where('USERS_MAP_SITE.IS_ACTIVE', 1)
                            ->where('USERS_MAP_SITE.IS_DELETED', 0)
                            ->where('USERS_MAP_ROLE.IS_ACTIVE', 1)
                            ->where('USERS_MAP_ROLE.IS_DELETED', 0)
                            ->where('USERS.IS_ACTIVE', 1)
                            ->where('USERS.IS_DELETED', 0)                            
                            ->where("USERS_MAP_SITE.SITE_ID",$rawRequest->SITE_ID)
                            ->where('USERS_MAP_ROLE.MODULE_NAME', 'HIRA')
                            ->whereNotIn('USERS_MAP_ROLE.ROLE_ID', [4,5,6])    
                            ->get();
        
    }
    
}
