<?php

namespace App\Services\HIRA;

use App\Http\Resources\HIRA\HiraActionHistoryResource;
use App\Models\HiraActionHistory;
use Illuminate\Support\Facades\App;
use Illuminate\Http\Request;

class HiraActionHistoryServices extends HiraActionHistoryResource
{
    public $vvsHiraActivityModel;
    public function __construct(){
        $this->vvsHiraActivityModel = new HiraActionHistory();
    }    
    

    public function getAllActivityLog($hira_id){
        return HiraActionHistory::select(
            'HIRA_ACTION_HISTORY.HIRA_ID', 
            'HIRA_ACTION_HISTORY.ACTION_TAKER_ID', 
            'HIRA_ACTION_HISTORY.STAGE_ID', 
            'HIRA_ACTION_HISTORY.COMMENTS',
            'HIRA_ACTION_HISTORY.CREATED_BY', 
            'HIRA_ACTION_HISTORY.CREATED_ON'           
        )
        ->leftJoin('HIRA', function($join) use ($hira_id) {
            $join->on('HIRA.ID', '=', 'HIRA_ACTION_HISTORY.HIRA_ID')                
                ->where('HIRA.IS_ACTIVE', 1)
                ->where('HIRA.IS_DELETED', 0)
                ->where(function($query3) use ($hira_id) {                   
                    $query3->where('HIRA.ID', $hira_id);
                    $query3->orWhere('HIRA.TOP_PARENT_HIRA_ID', $hira_id);                    
                });
        })
        ->where('HIRA_ACTION_HISTORY.IS_ACTIVE', 1)
        ->where('HIRA_ACTION_HISTORY.IS_DELETED', 0)
        ->whereNotNull('HIRA.ID')
        ->get();

    }
    
}
