<?php

namespace App\Services\Dashboard;

use App\Http\Resources\Dashboard\DashboardTrainingResource;
use App\Models\MstSite;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\PtwMstType;
use App\Models\PtwMstStage;
use App\Models\MstLocation;
use App\Models\PtwMstContractor;
use App\Models\PtwMstSoapPolicies;
use App\Models\Training;
use App\Models\PtwMstWorker;
use App\Models\PtwAuditLog;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class DashboardTrainingServices extends DashboardTrainingResource
{
    public $vvsTrainingModel;
    public $page;
    public $pageSize;
    public $vvsTrModel;
    
    public function __construct()
    {
        $this->vvsTrainingModel = new Training();
        $this->vvsTrModel = new Training();
    }
     /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'START_DATE' => 'START_DATE',
            'END_DATE' => 'END_DATE'
        ];
    }

    public function getTrainingCountByLocation($requestData)
    {
        $query = Training::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)
                    ->whereNotIn("STAGE_ID", [1])->orderBy('LOCATION_ID');
        $relationshipsToLoad = ['location'];
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query->where('SITE_ID', $requestData->SITE_ID);
        }
        if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
            $startDate = $requestData->START_DATE;
            $endDate = $requestData->END_DATE;
    
            // Add special handling for date range queries
            $query->where(function ($query) use ($startDate, $endDate) {
                $query->whereBetween('TR_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TR_END_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TR_SCHEDULED_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TR_SCHEDULED_END_DATE', [$startDate, $endDate]);
            });
        }
        // $query->where("IS_DELETED", 0);
        // $query->where("IS_ACTIVE", 1);
        // $query->where('SITE_ID', $requestData->SITE_ID);
        // // Eager load the specified relationships
        $query->with($relationshipsToLoad);
        return $query->get();
        // $query = Training::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)->where('SITE_ID', $requestData->SITE_ID)
        //             ->whereNotNull('STAGE_ID');
        // return $query->count();
    }


    public function getDashboardParticipantMarksCount($requestData)
    {
        $query2 = DB::table('TR_MAP_PARTICIPANTS')
                ->select(
                    'HIRA_MST_LOCATION.LOCATION_NAME',
                    DB::raw('case when cast("TR_MAP_PARTICIPANTS"."SCORE" as int) > 90 then 1 else 0 end as ABOVE_90'),
                    DB::raw('case when cast("TR_MAP_PARTICIPANTS"."SCORE" as int) >= 80 and cast("TR_MAP_PARTICIPANTS"."SCORE" as int) <= 90 then 1 else 0 end as ABOVE_80_90'),
                    DB::raw('case when cast("TR_MAP_PARTICIPANTS"."SCORE" as int) < 80 then 1 else 0 end as BELOW_80'))
                ->leftJoin('TRAINING', function ($join){
                    $join->on('TRAINING.ID', '=', 'TR_MAP_PARTICIPANTS.TR_ID')
                        ->where('TRAINING.IS_ACTIVE', 1)
                        ->where('TRAINING.IS_DELETED', 0);
                })
                ->leftJoin('HIRA_MST_LOCATION', function ($join){
                    $join->on('TRAINING.LOCATION_ID', '=', 'HIRA_MST_LOCATION.LOCATION_ID')
                        ->where('HIRA_MST_LOCATION.IS_ACTIVE', 1)
                        ->where('HIRA_MST_LOCATION.IS_DELETED', 0);
                })
                ->where('TR_MAP_PARTICIPANTS.IS_ACTIVE', 1)
                ->where('TR_MAP_PARTICIPANTS.IS_DELETED', 0)
                ->whereNotNull('TRAINING.STAGE_ID')
                ->whereNotIn("TRAINING.STAGE_ID", [1]);
         // Check if SITE_ID is set and not equal to 0
         if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('TRAINING.SITE_ID', $requestData->SITE_ID);
        }
        if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
            $startDate = $requestData->START_DATE;
            $endDate = $requestData->END_DATE;
    
            // Add special handling for date range queries
            $query2->where(function ($query2) use ($startDate, $endDate) {
                $query2->whereBetween('TRAINING.TR_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TRAINING.TR_END_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TRAINING.TR_SCHEDULED_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TRAINING.TR_SCHEDULED_END_DATE', [$startDate, $endDate]);
            });
        }
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());
        $query = DB::table(DB::raw('('.$sql2Query.') AS "PTS"'))->select(
            'PTS.LOCATION_NAME', 
            DB::raw('sum("PTS"."above_90") as ABOVE_90_COUNT'),
            DB::raw('sum("PTS"."above_80_90") as BETWEEN_80_90_COUNT'),
            DB::raw('sum("PTS"."below_80") as BELOW_80_COUNT')  
        )
        ->groupBy('PTS.LOCATION_NAME');
        return $query->get();
        
    }

    public function getDashboardParticipantCount($requestData)
    {
        $query2 = DB::table('TR_MAP_PARTICIPANTS')
                ->select(
                    'HIRA_MST_LOCATION.LOCATION_NAME',
                    DB::raw('count("TR_MAP_PARTICIPANTS"."MAP_PARTICIPANT_ID") AS PARTICIPANT_COUNT'),
                )
                ->leftJoin('TRAINING', function ($join){
                    $join->on('TRAINING.ID', '=', 'TR_MAP_PARTICIPANTS.TR_ID')
                        ->where('TRAINING.IS_ACTIVE', 1)
                        ->where('TRAINING.IS_DELETED', 0);
                })
                ->leftJoin('HIRA_MST_LOCATION', function ($join){
                    $join->on('TRAINING.LOCATION_ID', '=', 'HIRA_MST_LOCATION.LOCATION_ID')
                        ->where('HIRA_MST_LOCATION.IS_ACTIVE', 1)
                        ->where('HIRA_MST_LOCATION.IS_DELETED', 0);
                })
                ->where('TR_MAP_PARTICIPANTS.IS_ACTIVE', 1)
                ->where('TR_MAP_PARTICIPANTS.IS_DELETED', 0)
                ->whereNotNull('TRAINING.STAGE_ID')
                ->whereNotIn("TRAINING.STAGE_ID", [1]);
         // Check if SITE_ID is set and not equal to 0
         if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('TRAINING.SITE_ID', $requestData->SITE_ID);
        }
        if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
            $startDate = $requestData->START_DATE;
            $endDate = $requestData->END_DATE;
    
            // Add special handling for date range queries
            $query2->where(function ($query2) use ($startDate, $endDate) {
                $query2->whereBetween('TRAINING.TR_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TRAINING.TR_END_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TRAINING.TR_SCHEDULED_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TRAINING.TR_SCHEDULED_END_DATE', [$startDate, $endDate]);
            });
        }
        $query2->groupBy('HIRA_MST_LOCATION.LOCATION_NAME');
        return $query2->get();
    }

    public function getTrainingStatusCountForCurrentMonth($requestData)
    {
        $year  = date("Y");
        $month  = date("m");
        $startDate = date('Y-m-01', strtotime($year.'-'.$month.'-01'));
        $endDate = date('Y-m-t', strtotime($year.'-'.$month.'-01'));
        if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
            $startDate = date('Y-m-d', strtotime($requestData->START_DATE));
            $endDate = date('Y-m-d', strtotime($requestData->END_DATE));
        }
        $query = Training::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)
                    ->whereNotIn("STAGE_ID", [1])->orderBy('LOCATION_ID');
        $relationshipsToLoad = ['location'];
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query->where('SITE_ID', $requestData->SITE_ID);
        }
        
        $query->where(function($query3) use ($startDate, $endDate) {
            $query3->where(function($query2) use ($startDate, $endDate) {
                $query2->whereBetween('TR_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TR_END_DATE', [$startDate, $endDate]);
            })
            ->orWhere(function($query2) use ($startDate, $endDate) {
                $query2->whereBetween('TR_SCHEDULED_START_DATE', [$startDate, $endDate])
                      ->orWhereBetween('TR_SCHEDULED_END_DATE', [$startDate, $endDate]);
            });
        });

        // $query->where(function($query3) use ($startDate,$enddate) {
        //     $query3->whereBetween('TR_START_DATE', [$startDate,$enddate]);
        //     $query3->orWhereBetween('TR_END_DATE', [$startDate,$enddate]);
        // });
        $query->with($relationshipsToLoad);
        return $query->get();
    }


    
}