<?php

namespace App\Services\Dashboard;

use App\Http\Resources\Dashboard\DashboardPtwResource;
use App\Models\MstSite;
use App\Models\Ptw;
use App\Models\PtwActionHistory;
use App\Models\PtwMapCaptcha;
use App\Models\PtwMapChecklist;
use App\Models\PtwMapDeclaration;
use App\Models\PtwMapFiles;
use App\Models\PtwMapHira;
use App\Models\PtwMapPrecautions;
use App\Models\PtwMapSopPolicies;
use App\Models\PtwMapSopPolicy;
use App\Models\PtwMapWorkers;
use App\Models\PtwMstChecklist;
use App\Models\PtwMstChecklistOption;
use App\Models\PtwMstDeclaration;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\PtwMstType;
use App\Models\PtwMstStage;
use App\Models\MstLocation;
use App\Models\PtwMstContractor;
use App\Models\PtwMstSoapPolicies;
use App\Models\Hira;
use App\Models\PtwMstWorker;
use App\Models\PtwAuditLog;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class DashboardPtwServices extends DashboardPtwResource
{
    public $vvsPtwModel;
    public $page;
    public $pageSize;
    public function __construct()
    {
        $this->vvsPtwModel = new Ptw();
    }
    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'PERMIT_START_TIME'=>'PERMIT_START_TIME',
            'PERMIT_END_TIME'=>'PERMIT_END_TIME'
        ];
    }

    public function getDashboardPtwTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = Ptw::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)->whereNotIn("PTW.STAGE_ID", [1])
                ->whereNotNull('TYPE_ID')->whereNotNull('STAGE_ID');
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query->where('SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query->whereDate($columnMapping[$key], '>=', $value);
                } elseif ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query->whereDate($columnMapping[$key], '<=', $value);
                } elseif ($columnMapping[$key] != "SITE_ID") {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        return $query->count();
    }

    public function getDashboardPtwByTypeCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('PTW')->select('PTW.TYPE_ID',DB::raw('COUNT("PTW"."TYPE_ID") AS PTW_COUNT'))
                ->where('PTW.IS_ACTIVE', 1)
                ->where('PTW.IS_DELETED', 0)
                ->whereNotNull('PTW.TYPE_ID')
                ->whereNotIn("PTW.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('PTW.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query2->whereDate('PTW.PERMIT_START_TIME', '>=', $value);
                } elseif ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query2->whereDate('PTW.PERMIT_END_TIME', '<=', $value);
                }
            }
        }
        $query2->groupBy('PTW.TYPE_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('PTW_MST_TYPE')->select(
            'PTW_MST_TYPE.TYPE_ID',
            'PTW_MST_TYPE.TYPE_NAME',
            'PTS.ptw_count AS PTW_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function ($join) {
            $join->on('PTS.TYPE_ID', '=', 'PTW_MST_TYPE.TYPE_ID');
        })
        ->where('PTW_MST_TYPE.IS_ACTIVE', 1)
        ->where('PTW_MST_TYPE.IS_DELETED', 0)
        ->whereNotNull('PTW_MST_TYPE.TYPE_ID')
        ->orderBy('PTW_MST_TYPE.TYPE_ID');
        return $query->get();
    }

    public function getPtwTypes($requestData)
    {
        return PtwMstType::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)->get();
    }

    public function getPtwStages()
    {
        return PtwMstStage::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)->orderBy("STAGE_ID", "asc")->get();
    }

    public function getDashboardPtwByStageCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('PTW')->select('PTW.STAGE_ID', DB::raw('COUNT("PTW"."STAGE_ID") AS PTW_COUNT'))
                ->where('PTW.IS_ACTIVE', 1)
                ->where('PTW.IS_DELETED', 0)
                ->whereNotNull('PTW.STAGE_ID')
                ->whereNotIn("PTW.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('PTW.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query2->whereDate('PTW.PERMIT_START_TIME', '>=', $value);
                } elseif ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query2->whereDate('PTW.PERMIT_END_TIME', '<=', $value);
                }
            }
        }
        $query2->groupBy('PTW.STAGE_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('PTW_MST_STAGE')->select(
            'PTW_MST_STAGE.STAGE_ID',
            'PTW_MST_STAGE.STAGE_NAME',
            'PTS.ptw_count AS PTW_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function($join) {
            $join->on('PTS.STAGE_ID', '=', 'PTW_MST_STAGE.STAGE_ID');
        })
        ->where('PTW_MST_STAGE.IS_ACTIVE', 1)
        ->where('PTW_MST_STAGE.IS_DELETED', 0)
        ->whereNotNull('PTW_MST_STAGE.STAGE_ID')
        ->orderBy('PTW_MST_STAGE.STAGE_ID');
        return $query->get();
        
    }

    public function getDashboardPtwByLocationCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('PTW')->select('PTW.LOCATION_ID',DB::raw('COUNT("PTW"."LOCATION_ID") AS PTW_COUNT'))
                ->where('PTW.IS_ACTIVE', 1)
                ->where('PTW.IS_DELETED', 0)
                ->whereNotNull('PTW.LOCATION_ID')
                ->whereNotIn("PTW.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('PTW.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query2->whereDate('PTW.PERMIT_START_TIME', '>=', $value);
                } elseif ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query2->whereDate('PTW.PERMIT_END_TIME', '<=', $value);
                }
            }
        }
        $query2->groupBy('PTW.LOCATION_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(), $query2->getBindings());

        $query = DB::table('MST_LOCATION')->select(
            'MST_LOCATION.LOCATION_ID',
            'MST_LOCATION.LOCATION_NAME',
            'MST_LOCATION.BUILDING',
            'MST_LOCATION.FLOOR',
            'MST_LOCATION.WING',
            'MST_LOCATION.DEPARTMENT',
            'MST_LOCATION.CHECKLIST',
            'MST_LOCATION.QR_CODE',
            'PTS.ptw_count AS PTW_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function($join) {
            $join->on('PTS.LOCATION_ID', '=', 'MST_LOCATION.LOCATION_ID');
        })
        ->where('MST_LOCATION.IS_ACTIVE', 1)
        ->where('MST_LOCATION.IS_DELETED', 0)
        ->whereNotNull('MST_LOCATION.LOCATION_ID')
        ->orderBy('MST_LOCATION.LOCATION_ID');
        return $query->get();
    }

    public function getPtwLocations($requestData)
    {
        return MstLocation::where("SITE_ID", $requestData->SITE_ID)->where("IS_ACTIVE", 1)
                ->where("IS_DELETED", 0)->orderBy("LOCATION_ID", "asc")->get();
    }

    
}