<?php

namespace App\Services\Dashboard;

use App\Http\Resources\Dashboard\DashboardObservationResource;
use App\Models\MstSite;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\MstLocation;
use App\Models\Observation;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class DashboardObservationServices extends DashboardObservationResource
{
    public $vvsObservationModel;
    public $page;
    public $pageSize;
    public $vvsTrModel;
    
    public function __construct()
    {
        $this->vvsObservationModel = new Observation();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'OBS_START_DATE'=>'OBS_START_DATE',
            'OBS_END_DATE'=>'OBS_END_DATE'
        ];
    }

    public function getDashboardObsByStageCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('OBSERVATION')->select(
            'OBSERVATION.STAGE_ID',
            DB::raw('COUNT("OBSERVATION"."STAGE_ID") AS OBSERVATION_COUNT'))
                ->where('OBSERVATION.IS_ACTIVE', 1)
                ->where('OBSERVATION.IS_DELETED', 0)
                ->whereNotNull('OBSERVATION.STAGE_ID')
                ->whereNotIn("OBSERVATION.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('OBSERVATION.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "OBS_START_DATE") {
                    $query2->whereDate('OBSERVATION.OBS_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == "OBS_END_DATE") {
                    $query2->whereDate('OBSERVATION.OBS_END_DATE', '<=', $value);
                }
            }
        }
        $query2->groupBy('OBSERVATION.STAGE_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('OBS_MST_STAGE')->select(
            'OBS_MST_STAGE.STAGE_ID',
            'OBS_MST_STAGE.STAGE_NAME',
            'PTS.observation_count AS OBSERVATION_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function($join) {
            $join->on('PTS.STAGE_ID', '=', 'OBS_MST_STAGE.STAGE_ID');
        })
        ->where('OBS_MST_STAGE.IS_ACTIVE', 1)
        ->where('OBS_MST_STAGE.IS_DELETED', 0)
        ->whereNotNull('OBS_MST_STAGE.STAGE_ID')
        ->whereNotIn('OBS_MST_STAGE.STAGE_ID',[3])
        ->orderBy('OBS_MST_STAGE.STAGE_ID');
        return $query->get();
        
    }

    public function getDashboardObsByTypeCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('OBSERVATION')->select(
            'OBSERVATION.OBS_TYPE_ID',
            DB::raw('COUNT("OBSERVATION"."OBS_TYPE_ID") AS OBSERVATION_COUNT'))
            ->where('OBSERVATION.IS_ACTIVE', 1)
            ->where('OBSERVATION.IS_DELETED', 0)
            ->whereNotNull('OBSERVATION.OBS_TYPE_ID')
            ->whereNotIn("OBSERVATION.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('OBSERVATION.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "OBS_START_DATE") {
                    $query2->whereDate('OBSERVATION.OBS_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == "OBS_END_DATE") {
                    $query2->whereDate('OBSERVATION.OBS_END_DATE', '<=', $value);
                }
            }
        }
        $query2->groupBy('OBSERVATION.OBS_TYPE_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('OBS_MST_TYPE')->select(
            'OBS_MST_TYPE.OBS_TYPE_ID',
            'OBS_MST_TYPE.OBS_TYPE_NAME',
            'PTS.observation_count AS OBSERVATION_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function ($join) {
            $join->on('PTS.OBS_TYPE_ID', '=', 'OBS_MST_TYPE.OBS_TYPE_ID');
        })
        ->where('OBS_MST_TYPE.IS_ACTIVE', 1)
        ->where('OBS_MST_TYPE.IS_DELETED', 0)
        ->whereNotNull('OBS_MST_TYPE.OBS_TYPE_ID')
        ->orderBy('OBS_MST_TYPE.OBS_TYPE_ID');
        return $query->get();
        
    }

    public function getDashboardObsByRiskCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('OBSERVATION')
                ->select(
                    'OBS_MST_SEVERITY.SEVERITY_NAME',
                    'OBS_MST_LIKELIHOOD.LIKELIHOOD_NAME',
                    DB::raw('CONCAT("OBS_MST_SEVERITY"."SEVERITY_NAME","OBS_MST_LIKELIHOOD"."LIKELIHOOD_NAME")
                     AS RISK_FACTOR'),
                    DB::raw('COUNT("OBSERVATION"."ID") AS OBSERVATION_COUNT'))
                ->leftJoin('OBS_MST_SEVERITY', 'OBSERVATION.SEVERITY_ID', '=', 'OBS_MST_SEVERITY.SEVERITY_ID')
                ->leftJoin('OBS_MST_LIKELIHOOD', 'OBSERVATION.LIKELIHOOD_ID', '=', 'OBS_MST_LIKELIHOOD.LIKELIHOOD_ID')
                ->where('OBSERVATION.IS_ACTIVE', 1)
                ->where('OBSERVATION.IS_DELETED', 0)
                ->whereNotNull('OBSERVATION.SEVERITY_ID')
                ->whereNotNull('OBSERVATION.LIKELIHOOD_ID')
                ->whereNotIn("OBSERVATION.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('OBSERVATION.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "OBS_START_DATE") {
                    $query2->whereDate('OBSERVATION.OBS_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == "OBS_END_DATE") {
                    $query2->whereDate('OBSERVATION.OBS_END_DATE', '<=', $value);
                }
            }
        }
        $query2->groupBy('OBS_MST_SEVERITY.SEVERITY_NAME', 'OBS_MST_LIKELIHOOD.LIKELIHOOD_NAME');
        return $query2->get();
    }

    public function getObsTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = Observation::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)->whereNotIn("OBSERVATION.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query->where('SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "OBS_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=', $value);
                } elseif ($columnMapping[$key] == "OBS_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=', $value);
                } elseif ($columnMapping[$key] != "SITE_ID") {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        return $query->count();
    }
}