<?php

namespace App\Services\Dashboard;

use App\Http\Resources\Dashboard\DashboardInspectionResource;
use App\Models\MstSite;
use App\Models\Inspection;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\MstLocation;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class DashboardInspectionServices extends DashboardInspectionResource
{
    public $vvsInspModel;
    public $page;
    public $pageSize;
    public function __construct()
    {
        $this->vvsInspModel = new Inspection();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'INSP_START_TIME'=>'INSP_START_TIME',
            'INSP_END_TIME'=>'INSP_END_TIME'
        ];
    }

    public function getDashboardInspectionTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = Inspection::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)->whereNotIn("STAGE_ID", [1])
                ->whereNotNull('TYPE_ID')->whereNotNull('STAGE_ID');

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query->where('SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "INSP_START_TIME") {
                    $query->whereDate('INSP_DATE', '>=',$value);
                } elseif ($columnMapping[$key] == "INSP_END_TIME") {
                    $query->whereDate('INSP_DATE', '<=',$value);
                } elseif ($columnMapping[$key] != "SITE_ID") {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        return $query->count();
    }

    public function getDashboardInspectionByTypeCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query2 = DB::table('INSP')->select('INSP.TYPE_ID', DB::raw('COUNT("INSP"."TYPE_ID") AS INSPECTION_COUNT'))
                ->where('INSP.IS_ACTIVE', 1)
                ->where('INSP.IS_DELETED', 0)
                ->whereNotNull('INSP.TYPE_ID')
                ->whereNotIn("INSP.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('INSP.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "INSP_START_TIME") {
                    $query2->whereDate('INSP.INSP_DATE', '>=',$value);
                } elseif ($columnMapping[$key] == "INSP_END_TIME") {
                    $query2->whereDate('INSP.INSP_DATE', '<=',$value);
                }
            }
        }
        $query2->groupBy('INSP.TYPE_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('INSP_MST_TYPE')->select(
            'INSP_MST_TYPE.INSP_TYPE_ID',
            'INSP_MST_TYPE.INSP_TYPE_NAME',
            'PTS.inspection_count AS INSPECTION_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function ($join) {
            $join->on('PTS.TYPE_ID', '=', 'INSP_MST_TYPE.INSP_TYPE_ID');
        })
        ->where('INSP_MST_TYPE.IS_ACTIVE', 1)
        ->where('INSP_MST_TYPE.IS_DELETED', 0)
        ->whereNotNull('INSP_MST_TYPE.INSP_TYPE_ID')
        ->orderBy('INSP_MST_TYPE.INSP_TYPE_ID');
        return $query->get();
    }

    

    public function getDashboardInspectionByLocationCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('INSP')->select(
            'INSP.LOCATION_ID',
            DB::raw('COUNT("INSP"."LOCATION_ID") AS INSPECTION_COUNT'))
            ->where('INSP.IS_ACTIVE', 1)
            ->where('INSP.IS_DELETED', 0)
            ->whereNotNull('INSP.LOCATION_ID')
            ->whereNotIn("INSP.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('INSP.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "INSP_START_TIME") {
                    $query2->whereDate('INSP.INSP_DATE', '>=',$value);
                } elseif ($columnMapping[$key] == "INSP_END_TIME") {
                    $query2->whereDate('INSP.INSP_DATE', '<=',$value);
                }
            }
        }
        $query2->groupBy('INSP.LOCATION_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('HIRA_MST_LOCATION')->select(
            'HIRA_MST_LOCATION.LOCATION_ID',
            'HIRA_MST_LOCATION.LOCATION_NAME',
            'HIRA_MST_LOCATION.BUILDING',
            'HIRA_MST_LOCATION.FLOOR',
            'HIRA_MST_LOCATION.WING',
            'HIRA_MST_LOCATION.DEPARTMENT',
            'HIRA_MST_LOCATION.CHECKLIST',
            'HIRA_MST_LOCATION.QR_CODE',
            'PTS.inspection_count AS INSPECTION_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function ($join) {
            $join->on('PTS.LOCATION_ID', '=', 'HIRA_MST_LOCATION.LOCATION_ID');
        })
        ->where('HIRA_MST_LOCATION.IS_ACTIVE', 1)
        ->where('HIRA_MST_LOCATION.IS_DELETED', 0)
        ->whereNotNull('HIRA_MST_LOCATION.LOCATION_ID')
        ->orderBy('HIRA_MST_LOCATION.LOCATION_ID');
        return $query->get();
    }

    public function getDashboardInspChecklistOptionCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('INSP_MAP_CHECKLIST')
                ->select(
                    'INSP_MST_CHECKLIST_OPTION.CHECKLIST_OPTION_NAME',
                    DB::raw('COUNT("INSP_MST_CHECKLIST_OPTION"."CHECKLIST_OPTION_NAME") AS OPTION_COUNT'))
                ->leftJoin('INSP_MST_CHECKLIST_OPTION', function ($join) {
                    $join->on('INSP_MST_CHECKLIST_OPTION.CHECKLIST_OPTION_ID', '=', 'INSP_MAP_CHECKLIST.OPTION_ID')
                        ->where('INSP_MST_CHECKLIST_OPTION.IS_ACTIVE', 1)
                        ->where('INSP_MST_CHECKLIST_OPTION.IS_DELETED', 0);
                })
                ->leftJoin('INSP', function ($join) {
                    $join->on('INSP.ID', '=', 'INSP_MAP_CHECKLIST.INSPECTION_ID')
                        ->where('INSP.IS_ACTIVE', 1)
                        ->where('INSP.IS_DELETED', 0);
                })
                ->where('INSP_MST_CHECKLIST_OPTION.IS_ACTIVE', 1)
                ->where('INSP_MST_CHECKLIST_OPTION.IS_DELETED', 0)
                ->whereNotNull('INSP.ID')
                ->whereNotIn("INSP.STAGE_ID", [1]);
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('INSP.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "INSP_START_TIME") {
                    $query2->whereDate('INSP.INSP_DATE', '>=',$value);
                } elseif ($columnMapping[$key] == "INSP_END_TIME") {
                    $query2->whereDate('INSP.INSP_DATE', '<=',$value);
                }
            }
        }
        $query2->groupBy('INSP_MST_CHECKLIST_OPTION.CHECKLIST_OPTION_NAME');
        //$sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());
        return $query2->get();
    }


    
}