<?php

namespace App\Services\Chart;

use App\Http\Resources\Chart\ChartPtwResource;
use App\Models\MstSite;
use App\Models\Ptw;
use App\Models\User;
use App\Models\UserMapRole;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ChartPtwServices extends ChartPtwResource
{
    public $vvsPtwModel;
    public $page;
    public $pageSize;
    public function __construct()
    {
        $this->vvsPtwModel = new Ptw();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'PERMIT_START_TIME'=>'PERMIT_START_TIME',
            'PERMIT_END_TIME'=>'PERMIT_END_TIME'
        ];
    }

    public function getChartPtwTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = Ptw::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)->whereIn('STAGE_ID', [2,3,4,5,7,8,10,11])
                ->whereNotNull('TYPE_ID')->whereNotNull('STAGE_ID');
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query->where('SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query->whereDate($columnMapping[$key], '>=', $value);
                } elseif ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query->whereDate($columnMapping[$key], '<=', $value);
                } elseif ($columnMapping[$key] != "SITE_ID") {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        return $query->count();
    }

    public function getChartPtwByTypeCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('PTW')->select('PTW.TYPE_ID',DB::raw('COUNT("PTW"."TYPE_ID") AS PTW_COUNT'))
                ->where('PTW.IS_ACTIVE', 1)
                ->where('PTW.IS_DELETED', 0)
                ->whereNotNull('PTW.TYPE_ID')
                ->whereNotIn("PTW.STAGE_ID", [1]);

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('PTW.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query2->whereDate('PTW.PERMIT_START_TIME', '>=', $value);
                } elseif ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query2->whereDate('PTW.PERMIT_END_TIME', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query2->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('PTW.PERMIT_START_TIME', [$startDate, $endDate])
        //                 ->orWhereBetween('PTW.PERMIT_END_TIME', [$startDate, $endDate]);
        //         });
        // }

        $query2->groupBy('PTW.TYPE_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('PTW_MST_TYPE')->select(
            'PTW_MST_TYPE.TYPE_ID',
            'PTW_MST_TYPE.TYPE_NAME',
            'PTS.ptw_count AS PTW_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function($join) {
            $join->on('PTS.TYPE_ID', '=', 'PTW_MST_TYPE.TYPE_ID');
        })
        ->where('PTW_MST_TYPE.IS_ACTIVE', 1)
        ->where('PTW_MST_TYPE.IS_DELETED', 0)
        ->whereNotNull('PTW_MST_TYPE.TYPE_ID')
        ->orderBy('PTW_MST_TYPE.TYPE_ID');
        return $query->get();
    }

    
    public function getChartOpenPtwByTypeCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('PTW')->select('PTW.TYPE_ID',DB::raw('COUNT("PTW"."TYPE_ID") AS PTW_COUNT'))
                ->where('PTW.IS_ACTIVE', 1)
                ->where('PTW.IS_DELETED', 0)
                ->whereNotNull('PTW.TYPE_ID')
                ->whereIn("PTW.STAGE_ID", [2,3,4,5,7,8,10,11]);

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('PTW.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query2->whereDate('PTW.PERMIT_START_TIME', '>=', $value);
                } elseif ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query2->whereDate('PTW.PERMIT_END_TIME', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query2->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('PTW.PERMIT_START_TIME', [$startDate, $endDate])
        //                 ->orWhereBetween('PTW.PERMIT_END_TIME', [$startDate, $endDate]);
        //     });
        // }

        $query2->groupBy('PTW.TYPE_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('PTW_MST_TYPE')->select(
            'PTW_MST_TYPE.TYPE_ID', 
            'PTW_MST_TYPE.TYPE_NAME',
            'PTS.ptw_count AS PTW_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function($join) {
            $join->on('PTS.TYPE_ID', '=', 'PTW_MST_TYPE.TYPE_ID');
        })
        ->where('PTW_MST_TYPE.IS_ACTIVE', 1)
        ->where('PTW_MST_TYPE.IS_DELETED', 0)
        ->whereNotNull('PTW_MST_TYPE.TYPE_ID')
        ->orderBy('PTW_MST_TYPE.TYPE_ID');
        return $query->get();
    }

    public function getChartPtwByStageOverviewCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();
        
        $query2 = DB::table('PTW')->select('PTW.STAGE_ID',
                DB::raw('case when cast("PTW"."STAGE_ID" as int) IN (8) then 2
                            when cast("PTW"."STAGE_ID" as int) IN (11) then 1 
                        else 0 end as PTW_STATUS'),
                DB::raw('COUNT("PTW"."TYPE_ID") AS PTW_COUNT'))
                ->where('PTW.IS_ACTIVE', 1)
                ->where('PTW.IS_DELETED', 0)
                ->whereNotNull('PTW.TYPE_ID')
                ->whereIn("PTW.STAGE_ID", [2,3,4,5,7,8,10,11]);

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('PTW.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "PERMIT_START_TIME") {
                    $query2->whereDate('PTW.PERMIT_START_TIME', '>=', $value);
                } elseif ($columnMapping[$key] == "PERMIT_END_TIME") {
                    $query2->whereDate('PTW.PERMIT_END_TIME', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query2->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('PTW.PERMIT_START_TIME', [$startDate, $endDate])
        //                 ->orWhereBetween('PTW.PERMIT_END_TIME', [$startDate, $endDate]);
        //     });
        // }

        $query2->groupBy('PTW.STAGE_ID');
        //$sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());
        return $query2->get();
    }
    
    
}