<?php

namespace App\Services\Chart;

use App\Http\Resources\Chart\ChartHiraResource;
use App\Models\MstSite;
use App\Models\User;
use App\Models\UserMapRole;
use App\Models\MstLocation;
use App\Models\Hira;
use DateTime;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;

class ChartHiraServices extends ChartHiraResource
{
    public $vvsHiraModel;
    
    public function __construct()
    {
        $this->vvsHiraModel = new Hira();
    }

    /**
     * Column name in DB Table and Front end request variables are mapped
     * key is the column name of DB table and value is the front end request variable
     */
    protected function columnMappingsFrontEndVsBackEnd()
    {
        return [
            'SITE_ID' => 'SITE_ID',
            'HIRA_START_DATE'=>'HIRA_START_DATE',
            'HIRA_END_DATE'=>'HIRA_END_DATE'
        ];
    }

    public function getChartHiraTotalCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = Hira::where("IS_ACTIVE", 1)->where("IS_DELETED", 0)->whereNotIn("STAGE_ID", [1])
                    ->whereNotNull('STAGE_ID');
         // Check if SITE_ID is set and not equal to 0
         if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query->where('SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables
        foreach ($requestData as $key => $value) {
            // Check if the value is not empty and the mapping exists
            if (!empty($value) && isset($columnMapping[$key])) {
                // Add a where clause for the mapped column name
                if ($columnMapping[$key] == "HIRA_START_DATE") {
                    $query->whereDate($columnMapping[$key], '>=', $value);
                } elseif ($columnMapping[$key] == "HIRA_END_DATE") {
                    $query->whereDate($columnMapping[$key], '<=', $value);
                } elseif ($columnMapping[$key] != "SITE_ID") {
                    $query->where($columnMapping[$key], $value);
                }
            }
        }
        return $query->count();
    }

    public function getChartActivityCountByJob($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('HIRA_ACTIVITY')
            ->join('HIRA', 'HIRA.ID', '=', 'HIRA_ACTIVITY.HIRA_ID')
            ->select(
                'HIRA_ACTIVITY.JOB_ID',
                DB::raw('COUNT("HIRA_ACTIVITY"."JOB_ID") AS HIRA_COUNT')
            )
            ->where('HIRA_ACTIVITY.IS_ACTIVE', 1)
            ->where('HIRA_ACTIVITY.IS_DELETED', 0)
            ->whereNotIn("HIRA.STAGE_ID", [1]);

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('HIRA.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables for additional conditions
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($columnMapping[$key])) {
                if ($columnMapping[$key] == 'HIRA_START_DATE') {
                    $query2->whereDate('HIRA.HIRA_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == 'HIRA_END_DATE') {
                    $query2->whereDate('HIRA.HIRA_END_DATE', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query2->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('HIRA.HIRA_START_DATE', [$startDate, $endDate])
        //                 ->orWhereBetween('HIRA.HIRA_END_DATE', [$startDate, $endDate]);
        //     });
        // }
        
        $query2->groupBy('HIRA_ACTIVITY.JOB_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('HIRA_MST_JOB')->select(
            'HIRA_MST_JOB.JOB_ID',
            'HIRA_MST_JOB.JOB_NAME',
            'PTS.hira_count AS HIRA_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function ($join) {
            $join->on('PTS.JOB_ID', '=', 'HIRA_MST_JOB.JOB_ID');
        })
        ->where('HIRA_MST_JOB.IS_ACTIVE', 1)
        ->where('HIRA_MST_JOB.IS_DELETED', 0)
        ->whereNotNull('HIRA_MST_JOB.JOB_ID')
        ->orderBy('HIRA_MST_JOB.JOB_ID');
        return $query->get();
        
    }

    public function getChartActivityPtwCountByJob($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('HIRA_ACTIVITY')
            ->join('HIRA', 'HIRA.ID', '=', 'HIRA_ACTIVITY.HIRA_ID')
            ->select(
                'HIRA_ACTIVITY.JOB_ID',
                DB::raw('COUNT("HIRA_ACTIVITY"."JOB_ID") AS HIRA_COUNT')
            )
            ->where('HIRA_ACTIVITY.IS_ACTIVE', 1)
            ->where('HIRA_ACTIVITY.IS_DELETED', 0)
            ->where('HIRA_ACTIVITY.IS_PTW_REQUIRED', 1)
            ->whereNotIn("HIRA.STAGE_ID", [1]);

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('HIRA.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables for additional conditions
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($columnMapping[$key])) {
                if ($columnMapping[$key] == 'HIRA_START_DATE') {
                    $query2->whereDate('HIRA.HIRA_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == 'HIRA_END_DATE') {
                    $query2->whereDate('HIRA.HIRA_END_DATE', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query2->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('HIRA.HIRA_START_DATE', [$startDate, $endDate])
        //             ->orWhereBetween('HIRA.HIRA_END_DATE', [$startDate, $endDate]);
        //     });
        // }

        $query2->groupBy('HIRA_ACTIVITY.JOB_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('HIRA_MST_JOB')->select(
            'HIRA_MST_JOB.JOB_ID',
            'HIRA_MST_JOB.JOB_NAME',
            'PTS.hira_count AS HIRA_COUNT'
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function ($join) {
            $join->on('PTS.JOB_ID', '=', 'HIRA_MST_JOB.JOB_ID');
        })
        ->where('HIRA_MST_JOB.IS_ACTIVE', 1)
        ->where('HIRA_MST_JOB.IS_DELETED', 0)
        ->whereNotNull('HIRA_MST_JOB.JOB_ID')
        ->orderBy('HIRA_MST_JOB.JOB_ID');
        return $query->get();
        
    }

    public function getChartHiraCountByTime($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('HIRA')
            ->select(
                DB::raw('CASE WHEN CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) <=0 THEN 1
                                WHEN CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) >0 AND
                                 CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) <=30 THEN 2
                                ELSE 3 END AS HIRA_END_STATUS'),
                DB::raw('COUNT(*) AS HIRA_COUNT')
            )
            ->whereNotIn("HIRA.STAGE_ID", [1,7,8,9]);

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('HIRA.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables for additional conditions
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($columnMapping[$key])) {
                if ($columnMapping[$key] == 'HIRA_START_DATE') {
                    $query2->whereDate('HIRA.HIRA_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == 'HIRA_END_DATE') {
                    $query2->whereDate('HIRA.HIRA_END_DATE', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query2->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('HIRA.HIRA_START_DATE', [$startDate, $endDate])
        //             ->orWhereBetween('HIRA.HIRA_END_DATE', [$startDate, $endDate]);
        //     });
        // }

        $query2->groupBy(DB::raw('CASE WHEN CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) <=0 THEN 1
                                WHEN CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) >0 AND
                                 CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) <=30 THEN 2
                                ELSE 3 END'));
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());
        return $query2->get();
        
    }

    public function getChartHiraActivityTypeCountByTime($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('HIRA')
            ->select(
                'HIRA_ACTIVITY.JOB_ID',
                DB::raw('CASE WHEN CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) <=0 THEN 1
                                WHEN CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) >0 AND
                                 CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) <=30 THEN 2
                                ELSE 3 END AS HIRA_END_STATUS'),
                DB::raw('COUNT("HIRA_ACTIVITY"."JOB_ID") AS HIRA_COUNT')
            )
            ->leftJoin('HIRA_ACTIVITY', function ($join){
                $join->on('HIRA.ID', '=', 'HIRA_ACTIVITY.HIRA_ID')
                    ->where('HIRA_ACTIVITY.IS_ACTIVE', 1)
                    ->where('HIRA_ACTIVITY.IS_DELETED', 0);
            })
            ->whereNotIn("HIRA.STAGE_ID", [1,7,8,9]);

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('HIRA.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables for additional conditions
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($columnMapping[$key])) {
                if ($columnMapping[$key] == 'HIRA_START_DATE') {
                    $query2->whereDate('HIRA.HIRA_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == 'HIRA_END_DATE') {
                    $query2->whereDate('HIRA.HIRA_END_DATE', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query2->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('HIRA.HIRA_START_DATE', [$startDate, $endDate])
        //             ->orWhereBetween('HIRA.HIRA_END_DATE', [$startDate, $endDate]);
        //     });
        // }

        $query2->groupBy(DB::raw('CASE WHEN CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) <=0 THEN 1
                                WHEN CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) >0 AND
                                 CAST(((EXTRACT(EPOCH FROM CURRENT_DATE) - EXTRACT(EPOCH FROM "HIRA"."HIRA_END_DATE"))/86400) AS INT) <=30 THEN 2
                                ELSE 3 END'),'HIRA_ACTIVITY.JOB_ID');
        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());
        $query = DB::table('HIRA_MST_JOB')->select(
            'HIRA_MST_JOB.JOB_ID', 
            'HIRA_MST_JOB.JOB_NAME',
            'PTS.hira_end_status AS HIRA_END_STATUS',
            'PTS.hira_count AS HIRA_COUNT'  
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function($join) {
            $join->on('PTS.JOB_ID', '=', 'HIRA_MST_JOB.JOB_ID');
        })
        ->where('HIRA_MST_JOB.IS_ACTIVE', 1)
        ->where('HIRA_MST_JOB.IS_DELETED', 0)
        ->whereNotNull('HIRA_MST_JOB.JOB_ID')
        ->orderBy('HIRA_MST_JOB.JOB_ID');
        return $query->get();
        
    }



    public function getChartActivityPtwRequiredCount($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('HIRA_ACTIVITY')
            ->join('HIRA', 'HIRA.ID', '=', 'HIRA_ACTIVITY.HIRA_ID')
            ->select(
                'HIRA_ACTIVITY.IS_PTW_REQUIRED',
                DB::raw('COUNT("HIRA_ACTIVITY"."IS_PTW_REQUIRED") AS HIRA_COUNT')
            )
            ->where('HIRA_ACTIVITY.IS_ACTIVE', 1)
            ->where('HIRA_ACTIVITY.IS_DELETED', 0)
            ->whereNotIn("HIRA.STAGE_ID", [1]);

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('HIRA.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables for additional conditions
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($columnMapping[$key])) {
                if ($columnMapping[$key] == 'HIRA_START_DATE') {
                    $query2->whereDate('HIRA.HIRA_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == 'HIRA_END_DATE') {
                    $query2->whereDate('HIRA.HIRA_END_DATE', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query2->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('HIRA.HIRA_START_DATE', [$startDate, $endDate])
        //             ->orWhereBetween('HIRA.HIRA_END_DATE', [$startDate, $endDate]);
        //     });
        // }

        $query2->groupBy('HIRA_ACTIVITY.IS_PTW_REQUIRED');
        //$sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());
        return $query2->get();
        
    }

    public function getChartActivityByRiskMatrix($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query = DB::table('HIRA_ACTIVITY')
            ->join('HIRA', 'HIRA.ID', '=', 'HIRA_ACTIVITY.HIRA_ID')
            ->join('HIRA_MST_SEVERITY', 'HIRA_MST_SEVERITY.SEVERITY_ID', '=', 'HIRA_ACTIVITY.SEVERITY_ID')
            ->join('HIRA_MST_LIKELIHOOD', 'HIRA_MST_LIKELIHOOD.LIKELIHOOD_ID', '=', 'HIRA_ACTIVITY.LIKELIHOOD_ID')
            ->select(
                'HIRA_ACTIVITY.SEVERITY_ID',
                'HIRA_ACTIVITY.LIKELIHOOD_ID',
                'HIRA_MST_SEVERITY.SEVERITY_NAME',
                'HIRA_MST_LIKELIHOOD.LIKELIHOOD_NAME',
                DB::raw('CONCAT("HIRA_MST_SEVERITY"."SEVERITY_NAME","HIRA_MST_LIKELIHOOD"."LIKELIHOOD_NAME") AS RISK_FACTOR'),
                DB::raw('COUNT(*) AS  "HIRA_ACTIVITY_COUNT"')
            )
            ->where('HIRA_ACTIVITY.IS_ACTIVE', 1)
            ->where('HIRA_ACTIVITY.IS_DELETED', 0)
            ->whereNotIn("HIRA.STAGE_ID", [1]);
        
        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query->where('HIRA.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables for additional conditions
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($columnMapping[$key])) {
                if ($columnMapping[$key] == 'HIRA_START_DATE') {
                    $query->whereDate('HIRA.HIRA_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == 'HIRA_END_DATE') {
                    $query->whereDate('HIRA.HIRA_END_DATE', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('HIRA.HIRA_START_DATE', [$startDate, $endDate])
        //                 ->orWhereBetween('HIRA.HIRA_END_DATE', [$startDate, $endDate]);
        //     });
        // }

        $query->groupBy('HIRA_ACTIVITY.SEVERITY_ID', 'HIRA_ACTIVITY.LIKELIHOOD_ID', 'HIRA_MST_SEVERITY.SEVERITY_NAME', 'HIRA_MST_LIKELIHOOD.LIKELIHOOD_NAME');

        return $query->get();
    }
    
    public function getChartActivityRiskCountByType($requestData)
    {
        $columnMapping = $this->columnMappingsFrontEndVsBackEnd();

        $query2 = DB::table('HIRA_ACTIVITY')
        ->join('HIRA', 'HIRA.ID', '=', 'HIRA_ACTIVITY.HIRA_ID')
        ->join('HIRA_MST_SEVERITY', 'HIRA_MST_SEVERITY.SEVERITY_ID', '=', 'HIRA_ACTIVITY.SEVERITY_ID')
        ->join('HIRA_MST_LIKELIHOOD', 'HIRA_MST_LIKELIHOOD.LIKELIHOOD_ID', '=', 'HIRA_ACTIVITY.LIKELIHOOD_ID')
        ->select(
            'HIRA_ACTIVITY.JOB_ID',
            'HIRA_MST_SEVERITY.SEVERITY_NAME',
            'HIRA_MST_LIKELIHOOD.LIKELIHOOD_NAME',
            DB::raw('CONCAT("HIRA_MST_SEVERITY"."SEVERITY_NAME","HIRA_MST_LIKELIHOOD"."LIKELIHOOD_NAME") AS RISK_FACTOR'),
            DB::raw('COUNT("HIRA_ACTIVITY"."ID") AS  HIRA_COUNT')
        )
        ->where('HIRA_ACTIVITY.IS_ACTIVE', 1)
        ->where('HIRA_ACTIVITY.IS_DELETED', 0)
        ->whereNotIn("HIRA.STAGE_ID", [1]);

        // Check if SITE_ID is set and not equal to 0
        if (isset($requestData->SITE_ID) && $requestData->SITE_ID != 0) {
            $query2->where('HIRA.SITE_ID', $requestData->SITE_ID);
        }
        // Iterate over the requested variables for additional conditions
        foreach ($requestData as $key => $value) {
            if (!empty($value) && isset($columnMapping[$key])) {
                if ($columnMapping[$key] == 'HIRA_START_DATE') {
                    $query2->whereDate('HIRA.HIRA_START_DATE', '>=', $value);
                } elseif ($columnMapping[$key] == 'HIRA_END_DATE') {
                    $query2->whereDate('HIRA.HIRA_END_DATE', '<=', $value);
                }
            }
        }

        // if (isset($requestData->START_DATE) && isset($requestData->END_DATE)) {
        //     $startDate = $requestData->START_DATE;
        //     $endDate = $requestData->END_DATE;
        //     // Add special handling for date range queries
        //     $query2->where(function ($query2) use ($startDate, $endDate) {
        //         $query2->whereBetween('HIRA.HIRA_START_DATE', [$startDate, $endDate])
        //             ->orWhereBetween('HIRA.HIRA_END_DATE', [$startDate, $endDate]);
        //     });
        // }

        $query2->groupBy('HIRA_ACTIVITY.JOB_ID', 'HIRA_MST_SEVERITY.SEVERITY_NAME', 'HIRA_MST_LIKELIHOOD.LIKELIHOOD_NAME');

        $sql2Query = getQueryWithBindings($query2->toSql(),$query2->getBindings());

        $query = DB::table('HIRA_MST_JOB')->select(
            'HIRA_MST_JOB.JOB_ID', 
            'HIRA_MST_JOB.JOB_NAME',
            'PTS.risk_factor AS RISK_FACTOR',
            'PTS.hira_count AS HIRA_COUNT'  
        )
        ->leftJoin(DB::raw('('.$sql2Query.') AS "PTS"'), function($join) {
            $join->on('PTS.JOB_ID', '=', 'HIRA_MST_JOB.JOB_ID');
        })
        ->where('HIRA_MST_JOB.IS_ACTIVE', 1)
        ->where('HIRA_MST_JOB.IS_DELETED', 0)
        ->whereNotNull('HIRA_MST_JOB.JOB_ID')
        ->orderBy('HIRA_MST_JOB.JOB_ID');
        return $query->get();
    }

}