<?php

namespace App\Repositories\UserAcl;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\UserAcl\UserAclMapServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Models\UserMapRole;
use App\Models\UserAclMap;
use App\Repositories\UserAcl\UserAclMapPrivate;

class UserAclMapRepository implements UserAclMapInterface
{
    use EncDecService;
    public $vvsUserAclMapServices;   
    public $vvsUserService;
    public $vvsAclPrivate;

    /**
     * UserAclMapRepository constructor.
     */

    public function __construct()
    {
        $this->vvsUserAclMapServices = new UserAclMapServices();        
        $this->vvsUserService = new UserServices();
        $this->vvsAclPrivate = new UserAclMapPrivate();
    }

    /**
     * @param Request $request
     * @return DashboardTrainingResource
     */
    public function userMenuList(Request $request)
    {
        try {
            if(empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            //$requestData = $this->customDecrypt($request->X_KEY);            
            //$requestData -> CREATED_BY = $request -> CREATED_BY;
            $menulistData = $this->vvsUserAclMapServices->getUserMenuList($request);
            $output["USER_MENU_LIST"] = $this->vvsAclPrivate->setUserMenuData($menulistData);
            return $this->successMessage($output);            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
           
        }
    }
}