<?php

namespace App\Repositories\TRAINING;

use App\Http\Requests\TRAINING\AddRequest;
use App\Http\Requests\TRAINING\ViewRequest;
use App\Http\Requests\TRAINING\ListRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;
use App\Repositories\TRAINING\TrainingFileProcess;

use App\Http\Traits\EncDecService;
use App\Services\TRAINING\TrainingServices;
use App\Services\TRAINING\TrainingMstDeclarationServices;
use App\Services\UserServices;

use App\Http\Resources\TRAINING\TrainingMstDeclarationResource;
use App\Http\Resources\TRAINING\TrainingMapDeclarationResource;
use App\Http\Resources\TRAINING\TrainingResource;
use App\Http\Resources\TRAINING\TrainingMapParticipantResource;

class TrainingRepository implements TrainingInterface
{
    use EncDecService;
    public $vvsTrainingService; 
    public $vvsUserService;
    public $vvsTrainingListRequest;
    public $vvsViewRequest;
    public $vvsListRequest;
    public $vvsTrainingDeclService;
    public $vvsTrainingFileProcess;

    
    public function __construct()
    {     
      $this->vvsTrainingService = new TrainingServices();
      $this->vvsUserService = new UserServices();
      $this->vvsViewRequest = new ViewRequest();
      $this->vvsListRequest = new ListRequest();
      $this->vvsTrainingDeclService = new TrainingMstDeclarationServices();
      $this->vvsTrainingFileProcess = new TrainingFileProcess();
    }


    /**
     * @param Request $request
     * @return TrainingResource
     */
    public function trainingList(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsTrainingData = $this->vvsTrainingService->getTrainingList($requestData);
                $trainingList = $this->vvsTrainingFileProcess->setTrainingListing($vvsTrainingData);
                //$trainingList = TrainingResource::collection($vvsTrainingData);
                $output = ["TRAINING_LIST" => $trainingList];
                return $this->successMessage($output);               
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return trainingResource
     */
    public function trainingAdd(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
         
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
           
            $roleIds = array_map(function($item) {
                                    return $item['ROLE_ID'];
                                }, $vvsUserData ->trroles->toArray());
            if(in_array(14,$roleIds) && !in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE"])){
                return $this->failureMessage("Sorry! You are not permitted to create a training.");
            }

            //forcefully sending action irrespective of stage
                //ntbd
           
            if(in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE"])){

                $vvstrainingDataValidation = $request->trainingAddValidation();
            }else{
                $vvstrainingDataValidation = "";
            }
           
            if( $vvstrainingDataValidation == "" ){
                //data saving in training and associate table
                $trainingDataSaved = $this->vvsTrainingService->save($requestData);
                if( $trainingDataSaved ){
                    $saveMsg = "saved";
                    if(strtoupper($requestData->ACTION) == "DRAFT"){
                        $saveMsg = "drafted";
                    }
                    else if(strtoupper($requestData->ACTION) == "SAVE"){
                        $saveMsg = "saved";
                    }
                    else if(strtoupper($requestData->ACTION) == "RENEW"){
                        $saveMsg = "Renewed";
                    }
                    else if(strtoupper($requestData->ACTION) == "REQUEST_FOR_CLOSURE"){
                        $saveMsg = "requested for closure";
                    }
                    else if(strtoupper($requestData->ACTION) == "REQUEST_FOR_SUSPEND"){
                        $saveMsg = "requested for suspended";
                    }
                    else if(strtoupper($requestData->ACTION) == "MOVE_FORWARD"){
                        $saveMsg = "move forwarded";
                    }
                    else if(strtoupper($requestData->ACTION) == "SEND_BACK"){
                        $saveMsg = "sent back";
                    }
                    else if(strtoupper($requestData->ACTION) == "CLOSE"){
                        $saveMsg = "closed";
                    }
                    else if(strtoupper($requestData->ACTION) == "SUSPEND"){
                        $saveMsg = "suspended";
                    }
                    else if(strtoupper($requestData->ACTION) == "APPROVE"){
                        $saveMsg = "approved";
                    }
                    else if(strtoupper($requestData->ACTION) == "REJECT"){
                        $saveMsg = "rejected";
                    }

                    return $this->successMessage("training (Ref. No. ".$trainingDataSaved.") data has been ".$saveMsg.".");
                }else{
                    return $this->failureMessage(config('constants.SOMETHING_WRONG')." - data not saving.");
                }
            }else{
                return $this->failureMessage($vvstrainingDataValidation);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

     /**
     * @param Request $request
     * @return TrainingResource
     */

     public function trainingDetails(Request $request)
     {
         if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
             return $this->failureMessage("Request pattern is not valid.");
         }
         
         try {
             $vvsRequestData = $this->customDecrypt($request->X_KEY);
             $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
             $errorMessage = "";
 
             if (!$vvsUserData->toArray()) {
                 $errorMessage = "Token mismatch";
             } else {
                 $vvsValidationErrorData = $this->vvsViewRequest->editAPIInputValidation($vvsRequestData);
                 if (trim($vvsValidationErrorData) != "") {
                     $errorMessage = $vvsValidationErrorData;
                 } else { 
                     $vvsTrainingData = $this->vvsTrainingService->getTrainingDetails($vvsRequestData); 
                     $vvsaction = $vvsRequestData->ACTION ?? "";
                     if ($vvsTrainingData == "") {
                         $vvsTrainingOutput = [];
                     } else {
                         $editable = $vvsaction !== "view" && in_array($vvsTrainingData->STAGE_ID, [1]);
                         $vvsTrainingTableOutput = TrainingResource::transformTraining($vvsTrainingData);
                         $vvsTrainingDecalarion = $this->getDeclaration($vvsTrainingData->ID, $vvsTrainingData->STAGE_ID, $vvsaction);
                         $vvsButtonAccess = $this->trainingButtonAceess($vvsUserData, $vvsTrainingData, $vvsaction);
                         $vvsTrainingRecalculatedOutput = [
                             "FILES" => [
                                 "EDITABLE"      => ((in_array($vvsTrainingData->STAGE_ID,[1]) && ($vvsTrainingData->CREATED_BY == $request->CREATED_BY))?true:false),
                                 "VALUE"         => $this->vvsTrainingFileProcess->getTrainingFiles($vvsTrainingData->files, $vvsTrainingData->STAGE_ID, $vvsaction)
                             ],
                             "PARTICIPANTS"      => TrainingMapParticipantResource::collection($vvsTrainingData->participants),
                             "IS_DRAFT_BTN"      => $vvsButtonAccess["IS_DRAFT_BTN"],
                             "IS_SUBMIT_BTN"     => $vvsButtonAccess["IS_SUBMIT_BTN"],
                             "DECLARATION_1"     => $vvsTrainingDecalarion["DECLARATION_1"]
                         ];
                         $vvsTrainingOutput = array_merge($vvsTrainingTableOutput, $vvsTrainingRecalculatedOutput);
                     }
                     return $this->successMessage($vvsTrainingOutput);
                 }
             }
 
             return $this->failureMessage($errorMessage);
         } catch (ValidationException $e) {
             return $this->failureMessage(config('constants.SOMETHING_WRONG'));
         }
     }

     private function getDeclaration($tr_id,$stageId, $vvsaction)
    {
        $afterSubmit = $stageId;
        if (in_array($stageId, [1])) {
          $afterSubmit = 1;
        }
        $vvsTrainingInitDeclOne = $this->vvsTrainingDeclService->getMapDeclarationOne($tr_id,$afterSubmit);
        $vvsTrainingOutput["DECLARATION_1"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsTrainingOutput["DECLARATION_1"]["VALUE"] = TrainingMapDeclarationResource::collection($vvsTrainingInitDeclOne);
        return $vvsTrainingOutput;

    }

     private function trainingButtonAceess($userDetails, $trainingDetails, $vvsaction)
    {
        $vvsTrainingOutput = [
            "IS_DRAFT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SUBMIT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
        ];

        if ($trainingDetails->STAGE_ID == 1 && $trainingDetails->CREATED_BY = $userDetails->ID && $vvsaction!="view") {
            $vvsTrainingOutput["IS_DRAFT_BTN"]["EDITABLE"] = true;
            $vvsTrainingOutput["IS_SUBMIT_BTN"]["EDITABLE"] = true;
            $vvsTrainingOutput["IS_DRAFT_BTN"]["VALUE"] =  [];
            $vvsTrainingOutput["IS_SUBMIT_BTN"]["VALUE"] =  [];
        }
        return $vvsTrainingOutput;
    }

    /**
     * @param Request $request
     * @return TrainingResource
     */
    public function trainingListCal(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsTrainingData = $this->vvsTrainingService->getPlannedTrainingList($requestData);
                $trainingList = $this->vvsTrainingFileProcess->setTrainingListingCal($vvsTrainingData);
                $output = ["TRAINING_LIST" => $trainingList];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return TrainingResource
     */
    public function trainingListOnDemand(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsTrainingData = $this->vvsTrainingService->getUnPlannedTrainingList($requestData);
                $trainingList = TrainingResource::collection($vvsTrainingData);
                $vvsTrainingCount = $this->vvsTrainingService->getUnPlannedTrainingListTotalCount($requestData);
                $output = ["TRAINING_LIST" => $trainingList,"TOTAL_NO" => $vvsTrainingCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }


    /**
     * @param Request $request
     * @return trainingResource
     */
    public function trainingAddCal(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
         
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
           
            $roleIds = array_map(function($item) {
                                    return $item['ROLE_ID'];
                                }, $vvsUserData ->trroles->toArray());
            if(!in_array(14,$roleIds)){
                return $this->failureMessage("Sorry! You are not permitted to create a training.");
            }           
            $trainingDataSaved = $this->vvsTrainingService->saveTrainingCal($requestData);
            if( $trainingDataSaved ){
                $saveMsg = "saved";
                return $this->successMessage("training data has been uploaded successfully.");
            }else{
                $unsavedmasg = "No data selected for uploading. Please select atlast one month training data.";
                return $this->failureMessage(config('constants.SOMETHING_WRONG')." - ".$unsavedmasg);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG')." - data not saving.");
        }
    }

    public function trainingDetailsExport(Request $request)
    {
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsTrainingData = $this->vvsTrainingService->getTrainingDetailsExport($vvsRequestData);
            $vvsTrainingOutput = (new TrainingResource($vvsTrainingData))
                                ->transformTrainingExport($vvsTrainingData);

            $participants = $vvsTrainingData->participants;
            $vvsTrainingParticipantsOutput = [];
            foreach ($participants as $participant) {
                $vvsTrainingParticipantsOutput[] =
                TrainingMapParticipantResource::transformparticipant($participant);
            }
            $vvsTrainingOutput["PARTICIPANTS"] = $vvsTrainingParticipantsOutput;

            $afterSubmit = $vvsTrainingData->STAGE_ID;
            if (in_array($vvsTrainingData->STAGE_ID, [1])) {
                $afterSubmit = 1;
            }
            $vvsTrainingInitDeclOne = $this->vvsTrainingDeclService
                            ->getMapDeclarationOne($vvsTrainingData->ID, $afterSubmit);
            // prd($vvsTrainingInitDeclOne);
            $vvsDeclOutput = [];
            foreach ($vvsTrainingInitDeclOne as $key => $value) {
                $vvsDeclOutput[$value->DECLARATION_SECTION][] = $value->DECLARATION_NAME;
            }
            $vvsTrainingDeclOutput = array();
            $vvsTrainingDeclOutput["TR_ADD_ONE"] = $vvsDeclOutput['TR_ADD_ONE'] ?? [];
            $vvsTrainingOutput["DECLARATION"] = $vvsTrainingDeclOutput;

            $declaredBy = "";
            if ($vvsTrainingData->relationLoaded('declaredby')
                 && $vvsTrainingData->declaredby->count() > 0) {
            $firstDecl = $vvsTrainingData->declaredby()->where('IS_DELETED', 0)
                        ->where('IS_ACTIVE', 1)->first();
                if ($firstDecl) {
                    $actionTracker = $firstDecl->createdby;
                    if ($actionTracker) {
                        $declaredBy = ($actionTracker->IS_INFO_REDUCTED == 0) ?
                        ($this->customDecrypt($actionTracker->FIRST_NAME) . ' ' .
                        $this->customDecrypt($actionTracker->LAST_NAME)) : "-";
                    }
                }
            }
            $vvsTrainingOutput["DECLARED_BY"] = $declaredBy;

            return $this->successMessage([$vvsTrainingOutput]);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

}
