<?php

namespace App\Repositories\TRAINING;

use App\Http\Requests\TRAINING\MasterListRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\TRAINING\TrainingMstTypeServices;
use App\Services\TRAINING\TrainingMstLocationServices;
use App\Services\TRAINING\TrainingMstStageServices;
use App\Services\TRAINING\TrainingMstTopicServices;
use App\Services\TRAINING\TrainingMstDeclarationServices;
use App\Services\UserServices;

use App\Http\Resources\TRAINING\TrainingMstTypeResource;
use App\Http\Resources\TRAINING\LocationResource;
use App\Http\Resources\TRAINING\TrainingMstStageResource;
use App\Http\Resources\TRAINING\TrainingMstDeclarationResource;
use App\Http\Resources\TRAINING\TrainingMstTopicResource;




class TrainingMasterListRepository implements TrainingMasterListInterface
{
    use EncDecService;
    public $vvsTrainingTypeService;
    public $vvsLocationService;
    public $vvsTrainingStageService;
    public $vvsTrainingTopicService;
    public $vvsTrainingDeclService;
    public $vvsUserService;
    public $vvsTrainingListRequest;

    
    public function __construct()
    {
      $this->vvsTrainingTypeService = new TrainingMstTypeServices();
      $this->vvsLocationService = new TrainingMstLocationServices();
      $this->vvsTrainingStageService = new TrainingMstStageServices();
      $this->vvsTrainingDeclService = new TrainingMstDeclarationServices();
      $this->vvsTrainingTopicService = new TrainingMstTopicServices();
      $this->vvsUserService = new UserServices();

      $this->vvsTrainingListRequest = new MasterListRequest();
    }

   public function masterListTraining(Request $request){
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $vvsRawRequest = $this->customDecrypt($request->X_KEY);
            $vvsValidationErrorData = $this->vvsTrainingListRequest->masterAPIInputValidation($vvsRawRequest);
            if (trim($vvsValidationErrorData) != "") {
                return $this->failureMessage($vvsValidationErrorData);
            }

            //Training TYPE
            $vvsTrainingtypes = $this->vvsTrainingTypeService->getTrainingTypeList();
            $vvsMasterData["VVSTrainingTypes"] = TrainingMstTypeResource::collection($vvsTrainingtypes);
           
            $vvsPlanTrainingtypes = $this->vvsTrainingTypeService->getPlanTrainingTypeList();
            $vvsMasterData["VVSPlannedTrainingTypes"] = TrainingMstTypeResource::collection($vvsPlanTrainingtypes);
            
            $vvsUnPlanTrainingtypes = $this->vvsTrainingTypeService->getUnPlanTrainingTypeList();
            $vvsMasterData["VVSUnPlannnedTrainingTypes"] = TrainingMstTypeResource::collection($vvsUnPlanTrainingtypes);
            
            //Training Topic
            $vvsTrainingtopic = $this->vvsTrainingTopicService->getTrainingTopicList();
            $vvsMasterData["VVSTrainingTopic"] = TrainingMstTopicResource::collection($vvsTrainingtopic);

            //Training STAGES
            $vvsTrainingStages = $this->vvsTrainingStageService->getTrainingStageList();
            $vvsMasterData["VVSTrainingStages"] = TrainingMstStageResource::collection($vvsTrainingStages);

            //LOCATIONS
            $vvsTrainingLocations = $this->vvsLocationService->getLocationList($vvsRawRequest);
            $vvsMasterData["VVSTrainingLocations"] = LocationResource::collection($vvsTrainingLocations);

            //Training DECLARATION
            $vvsTrDeclOne = $this->vvsTrainingDeclService->getTrainingInitialDeclListOne();
            $vvsMasterData["TrainingDeclarationsOne"] = TrainingMstDeclarationResource::collection($vvsTrDeclOne);

            $vvsTrDeclTwo = $this->vvsTrainingDeclService->getTrainingInitialDeclListTwo();
            $vvsMasterData["TrainingDeclarationsTwo"] = TrainingMstDeclarationResource::collection($vvsTrDeclTwo);

            //YEAR LIST
            $vvsYearList = getTrainingYearList();
            $vvsMasterData["TrainingYearList"] = $vvsYearList;

            //Month LIST
            $vvsMonthList = getTrainingMonthList();
            $vvsMasterData["TrainingMonthList"] = $vvsMonthList;

            //SEARCH STATUS LIST
            $vvsStatusList = getTrainingStatusList();
            $vvsMasterData["TrainingStatusList"] = $vvsStatusList;

            //Training TYPE with Topic
            $vvsPlanTrainingTypeWithTopic = $this->vvsTrainingTypeService->getPlanTrainingTypeList();
            $vvsMasterData["VVSPlanTrainingTypeWithTopic"] = TrainingMstTypeResource::TrainingTypeWithTopic($vvsPlanTrainingTypeWithTopic);

            //Training TYPE, Topic Mapping
            $vvsTrainingTypeTopicMapping = $this->vvsTrainingTypeService->getTrainingTypeList();
            $vvsMasterData["VVSTrainingTypeTopicMapping"] = TrainingMstTypeResource::TrainingTypeTopicMapping($vvsTrainingTypeTopicMapping);
            
            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

}
