<?php

namespace App\Repositories\SAMLUSER;


use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Models\User;
use App\Models\SsoLoginToken;
use App\Repositories\SAMLUSER\UserInterface;
use Illuminate\Validation\ValidationException;


class UserRepository implements UserInterface
{
    use EncDecService;
   

    /**
     * @param Request $request
     */
    public function userUpdate(Request $request)
    {
        try {
            if(!isset($request->X_KEY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $requestData = $this->customDecrypt($request->X_KEY);

            //sso login token generate and insert into table
           
            SsoLoginToken::create([
                "EMAIL" => $this->customEncrypt($requestData -> EMAIL),
                "TOKEN" => $requestData ->TOKEN
            ]);
            
            $requestData = $this->customDecrypt($request->X_KEY);
            User::where("EMAIL", $this->customEncrypt($requestData -> EMAIL))->where("IS_DELETED", 0)
                                                        ->update([
                                                            "MANAGER_EMAIL" => $this->customEncrypt($requestData->MANAGER_EMAIL)
                                                        ]);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}
