<?php

namespace App\Repositories\Report;

use App\Http\Requests\Report\ReportTrainingListRequest;

// use App\Models\TrainingActionHistory;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\Report\ReportTrainingServices;
use App\Repositories\Report\ReportTrainingFileProcess;
// use App\Services\OBSERVATION\TrainingMstDeclarationServices;
// use App\Services\OBSERVATION\TrainingActionHistoryServices;
use App\Services\UserServices;
// use App\Repositories\OBSERVATION\ReportTrainingFileProcess;

use App\Models\MstLocation;

use App\Http\Resources\Report\ReportTrainingResource;
// use App\Http\Resources\OBSERVATION\TrainingMstDeclarationResource;
// use App\Http\Resources\OBSERVATION\TrainingMapDeclarationResource;
// use App\Http\Resources\OBSERVATION\TrainingActionHistoryResource;


class ReportTrainingRepository implements ReportTrainingInterface
{
    use EncDecService;
    public $vvsListRequest;
    // public $vvsTrainingAddRequest;
    public $vvsReportTrainingServices;
    public $vvsTrainingFileProcess;
    // public $vvsTrainingViewRequest;
    // public $vvsTrainingDeclService;
    // public $vvsTrainingFileProcess;
    // public $vvsTrainingActivityLogService;
    public $vvsUserService;
    

    public function __construct()
    {
        $this->vvsUserService = new UserServices();
        $this->vvsListRequest = new ReportTrainingListRequest();
        // $this->vvsTrainingViewRequest = new ViewRequest();
        // $this->vvsTrainingAddRequest = new AddRequest();
        $this->vvsReportTrainingServices = new ReportTrainingServices();
        $this->vvsTrainingFileProcess = new ReportTrainingFileProcess();
        // $this->vvsTrainingDeclService = new TrainingMstDeclarationServices();
        // $this->vvsTrainingFileProcess = new ReportTrainingFileProcess();
        // $this->vvsTrainingActivityLogService = new TrainingActionHistoryServices();
        
    }

    public function listTrainingReport(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsTrainingData = $this->vvsReportTrainingServices->getTrainingList($requestData);
                $trainingList = ReportTrainingResource::collection($vvsTrainingData['data']);
                $output = ["TRAINING_LIST" => $trainingList,"TOTAL_NO" => $vvsTrainingData['total']];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}