<?php

namespace App\Repositories\Report;

use App\Http\Controllers\Controller;
use App\Services\Report\ReportTrainingServices;


class ReportTrainingFileProcess extends Controller
{
    public $vvsTrainingService;

    /**
     * ReportTrainingFileProcess constructor.
     */

     public function __construct()
     {
         $this->vvsTrainingService = new ReportTrainingServices();
         
     }

    protected function getFileTypeFromUrl($url)
    {
        $vvsreturnData = "unknown";
        $vvsurlArray = explode(".", $url);
        $vvsurlLastElement = end($vvsurlArray);
        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
            $vvsreturnData = 'image';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['PDF'])) {
            $vvsreturnData = 'application/pdf';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['MP4'])) {
            $vvsreturnData = 'video';
        }
        return $vvsreturnData;
    }

    public function getTrainingFiles($vvsTrainingFiles, $vvsstageId, $vvsaction = null)
    {
        $vvsTrainingFileArray = [];
        $vvsUploadPath = config('constants.TR_FILE_UPLOAD_PATH');
        if (!empty($vvsTrainingFiles)) {
            foreach ($vvsTrainingFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsTrainingFileArray[$key1][$key2] = $value2;

                    if ($key2 == 'FILE_NAME') {
                        $vvsImagePath = asset('public/' . $vvsUploadPath . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsTrainingFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath, '', $value2);
                        $vvsTrainingFileArray[$key1]['TRAINING_FILE'] = $vvsImagePath;
                        $vvsTrainingFileArray[$key1]['MEDIA_TYPE_NAME'] = $this->getFileTypeFromUrl($vvsImagePath);
                        $vvsTrainingFileArray[$key1]['IS_DELETE'] = $vvsstageId == 1 && $vvsaction !== 'view';
                    }
                }
            }
        }
        return $vvsTrainingFileArray;
    }

   public function setTrainingListing($listingData){
        $listingArr = array();
        foreach ($listingData as $key => $value) {
            $listingArr[$value->type->TR_TYPE_NAME][$value->TOPIC_NAME]["TR_ID"][] = $value->ID;
            $listingArr[$value->type->TR_TYPE_NAME][$value->TOPIC_NAME]["MONTH"][] = showDate($value->TR_SCHEDULED_START_DATE, "F");
            $listingArr[$value->type->TR_TYPE_NAME][$value->TOPIC_NAME]["CLASS"][] = setTrainingcolor($value->TR_SCHEDULED_START_DATE,$value->TR_SCHEDULED_END_DATE,
            $value->STAGE_ID, $value->TR_START_DATE,$value->TR_END_DATE);
        }
        $retlistingArr = array();        
        foreach ($listingArr as $key => $value) {            
            foreach ($value as $key1 => $value1) {
                $retlistingArr1 = array();                
                $retlistingArr1["TYPE"] = $key;
                $retlistingArr1["TOPIC"] = $key1;
                $retlistingArr1["TR_ID"] = implode(',', array_unique($value1["TR_ID"]));
                $retlistingArr1["MONTH"] = implode(',', array_unique($value1["MONTH"]));
                $retlistingArr1["CLASS"] = implode(',', array_unique($value1["CLASS"]));
                $retlistingArr[]=$retlistingArr1;                
            }
            
        }  
        return $retlistingArr;
   }

   public function setTrainingListingCal($listingData){
        $listingArr = array();
        foreach ($listingData as $key => $value) {
            $listingArr1 = array(); 
            $listingArr1["TOPIC_DTLS"] = ["TOPIC"=>$value->TOPIC_NAME,"TYPE"=>$value->type->TR_TYPE_NAME];
            $listingArr1["TR_ID"] = $value->ID;
            $listingArr1["CLASS"] = setTrainingcolor($value->TR_SCHEDULED_START_DATE,$value->TR_SCHEDULED_END_DATE,
            $value->STAGE_ID, $value->TR_START_DATE,$value->TR_END_DATE);
            $listingArr[showDate($value->TR_SCHEDULED_START_DATE, "F")]["TOPIC_LIST"][]=$listingArr1;
        }
        $retlistingArr = array();
        foreach ($listingArr as $key => $value) {
            $retlistingArr1 = array();
            $retlistingArr1["MONTH"] = $key;
            $retlistingArr1["TOPIC_LIST"] = $value["TOPIC_LIST"];
            $retlistingArr[]=$retlistingArr1;
        }
        return $retlistingArr;
    }
 
}
