<?php

namespace App\Repositories\Report;

use App\Http\Requests\Report\ReportPtwListRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Report\ReportPtwServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Report\ReportPtwResource;

use App\Models\Ptw;

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Session;
use Intervention\Image\ImageManagerStatic as Image;


class ReportPtwRepository implements ReportPtwInterface
{
    use EncDecService;
    public $vvsReportPtwService;
    public $vvsReportPtwListRequest;
    public $vvsUserService;


    /**
     * ReportPtwRepository constructor.
     */

    public function __construct()
    {
        $this->vvsReportPtwService = new ReportPtwServices();
        $this->vvsReportPtwListRequest = new ReportPtwListRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return ReportPtwResource
     */
    public function listPtwReport(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsReportPtwListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsPtwData = $this->vvsReportPtwService->getPtwList($requestData);
                $ptwTotalCount = $this->vvsReportPtwService->getPtwListTotalCount($requestData);
                $ptwList = ReportPtwResource::collection($vvsPtwData);
                // $calculatedTab = $this->vvsReportPtwService->calculatedTab($requestData);
                // "TAB" => $calculatedTab,
                
                $output = ["PTW_LIST" => $ptwList,"TOTAL_NO" => $ptwTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}