<?php

namespace App\Repositories\Report;

use App\Http\Requests\Report\ReportObservationListRequest;

use App\Models\ObservationActionHistory;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\Report\ReportObservationServices;
// use App\Services\OBSERVATION\ObservationMstDeclarationServices;
// use App\Services\OBSERVATION\ObservationActionHistoryServices;
use App\Services\UserServices;
// use App\Repositories\OBSERVATION\ObservationFileProcess;

use App\Models\MstLocation;

use App\Http\Resources\Report\ReportObservationResource;
// use App\Http\Resources\OBSERVATION\ObservationMstDeclarationResource;
// use App\Http\Resources\OBSERVATION\ObservationMapDeclarationResource;
// use App\Http\Resources\OBSERVATION\ObservationActionHistoryResource;


class ReportObservationRepository implements ReportObservationInterface
{
    use EncDecService;
    public $vvsReportObservationListRequest;
    // public $vvsObservationAddRequest;
    public $vvsReportObservationServices;
    // public $vvsObservationViewRequest;
    // public $vvsObservationDeclService;
    // public $vvsObservationFileProcess;
    // public $vvsObservationActivityLogService;
    public $vvsUserService;
    

    public function __construct()
    {
        $this->vvsUserService = new UserServices();
        $this->vvsReportObservationListRequest = new ReportObservationListRequest();
        // $this->vvsObservationViewRequest = new ViewRequest();
        // $this->vvsObservationAddRequest = new AddRequest();
        $this->vvsReportObservationServices = new ReportObservationServices();
        // $this->vvsObservationDeclService = new ObservationMstDeclarationServices();
        // $this->vvsObservationFileProcess = new ObservationFileProcess();
        // $this->vvsObservationActivityLogService = new ObservationActionHistoryServices();
        
    }

    public function listObservationReport(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsObservationUerRoleData = $vvsUserData->obsroles;
            $vvsUserRole = "";
            if(isset($vvsObservationUerRoleData) && !$vvsObservationUerRoleData->isEmpty()){
                $vvsUserRole = $vvsObservationUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsReportObservationListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsObservationData = $this->vvsReportObservationServices->getObservationList($requestData);
                $ObservationTotalCount = $this->vvsReportObservationServices->getObservationListTotalCount($requestData);
                $ObservationList = ReportObservationResource::collection($vvsObservationData);
                // $calculatedTab = $this->vvsReportObservationServices->calculatedTab($requestData);
                $output = ["OBSERVATION_LIST" => $ObservationList,"TOTAL_NO" => $ObservationTotalCount,
                            "IS_ADD_BTN"=>(($vvsUserRole == 11)?true:false)];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}