<?php

namespace App\Repositories\Report;

use App\Http\Requests\Report\ReportInspectionListRequest;
// use App\Http\Requests\INSPECTION\ViewRequest;
// use App\Http\Requests\INSPECTION\AddRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\Report\ReportInspectionServices;
// use App\Services\INSPECTION\InspectionActivityServices;
// use App\Services\INSPECTION\InspectionMstDeclarationServices;
// use App\Services\INSPECTION\InspectionActionHistoryServices;
// use App\Services\INSPECTION\InspectionCheckListServices;
// use App\Repositories\INSPECTION\InspectionFileProcess;

use App\Services\UserServices;

use App\Models\MstLocation;

use App\Http\Resources\Report\ReportInspectionResource;
// use App\Http\Resources\INSPECTION\InspectionMstDeclarationResource;
// use App\Http\Resources\INSPECTION\InspectionMapDeclarationResource;
// use App\Http\Resources\INSPECTION\InspectionMapCheckListResource;
// use App\Http\Resources\INSPECTION\InspectionActionHistoryResource;

class ReportInspectionRepository implements ReportInspectionInterface
{
    use EncDecService;
    public $vvsReportInspectionListRequest;
    public $vvsReportInspectionService;
    // public $vvsInspectionAddRequest;
    // public $vvsInspectionDeclService;
    // public $vvsInspectionViewRequest;
    public $vvsUserService;
    // public $vvsInspectionActivityService;
    // public $vvsInspectionActivityLogService;
    // public $vvsInspectionCheckListService;
    // public $vvsInspectionFileProcess;


    public function __construct()
    {
        $this->vvsUserService = new UserServices();
        $this->vvsReportInspectionListRequest = new ReportInspectionListRequest();
        // $this->vvsInspectionViewRequest = new ViewRequest();
        // $this->vvsInspectionAddRequest = new AddRequest();
        // $this->vvsInspectionFileProcess = new InspectionFileProcess();
        $this->vvsReportInspectionService = new ReportInspectionServices();
        // $this->vvsInspectionDeclService = new InspectionMstDeclarationServices();
        // $this->vvsInspectionActivityLogService = new InspectionActionHistoryServices();
        // $this->vvsInspectionCheckListService = new InspectionCheckListServices();
    }

    public function listInspectionReport(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsInspectionUerRoleData = $vvsUserData->inspectionroles;
            $vvsUserRole = "";
            if(isset($vvsInspectionUerRoleData) && !$vvsInspectionUerRoleData->isEmpty()){
                $vvsUserRole = $vvsInspectionUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsReportInspectionListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsInspectionData = $this->vvsReportInspectionService->getInspectionList($requestData);
                $InspectionTotalCount = $this->vvsReportInspectionService->getInspectionListTotalCount($requestData);
                $InspectionList = ReportInspectionResource::collection($vvsInspectionData);
                // $calculatedTab = $this->vvsReportInspectionService->calculatedTab($requestData);
                $output = ["INSPECTION_LIST" => $InspectionList,"TOTAL_NO" => $InspectionTotalCount,
                            "IS_ADD_BTN"=>(($vvsUserRole == 7)?true:false)];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}