<?php

namespace App\Repositories\Report;

use App\Http\Requests\Report\ReportHiraListRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\Report\ReportHiraServices;
use App\Services\UserServices;

use App\Models\MstLocation;

use App\Http\Resources\Report\ReportHiraResource;

class ReportHiraRepository implements ReportHiraInterface
{
    use EncDecService;
    public $vvsReportHiraListRequest;
    public $vvsReportHiraServices;
    public $vvsUserService;

    public function __construct()
    {
        $this->vvsUserService = new UserServices();
        $this->vvsReportHiraListRequest = new ReportHiraListRequest();
        $this->vvsReportHiraServices = new ReportHiraServices();
    }

    public function listHiraReport(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsHiraUerRoleData = $vvsUserData->hiraroles;
            $vvsUserRole = "";
            if(isset($vvsHiraUerRoleData) && !$vvsHiraUerRoleData->isEmpty()){
                $vvsUserRole = $vvsHiraUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsReportHiraListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsHiraData = $this->vvsReportHiraServices->getHiraList($requestData);
                $hiraTotalCount = $this->vvsReportHiraServices->getHiraListTotalCount($requestData);
                $hiraList = ReportHiraResource::collection($vvsHiraData);
                // $calculatedTab = $this->vvsReportHiraServices->calculatedTab($requestData);
                $output = ["HIRA_LIST" => $hiraList,"TOTAL_NO" => $hiraTotalCount,
                            "IS_ADD_BTN"=>(($vvsUserRole == 4)?true:false)];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}