<?php

namespace App\Repositories\PTW;

use App\Http\Requests\PTW\ListRequest;
use App\Http\Requests\PTW\ViewRequest;
use App\Http\Requests\PTW\AddRequest;
use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\PTW\PtwServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\PTW\PtwResource;
use App\Http\Resources\PTW\PtwMapPrecResource;
use App\Http\Resources\PTW\PtwMapCheckListResource;
use App\Repositories\PTW\PtwFileProcess;
use App\Services\PTW\PtwMstDeclarationServices;
use App\Services\PTW\PtwCheckListServices;
use App\Services\PTW\PtwActionHistoryServices;
use App\Http\Resources\PTW\PtwMstDeclarationResource;
use App\Http\Resources\PTW\PtwMapDeclarationResource;
use App\Http\Resources\PTW\PtwMapWorkerResource;
use App\Http\Resources\PTW\PtwActionHistoryResource;
use App\Http\Resources\PTW\PtwMapPrecReportResource;
use App\Models\Ptw;

use App\Services\PTW\PtwAuditServices;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Session;
use Intervention\Image\ImageManagerStatic as Image;


class PtwRepository implements PtwInterface
{
    use EncDecService;
    // public $encDecService;
    public $vvsPtwService;
    public $vvsPtwListRequest;
    public $vvsPtwViewRequest;
    public $vvsPtwAddRequest;
    public $vvsPtwFileProcess;
    public $vvsPtwDeclService;
    public $vvsPtwCheckListService;
    public $vvsPtwActivityService;
    public $vvsPtwAuditService;

    public $vvsUserService;


    /**
     * PtwRepository constructor.
     */

    public function __construct()
    {
        // $this->encDecService = new EncDecService();

        $this->vvsPtwService = new PtwServices();
        $this->vvsPtwListRequest = new ListRequest();
        $this->vvsPtwViewRequest = new ViewRequest();
        $this->vvsPtwAddRequest = new AddRequest();
        $this->vvsPtwFileProcess = new PtwFileProcess();
        $this->vvsUserService = new UserServices();
        $this->vvsPtwDeclService = new PtwMstDeclarationServices();
        $this->vvsPtwCheckListService = new PtwCheckListServices();
        $this->vvsPtwActivityService = new PtwActionHistoryServices();
        $this->vvsPtwAuditService = new PtwAuditServices();
    }
    

    /**
     * @param Request $request
     * @return PtwResource
     */
    public function listPtw(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsPtwListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsPtwData = $this->vvsPtwService->getPtwList($requestData);
                $ptwTotalCount = $this->vvsPtwService->getPtwListTotalCount($requestData);
                $ptwList = PtwResource::collection($vvsPtwData);
                $calculatedTab = $this->vvsPtwService->calculatedTab($requestData);
                
                
                $output = ["TAB" => $calculatedTab, "PTW_LIST" => $ptwList,"TOTAL_NO" => $ptwTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

   
    private function ptwButtonAceess($userDetails, $ptwDetails, $vvsaction)
    {
        $vvsPtwOutput = [
            "IS_DRAFT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SUBMIT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_FORWARD_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SEND_BACK_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_APPROVE_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_REJECT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_CLOSE_REQ_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_CLOSE_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SUSPEND_REQ_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SUSPEND_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_RENEW_BTN" => ["EDITABLE"=>false,"VALUE"=>[]]
        ];

        $vvsPtwUerRoleData = $userDetails->ptwroles;
        $vvsUserRole = $vvsPtwUerRoleData[0]->ROLE_ID;

        $userId = $userDetails->ID;
        $stageId = $ptwDetails->STAGE_ID;

        $this->handleInitiatorPart($vvsPtwOutput, $userId, $ptwDetails, $vvsaction);
        $this->handleReviewerPart($vvsPtwOutput, $vvsUserRole, $stageId, $vvsaction);
        $this->handleApproverPart($vvsPtwOutput, $vvsUserRole, $stageId, $vvsaction);

        return $vvsPtwOutput;
    }

    private function handleInitiatorPart(&$vvsPtwOutput, $userId, $ptwDetails, $vvsaction)
    {
        $vvsCurTime = date('Y-m-d H:i:s');
        $vvsMinRenewDate = date("Y-m-d H:i:s", strtotime('+12 hours', strtotime($ptwDetails->PERMIT_END_TIME)));
        if ($userId == $ptwDetails->CREATED_BY && $vvsaction != "view") {
            if ((in_array($ptwDetails->STAGE_ID,[1,4])) ||
                 ($ptwDetails->STAGE_ID == 5 && strtoupper($vvsaction) == "RENEW")) {
                $vvsPtwOutput["IS_DRAFT_BTN"]["EDITABLE"] = true;
                $vvsPtwOutput["IS_SUBMIT_BTN"]["EDITABLE"] = true;
                $vvsPtwOutput["IS_DRAFT_BTN"]["VALUE"] =  [];
                $vvsPtwOutput["IS_SUBMIT_BTN"]["VALUE"] =  [];
            }
            if ($ptwDetails->STAGE_ID == 5 && strtoupper($vvsaction) != "RENEW") {
                $vvsPtwCloseDecl = $this->vvsPtwDeclService->getPtwCloseReqDeclList();
                $vvsPtwOutput["IS_CLOSE_REQ_BTN"]["EDITABLE"] = true;
                $vvsPtwOutput["IS_CLOSE_REQ_BTN"]["VALUE"] =  PtwMstDeclarationResource::collection($vvsPtwCloseDecl);

                $vvsPtwSuspendDecl = $this->vvsPtwDeclService->getPtwSuspendReqDeclList();
                $vvsPtwOutput["IS_SUSPEND_REQ_BTN"]["EDITABLE"] = true;
                $vvsPtwOutput["IS_SUSPEND_REQ_BTN"]["VALUE"] = PtwMstDeclarationResource::collection($vvsPtwSuspendDecl);
                
                if($ptwDetails->RENEWAL_COUNT <= 5){
                    //if(strtotime($vvsCurTime) >= strtotime($vvsMinRenewDate)){
                        $vvsPtwRenewDecl = $this->vvsPtwDeclService->getPtwRenewDeclList();
                        $vvsPtwOutput["IS_RENEW_BTN"]["EDITABLE"] = true;
                        $vvsPtwOutput["IS_RENEW_BTN"]["VALUE"] =  PtwMstDeclarationResource::collection($vvsPtwRenewDecl);
                    //}
                }
                
            }
        }
    }

    private function handleReviewerPart(&$vvsPtwOutput, $vvsUserRole, $stageId, $vvsaction)
    {
        if ($vvsUserRole == 2 && $vvsaction != "view") {
            if($stageId  == 2){
                $vvsPtwOutput["IS_FORWARD_BTN"]["EDITABLE"] = true;
                $vvsPtwDeclarations = $this->vvsPtwDeclService->getPtwMoveFrwdDeclList();
                $vvsPtwOutput["IS_FORWARD_BTN"]["VALUE"] = PtwMstDeclarationResource::collection($vvsPtwDeclarations);

                $vvsPtwOutput["IS_SEND_BACK_BTN"]["EDITABLE"] = true;
            }
            if ($stageId == 7) {
                $vvsPtwOutput["IS_CLOSE_BTN"]["EDITABLE"] = true;
                $vvsPtwCloseDecl = $this->vvsPtwDeclService->getPtwCloseDeclList();
                $vvsPtwOutput["IS_CLOSE_BTN"]["VALUE"] = PtwMstDeclarationResource::collection($vvsPtwCloseDecl);
            }
            if ($stageId == 10) {
                $vvsPtwOutput["IS_SUSPEND_BTN"]["EDITABLE"] = true;
                $vvsPtwSuspendDecl = $this->vvsPtwDeclService->getPtwSuspendDeclList();
                $vvsPtwOutput["IS_SUSPEND_BTN"]["VALUE"] = PtwMstDeclarationResource::collection($vvsPtwSuspendDecl);
            }
        }
    }

    private function handleApproverPart(&$vvsPtwOutput, $vvsUserRole, $stageId, $vvsaction)
    {
        if ($vvsUserRole == 3 && $stageId == 3 && $vvsaction != "view") {
            $vvsPtwOutput["IS_APPROVE_BTN"]["EDITABLE"] = true;
            $vvsPtwApprDecl = $this->vvsPtwDeclService->getPtwApproveDeclList();
            $vvsPtwOutput["IS_APPROVE_BTN"]["VALUE"] = PtwMstDeclarationResource::collection($vvsPtwApprDecl);

            $vvsPtwOutput["IS_REJECT_BTN"]["EDITABLE"] = true;
            $vvsPtwRejDecl = $this->vvsPtwDeclService->getPtwRejectDeclList();
            $vvsPtwOutput["IS_REJECT_BTN"]["VALUE"] = PtwMstDeclarationResource::collection($vvsPtwRejDecl);
        }
    }

    private function getDeclaration($ptw_id,$stageId, $vvsaction)
    {
        $afterSubmit = $stageId;
        if (in_array($stageId, [1,4,6])) {
          $afterSubmit = 1;
        }
        $vvsPtwInitDeclOne = $this->vvsPtwDeclService->getMapDeclarationOne($ptw_id,$afterSubmit);
        $vvsPtwInitDeclTwo = $this->vvsPtwDeclService->getMapDeclarationTwo($ptw_id,$afterSubmit);
        $vvsPtwOutput["DECLARATION_1"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsPtwOutput["DECLARATION_1"]["VALUE"] = PtwMapDeclarationResource::collection($vvsPtwInitDeclOne);
        $vvsPtwOutput["DECLARATION_2"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsPtwOutput["DECLARATION_2"]["VALUE"] = PtwMapDeclarationResource::collection($vvsPtwInitDeclTwo);
        return $vvsPtwOutput;

    }

    private function getCheckList($ptw_id,$type_id,$stageId, $vvsaction)
    {
        $afterSubmit = $stageId;
        if (in_array($stageId, [1,4,6])) {
          $afterSubmit = 1;
        }
        $vvsPtwChkGen = $this->vvsPtwCheckListService->getMapGeneralPtwCheckList($ptw_id,$type_id,$afterSubmit);
        //$vvsGenOutPut1 = PtwMapCheckListResource::collection($vvsPtwChkGen);
        $vvsPtwChkGen1 = $this->vvsPtwCheckListService->ptwMapGeneralChecklistOther($ptw_id);
        $vvsGenOutPut2 = $vvsPtwChkGen->merge($vvsPtwChkGen1);
        $vvsGenAll = PtwMapCheckListResource::collection($vvsGenOutPut2); 

        $vvsPtwChkPpe = $this->vvsPtwCheckListService->getMapPpePtwCheckList($ptw_id,$type_id,$afterSubmit); 
        //$vvsPpeOutPut1 = PtwMapCheckListResource::collection($vvsPtwChkPpe);
        $vvsPtwChkPpe1 = $this->vvsPtwCheckListService->ptwMapPpeChecklistOther($ptw_id);
        $vvsPpeOutPut2 = $vvsPtwChkPpe->merge($vvsPtwChkPpe1);
        $vvsPpeAll = PtwMapCheckListResource::collection($vvsPpeOutPut2);        

        $vvsPtwOutput["GENERAL_CHECKLIST"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsPtwOutput["GENERAL_CHECKLIST"]["VALUE"] = $vvsGenAll;
        $vvsPtwOutput["PPE_CHECKLIST"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsPtwOutput["PPE_CHECKLIST"]["VALUE"] = $vvsPpeAll;
        return $vvsPtwOutput;

    }


    /**
     * @param Request $request
     * @return PtwResource
     */

    public function ptwDetails(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";

            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                
                $vvsValidationErrorData = $this->vvsPtwViewRequest->editAPIInputValidation($vvsRequestData);
                if (trim($vvsValidationErrorData) != "") {
                    $errorMessage = $vvsValidationErrorData;
                } else {

                    $vvsPtwData = $this->vvsPtwService->getPtwDetails($vvsRequestData);

                    $vvsaction = $vvsRequestData->ACTION ?? "";
                    if ($vvsPtwData == "") {
                        $vvsPtwOutput = [];
                    } else {
                        $editable = $vvsaction !== "view" && in_array($vvsPtwData->STAGE_ID, [1,4]);

                        $vvsButtonAccess = $this->ptwButtonAceess($vvsUserData, $vvsPtwData, $vvsaction);
                        $vvsPtwUerRoleData = $vvsUserData->ptwroles;
                        $vvsUserRole = $vvsPtwUerRoleData[0]->ROLE_ID;
                        if($vvsPtwData->STAGE_ID == 5 && strtoupper($vvsaction)=="RENEW" && $vvsUserRole == 1){
                            $vvsPtwTableOutput = PtwResource::transformPtwRenew($vvsPtwData,$vvsaction);
                        }else{
                            $vvsPtwTableOutput = PtwResource::transformPtw($vvsPtwData);
                        }
                        $vvsPtwDecalarion = $this->getDeclaration($vvsPtwData->ID, $vvsPtwData->STAGE_ID, $vvsaction);
                        $vvsPtwCheckList = $this->getCheckList($vvsPtwData->ID, $vvsPtwData->TYPE_ID, $vvsPtwData->STAGE_ID, $vvsaction);
                        
                        $vvsPtwRecalculatedOutput = [
                            "PRECAUSIONS" => [
                                "EDITABLE"      => $editable,
                                "VALUE"         => PtwMapPrecResource::collection($vvsPtwData->precausions)
                            ],
                            "PTW_FILES" => [
                                "EDITABLE"      => true,
                                "VALUE"         => $this->vvsPtwFileProcess->getPtwFiles($vvsPtwData->files, $vvsPtwData->STAGE_ID, $vvsaction)
                            ],
                            "RISK" => [
                                "EDITABLE"      => $editable,
                                "VALUE"         => PtwMapWorkerResource::collection($vvsPtwData->workers)
                            ],
                            "GENERAL_CHECKLIST" => $vvsPtwCheckList["GENERAL_CHECKLIST"],
                            "PPE_CHECKLIST"     => $vvsPtwCheckList["PPE_CHECKLIST"],
                            "IS_DRAFT_BTN"      => $vvsButtonAccess["IS_DRAFT_BTN"],
                            "IS_SUBMIT_BTN"     => $vvsButtonAccess["IS_SUBMIT_BTN"],
                            "IS_FORWARD_BTN"    => $vvsButtonAccess["IS_FORWARD_BTN"],
                            "IS_SEND_BACK_BTN"  => $vvsButtonAccess["IS_SEND_BACK_BTN"],
                            "IS_APPROVE_BTN"    => $vvsButtonAccess["IS_APPROVE_BTN"],
                            "IS_REJECT_BTN"     => $vvsButtonAccess["IS_REJECT_BTN"],
                            "IS_CLOSE_REQ_BTN"  => $vvsButtonAccess["IS_CLOSE_REQ_BTN"],
                            "IS_CLOSE_BTN"      => $vvsButtonAccess["IS_CLOSE_BTN"],
                            "IS_SUSPEND_REQ_BTN" => $vvsButtonAccess["IS_SUSPEND_REQ_BTN"],
                            "IS_SUSPEND_BTN"    => $vvsButtonAccess["IS_SUSPEND_BTN"],
                            "IS_RENEW_BTN"      => $vvsButtonAccess["IS_RENEW_BTN"],
                            "DECLARATION_1"     => $vvsPtwDecalarion["DECLARATION_1"],
                            "DECLARATION_2"     => $vvsPtwDecalarion["DECLARATION_2"]
                        ];
                        $vvsPtwOutput = array_merge($vvsPtwTableOutput, $vvsPtwRecalculatedOutput);
                    }
                    return $this->successMessage($vvsPtwOutput);
                }
            }

            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return PtwResource
     */
    public function ptwAdd(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
         
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
           
            $roleIds = array_map(function($item) {
                                    return $item['ROLE_ID'];
                                }, $vvsUserData ->ptwroles->toArray());
            if(in_array(1,$roleIds) && !in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","REQUEST_FOR_CLOSURE","REQUEST_FOR_SUSPEND","RENEW"])){
                return $this->failureMessage("Sorry! You are not permitted to create a PTW.");
            }
            if(in_array(2,$roleIds) && !in_array(strtoupper($requestData->ACTION),["MOVE_FORWARD","SEND_BACK","CLOSE","SUSPEND"])){
                return $this->failureMessage("Sorry! You are not permitted to take the selected action.");
            }
            if(in_array(3,$roleIds) && !in_array(strtoupper($requestData->ACTION),["APPROVE","REJECT"])){
                return $this->failureMessage("Sorry! You are not permitted to take the selected action.");
            }
            

            //forcefully sending action irrespective of stage
                //ntbd
           
            if(in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE"])){

                $vvsPtwDataValidation = $request->ptwAddValidation();
            }elseif(!in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","RENEW"])){
                $vvsPtwDataValidation = $request->ptwSaveValidation();
            }else{
                $vvsPtwDataValidation = "";
            }
           
            if( $vvsPtwDataValidation == "" ){
                //data saving in PTW and associate table
                $ptwDataSaved = $this->vvsPtwService->save($requestData);
                if( $ptwDataSaved ){
                    $saveMsg = "saved";
                    if(strtoupper($requestData->ACTION) == "DRAFT"){
                        $saveMsg = "drafted";
                    }
                    else if(strtoupper($requestData->ACTION) == "SAVE"){
                        $saveMsg = "saved";
                    }
                    else if(strtoupper($requestData->ACTION) == "RENEW"){
                        $saveMsg = "Renewed";
                    }
                    else if(strtoupper($requestData->ACTION) == "REQUEST_FOR_CLOSURE"){
                        $saveMsg = "requested for closure";
                    }
                    else if(strtoupper($requestData->ACTION) == "REQUEST_FOR_SUSPEND"){
                        $saveMsg = "requested for suspended";
                    }
                    else if(strtoupper($requestData->ACTION) == "MOVE_FORWARD"){
                        $saveMsg = "move forwarded";
                    }
                    else if(strtoupper($requestData->ACTION) == "SEND_BACK"){
                        $saveMsg = "sent back";
                    }
                    else if(strtoupper($requestData->ACTION) == "CLOSE"){
                        $saveMsg = "closed";
                    }
                    else if(strtoupper($requestData->ACTION) == "SUSPEND"){
                        $saveMsg = "suspended";
                    }
                    else if(strtoupper($requestData->ACTION) == "APPROVE"){
                        $saveMsg = "approved";
                    }
                    else if(strtoupper($requestData->ACTION) == "REJECT"){
                        $saveMsg = "rejected";
                    }

                    return $this->successMessage("PTW (Ref. No. ".$ptwDataSaved.") data has been ".$saveMsg.".");
                }else{
                    return $this->failureMessage(config('constants.SOMETHING_WRONG')." - data not saving.");
                }
            }else{
                return $this->failureMessage($vvsPtwDataValidation);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function createCaptcha($request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = "";
            if( !is_numeric($requestData -> ID) || $requestData -> ID == "" || $requestData -> ID <= 0){
                $validationErrorData = "PTW ID must be a valid number.";
            }
            
            if ($validationErrorData == "") {
                // Generate random CAPTCHA text
                $captchaText = strtoupper(Str::random(6));
                        
                // Store the CAPTCHA text in the session
                Session::put('captcha', $captchaText);

                // Create a new image instance
                $image = Image::canvas(200, 60, '#ffffff');
                // Add CAPTCHA text to the image
                $image->text($captchaText, 100, 30, function($font) {
                    $font->file(public_path('fonts/Arial.ttf')); // Adjust font file path as needed
                    $font->size(30);
                    $font->color('#000000');
                    $font->align('center');
                    $font->valign('middle');
                });

                // Encode the image to base64 format
                // prd('data:image/png;base64,'.base64_encode($image->encode('png')));

                
                $this->vvsPtwService -> ptwCaptchaUpdate($requestData,$captchaText);

                
                $base64Image = 'data:image/png;base64,'.base64_encode($image->encode('png'));
                $output = ["captcha_text"=>$captchaText,"captcha_image"=>$base64Image];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }        

    }

    public function ptwDetailsExport(Request $request)
    {
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }        
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsPtwData = $this->vvsPtwService->getPtwDetails($vvsRequestData);
            $vvsPtwTableOutput = (new PtwResource($vvsPtwData))->transformPtwXlReport($vvsPtwData);
            $afterSubmit = 1;
            $vvsPtwChkGen = $this->vvsPtwCheckListService->getMapGeneralPtwCheckList($vvsPtwData->ID, $vvsPtwData->TYPE_ID,$afterSubmit);
            $vvsPtwChkGen1 = $this->vvsPtwCheckListService->ptwMapGeneralChecklistOther($vvsPtwData->ID);
            $vvsGenOutPut2 = $vvsPtwChkGen->merge($vvsPtwChkGen1);

            $vvsPtwChkPpe = $this->vvsPtwCheckListService->getMapPpePtwCheckList($vvsPtwData->ID, $vvsPtwData->TYPE_ID,$afterSubmit);
            $vvsPtwChkPpe1 = $this->vvsPtwCheckListService->ptwMapPpeChecklistOther($vvsPtwData->ID);
            $vvsPpeOutPut2 = $vvsPtwChkPpe->merge($vvsPtwChkPpe1);

            $vvsPtwSOPHira = $this->getPtwSOPHiraReport($vvsPtwData);
            $ptwId = $vvsPtwData->ID;
            if($vvsPtwData->TOP_PARENT_PTW_ID > 0){
                $ptwId = $vvsPtwData->TOP_PARENT_PTW_ID;
            }
            $ptwActivityLog = $this->vvsPtwActivityService->getAllActivityLog($ptwId);
            $vvsPtwActionHistory = [];
            foreach ($ptwActivityLog as $value){
            $vvsPtwActionHistory[] = (new PtwActionHistoryResource($value))->transformPtwAHXlReport($value);
            }
            $vvsPtwRecalculatedOutput = [
                "PRECAUSIONS"       => PtwMapPrecReportResource::collection($vvsPtwData->precausions),
                "RISK"              => PtwMapWorkerResource::collection($vvsPtwData->workers),
                "GENERAL_CHECKLIST" => $vvsGenOutPut2,
                "PPE_CHECKLIST"     => $vvsPpeOutPut2,
                "DECLARATIONS"      => $this->getDeclarationReport($vvsPtwData->ID),
                // "ACTION_HISTORY"    => PtwActionHistoryResource::collection($ptwActivityLog),
                "ACTION_HISTORY"    => $vvsPtwActionHistory,
                "SOP_POLICIES"      => $vvsPtwSOPHira["SOP_POLICIES"],
                "HIRA_REFERENCES"   => $vvsPtwSOPHira["HIRA_REFERENCES"],
                "ORG_DOCUMENT_NO"   => 'SHW_IND_PTW_03_V1_02/2024'
            ];
            $vvsPtwOutput = array_merge($vvsPtwTableOutput, $vvsPtwRecalculatedOutput);
            return $this->successMessage($vvsPtwOutput);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    private function getDeclarationReport($ptw_id)
    {
        $vvsPtwOutput = array();
        $vvsPtwInitDecl = $this->vvsPtwDeclService->getMapDeclarationAll($ptw_id);
        foreach ($vvsPtwInitDecl as $key => $value) {
            $vvsPtwOutput[$value->DECLARATION_SECTION][] = $value->DECLARATION_NAME; 
        }
        $vvsPtwDeclOutput = array();
        $vvsPtwDeclOutput["PTW_ADD_ONE"] = $vvsPtwOutput['PTW_ADD_ONE'] ?? [];
        $vvsPtwDeclOutput["PTW_ADD_TWO"] = $vvsPtwOutput['PTW_ADD_TWO'] ?? [];
        $vvsPtwDeclOutput["PTW_MOVE_FORWARD"] = $vvsPtwOutput['MOVE_FORWARD'] ?? [];
        $vvsPtwDeclOutput["PTW_APPROVE"] = $vvsPtwOutput['APPROVE'] ?? [];
        $vvsPtwDeclOutput["PTW_REJECT"] = $vvsPtwOutput['REJECT'] ?? [];
        $vvsPtwDeclOutput["PTW_REQUEST_FOR_CLOSURE"] = $vvsPtwOutput['REQUEST_FOR_CLOSURE'] ?? [];
        $vvsPtwDeclOutput["PTW_CLOSE"] = $vvsPtwOutput['CLOSE'] ?? [];
        $vvsPtwDeclOutput["PTW_REQUEST_FOR_SUSPEND"] = $vvsPtwOutput['REQUEST_FOR_SUSPEND'] ?? [];
        $vvsPtwDeclOutput["PTW_SUSPEND"] = $vvsPtwOutput['SUSPEND'] ?? [];
        $vvsPtwDeclOutput["PTW_RENEWED"] = $vvsPtwOutput['RENEWED'] ?? [];
        return $vvsPtwDeclOutput;
    }

    private function getPtwSOPHiraReport($vvsPtwData)
    {
        $vvsPtwSop = "";
        $vvsPtwHira = "";
        foreach ($vvsPtwData->sopPolicy as $key => $value) {
            $vvsPtwSop.=$value->sops->NAME.", ";  
        } 
        foreach ($vvsPtwData->hira as $key => $value) {
            $vvsPtwHira.=$value->hiraMaster->HIRA_REFERENCE_NO.", ";
        }
        $ptwOutPut["SOP_POLICIES"] = rtrim($vvsPtwSop, ', ');
        $ptwOutPut["HIRA_REFERENCES"] = rtrim($vvsPtwHira, ', ');
        return $ptwOutPut; 
    }

    /**
     * @param Request $request
     * @return PtwResource
     */
    public function ptwDownloadableList(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsPtwListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                
                $ptwDownloadableData = $this->vvsPtwService->getPtwDownloadableList($requestData);
                $searchCriteria = $this->vvsPtwService->getSearchCriteriaList($requestData);
                $vvsPtwTableOutput = [];
                foreach ($ptwDownloadableData as $value){
                    $vvsPtwTableOutput[] = (new PtwResource($value))->transformPtwDownloadableList($value);
                }
                
                $output = ["SEARCH_CRITERIA" => $searchCriteria, "PTW_LIST" => $vvsPtwTableOutput,];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function ptwActivityLog(Request $request)
    {
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsPtwData = $this->vvsPtwService->getPtwDetails($vvsRequestData);
            $ptwId = $vvsPtwData->ID;
            if($vvsPtwData->TOP_PARENT_PTW_ID > 0){
                $ptwId = $vvsPtwData->TOP_PARENT_PTW_ID;
            }
            $vvsPtwOutput = (new PtwResource($vvsPtwData))->transformPtwReport($vvsPtwData);
            $ptwActivityLog = $this->vvsPtwActivityService->getAllActivityLog($ptwId);
            $vvsPtwOutput['ACTIVITY_LOG'] = PtwActionHistoryResource::collection($ptwActivityLog);
            return $this->successMessage($vvsPtwOutput);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function ptwAudit(Request $request){
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);            
            $requestData = $this->vvsPtwAuditService->getPtwAuditDetails($vvsRequestData);
            $newvalue = json_encode($requestData);
            //prd(json_encode($requestData));
            
           
            return $this->successMessage($vvsPtwOutput);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}
