<?php

namespace App\Repositories\PTW;

use App\Http\Requests\PTW\MasterListRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\PTW\PtwMstTypeServices;
use App\Services\PTW\PtwMstServices;
use App\Services\LocationServices;
use App\Services\PTW\PtwMstContractorServices;
use App\Services\PTW\PtwMstSoapPoliciesServices;
use App\Services\PTW\PtwMstStageServices;
use App\Services\PTW\PtwMstWorkerDsgServices;
use App\Services\PTW\PtwMstWorkerServices;
use App\Services\PTW\PtwCheckListServices;
use App\Services\PTW\PtwMstDeclarationServices;
use App\Services\PTW\PtwMstHiraServices;
use App\Services\PTW\PtwMstTaggedByServices;
use App\Services\UserServices;

use App\Models\MstLocation;
use App\Models\PtwMstSoapPolicies;
use App\Models\PtwMstContractor;
use App\Models\PtwMstWorkerDsg;
use App\Models\PtwMstStage;
use App\Models\PtwMstWorker;

use App\Http\Resources\PTW\PtwMstTypeResource;
use App\Http\Resources\PTW\LocationResource;
use App\Http\Resources\PTW\PtwMstSoapPoliciesResource;
use App\Http\Resources\PTW\PtwMstContractorResource;
use App\Http\Resources\PTW\PtwMstWorkerDsgResource;
use App\Http\Resources\PTW\PtwMstStageResource;
use App\Http\Resources\PTW\PtwMstWorkerResource;
use App\Http\Resources\PTW\PtwCheckListOptionResource;
use App\Http\Resources\PTW\PtwCheckListResource;
use App\Http\Resources\PTW\PtwMstDeclarationResource;
use App\Http\Resources\PTW\PtwMstHiraResource;
use App\Http\Resources\PTW\PtwMstTaggedByResource;
use App\Http\Resources\PTW\PtwMstTypeWorkerResource;

class PtwMasterListRepository implements PtwMasterListInterface
{
    use EncDecService;
    public $vvsPtwTypeService;
    public $vvsLocationService;
    public $vvsPtwContService;
    public $vvsPtwSopService;
    public $vvsPtwStageService;
    public $vvsPtwDesigService;
    public $vvsPtwWorkerService;
    public $vvsPtwCheckListService;
    public $vvsPtwDeclService;
    public $vvsPtwHiraService;
    public $vvsPtwListRequest;
    public $vvsPtwTaggedService;
    public $vvsUserService;
   
    public function __construct()
    {
      $this->vvsPtwTypeService = new PtwMstTypeServices();
      $this->vvsLocationService = new LocationServices();
      $this->vvsPtwContService = new PtwMstContractorServices();
      $this->vvsPtwSopService = new PtwMstSoapPoliciesServices();
      $this->vvsPtwStageService = new PtwMstStageServices();
      $this->vvsPtwDesigService = new PtwMstWorkerDsgServices();
      $this->vvsPtwWorkerService = new PtwMstWorkerServices();
      $this->vvsPtwCheckListService = new PtwCheckListServices();
      $this->vvsPtwDeclService = new PtwMstDeclarationServices();
      $this->vvsPtwHiraService = new PtwMstHiraServices();
      $this->vvsPtwTaggedService = new PtwMstTaggedByServices();
      $this->vvsUserService = new UserServices();

      $this->vvsPtwListRequest = new MasterListRequest();

    }

   public function masterListPtw(Request $request){
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $vvsRawRequest = $this->customDecrypt($request->X_KEY);
            $vvsValidationErrorData = $this->vvsPtwListRequest->masterAPIInputValidation($vvsRawRequest);
            if (trim($vvsValidationErrorData) != "") {
                return $this->failureMessage($vvsValidationErrorData);
            }

            //PTW TYPE
            $vvsPtwtypes = $this->vvsPtwTypeService->getPtwTypeList();
            $vvsMasterData["VVSPtwTypes"] = PtwMstTypeResource::collection($vvsPtwtypes);
           
            
            //PTW SOP
            $vvsPtwSops = $this->vvsPtwSopService->getPtwSopList();
            $vvsMasterData["VVSPtwSops"] = PtwMstSoapPoliciesResource::collection($vvsPtwSops);

            //PTW WORKER DESIGNATION
            $vvsPtwWorkDesg = $this->vvsPtwDesigService->getPtwWorkDesgList();
            $vvsMasterData["VVSPtwWorkerDesg"] = PtwMstWorkerDsgResource::collection($vvsPtwWorkDesg);

            //PTW STAGES
            $vvsPtwStages = $this->vvsPtwStageService->getPtwStageList();
            $vvsMasterData["VVSPtwStages"] = PtwMstStageResource::collection($vvsPtwStages);

            //LOCATIONS
            $vvsPtwLocations = $this->vvsLocationService->getLocationList($vvsRawRequest);
            $vvsMasterData["VVSPtwLocations"] = LocationResource::collection($vvsPtwLocations);

            //PTW CONTRACTORS
            $vvsPtwContractors = $this->vvsPtwContService->getPtwContList($vvsRawRequest);
            $vvsMasterData["VVSPtwContractors"] = PtwMstContractorResource::collection($vvsPtwContractors);

            //PTW WORKERS
            $vvsPtwWorkers = $this->vvsPtwWorkerService->getPtwWorkerList($vvsRawRequest);
            $vvsMasterData["PtwWorkers"] = PtwMstWorkerResource::collection($vvsPtwWorkers);

            //PTW DECLARATION
            $vvsPtwDeclarationsOne = $this->vvsPtwDeclService->getPtwInitialDeclListOne();
            $vvsMasterData["PtwDeclarationsOne"] = PtwMstDeclarationResource::collection($vvsPtwDeclarationsOne);

            $vvsPtwDeclarationsTwo = $this->vvsPtwDeclService->getPtwInitialDeclListTwo();
            $vvsMasterData["PtwDeclarationsTwo"] = PtwMstDeclarationResource::collection($vvsPtwDeclarationsTwo);

            $vvsPtwHira = $this->vvsPtwHiraService->getPtwHiraList($vvsRawRequest);
            $vvsMasterData["VVSPtwHira"] = PtwMstHiraResource::collection($vvsPtwHira);

            //PRECAUSION TAGGED BY LIST
            $vvsPtwTagBy = $this->vvsPtwTaggedService->getPtwTaggedByList($vvsRawRequest);
            $vvsMasterData["PtwPrecausionTaggedByList"] = PtwMstTaggedByResource::collection($vvsPtwTagBy);

            //PRECAUSION ACTION LIST
            $vvsPreType = getPrecautionActionList();
            $vvsMasterData["PtwPrecausionActionList"] = $vvsPreType;
            
            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function masterChekListPtw(Request $request){
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $vvsRawRequest = $this->customDecrypt($request->X_KEY);
            $vvsValidationErrorData = $this->vvsPtwListRequest->checkListAPIInputValidation($vvsRawRequest);
            if (trim($vvsValidationErrorData) != "") {
                return $this->failureMessage($vvsValidationErrorData);
            }
            //PTW CHECKLIST
            $vvsPtwCheckList = $this->vvsPtwCheckListService->getGeneralPtwCheckList($vvsRawRequest);            
            $vvsMasterData["VVSGeneralCheckList"] = PtwCheckListResource::collection($vvsPtwCheckList);

            $vvsPpePtwCheckList = $this->vvsPtwCheckListService->getPpePtwCheckList($vvsRawRequest);
            $vvsMasterData["VVSPpeCheckList"] = PtwCheckListResource::collection($vvsPpePtwCheckList);

            //PTW WORKERS
            $vvsPtwWorkers = $this->vvsPtwWorkerService->getPtwTypeWorkerList($vvsRawRequest);
            $vvsMasterData["PtwTypeWorkers"] = PtwMstTypeWorkerResource::collection($vvsPtwWorkers);

            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

}
