<?php

namespace App\Repositories\PTW;

use App\Http\Controllers\Controller;
use App\Services\PTW\PtwServices;


class PtwFileProcess extends Controller
{
    public $vvsPtwService;

    /**
     * PtwFileProcess constructor.
     */

     public function __construct()
     {
         $this->vvsPtwService = new PtwServices();
         
     }

    protected function getFileTypeFromUrl($url)
    {
        $vvsreturnData = "unknown";
        $vvsurlArray = explode(".", $url);
        $vvsurlLastElement = end($vvsurlArray);
        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
            $vvsreturnData = 'image';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['PDF'])) {
            $vvsreturnData = 'application/pdf';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['MP4'])) {
            $vvsreturnData = 'video';
        }
        return $vvsreturnData;
    }

    public function getPtwFiles($vvsPtwFiles, $vvsstageId, $vvsaction = null)
    {
        $vvsPtwFileArray = [];

        $vvsUploadPath = config('constants.PTW_FILE_UPLOAD_PATH');

        if (!empty($vvsPtwFiles)) {
            foreach ($vvsPtwFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsPtwFileArray[$key1][$key2] = $value2;

                    if ($key2 == 'FILE_NAME') {
                        $vvsImagePath = asset('public/' . $vvsUploadPath . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsPtwFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath, '', $value2);
                        $vvsPtwFileArray[$key1]['PTW_FILE'] = $vvsImagePath;
                        $vvsPtwFileArray[$key1]['MEDIA_TYPE_NAME'] = $this->getFileTypeFromUrl($vvsImagePath);
                        $vvsPtwFileArray[$key1]['IS_DELETE'] = $vvsstageId == 1 && $vvsaction !== 'view';
                    }
                }
            }
        }

        return $vvsPtwFileArray;
    }

    /**
     * fetch new PTW Auto Generation Number which may be inserted
     */

     public function ptwNumberGen($requestData)
     {
         $latestPtw = $this->vvsPtwService->getLastPtw($requestData);
         $incno = 1;
         if (!empty($latestPtw)) {
             $ptwLastNo = $latestPtw->AUTO_GEN_REF_NO;
             if (isset($ptwLastNo)) {
                 $prevPTWArray = explode('/', $ptwLastNo);
                 $lastNo = (int)$prevPTWArray[1];
                 $incno = $lastNo + 1;
             }
         }
         return config('constants.PTW_PREFIX') . sprintf("%05d", $incno) . '/' . strtoupper(date('M')) . date('Y');
     }
 
}
