<?php

namespace App\Repositories\OBSERVATION;

use App\Http\Requests\OBSERVATION\ListRequest;
use App\Http\Requests\OBSERVATION\ViewRequest;
use App\Http\Requests\OBSERVATION\AddRequest;

use App\Models\ObservationActionHistory;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\OBSERVATION\ObservationServices;
use App\Services\OBSERVATION\ObservationMstDeclarationServices;
use App\Services\OBSERVATION\ObservationActionHistoryServices;
use App\Services\UserServices;
use App\Repositories\OBSERVATION\ObservationFileProcess;

use App\Models\MstLocation;

use App\Http\Resources\OBSERVATION\ObservationResource;
use App\Http\Resources\OBSERVATION\ObservationMstDeclarationResource;
use App\Http\Resources\OBSERVATION\ObservationMapDeclarationResource;
use App\Http\Resources\OBSERVATION\ObservationActionHistoryResource;


class ObservationRepository implements ObservationInterface
{
    use EncDecService;
    public $vvsObservationListRequest;
    public $vvsObservationAddRequest;
    public $vvsObservationService;
    public $vvsObservationViewRequest;
    public $vvsObservationDeclService;
    public $vvsObservationFileProcess;
    public $vvsObservationActivityLogService;
    public $vvsUserService;
    

    public function __construct()
    {
        $this->vvsUserService = new UserServices();
        $this->vvsObservationListRequest = new ListRequest();
        $this->vvsObservationViewRequest = new ViewRequest();
        $this->vvsObservationAddRequest = new AddRequest();
        $this->vvsObservationService = new ObservationServices();
        $this->vvsObservationDeclService = new ObservationMstDeclarationServices();
        $this->vvsObservationFileProcess = new ObservationFileProcess();
        $this->vvsObservationActivityLogService = new ObservationActionHistoryServices();       
        
    }

    public function listObservation(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsObservationUerRoleData = $vvsUserData->obsroles;
            $vvsUserRole = "";
            if(isset($vvsObservationUerRoleData) && !empty($vvsObservationUerRoleData)){
                $vvsUserRole = $vvsObservationUerRoleData[0]->ROLE_ID;
            }            
            $validationErrorData = $this->vvsObservationListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsObservationData = $this->vvsObservationService->getObservationList($requestData);
                $ObservationTotalCount = $this->vvsObservationService->getObservationListTotalCount($requestData);
                $ObservationList = ObservationResource::collection($vvsObservationData);
                $calculatedTab = $this->vvsObservationService->calculatedTab($requestData);
                $output = ["TAB" => $calculatedTab, "OBSERVATION_LIST" => $ObservationList,"TOTAL_NO" => $ObservationTotalCount,
                            "IS_ADD_BTN"=>(($vvsUserRole == 11)?true:false)];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

     /**
     * @param Request $request
     * @return ObservationResource
     */

     public function observationDetails(Request $request)
     {
         if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
             return $this->failureMessage("Request pattern is not valid.");
         }
         
         try {
             $vvsRequestData = $this->customDecrypt($request->X_KEY);
             $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
             $errorMessage = "";
 
             if (!$vvsUserData->toArray()) {
                 $errorMessage = "Token mismatch";
             } else {                 
                 $vvsValidationErrorData = $this->vvsObservationViewRequest->editAPIInputValidation($vvsRequestData);
                 if (trim($vvsValidationErrorData) != "") {
                     $errorMessage = $vvsValidationErrorData;
                 } else { 
                     $vvsObservationData = $this->vvsObservationService->getObservationDetails($vvsRequestData); 
                     $vvsaction = $vvsRequestData->ACTION ?? "";
                     if ($vvsObservationData == "") {
                         $vvsObservationOutput = [];
                     } else {
                         $editable = $vvsaction !== "view" && in_array($vvsObservationData->STAGE_ID, [1]); 
                         $vvsButtonAccess = $this->ObservationButtonAceess($vvsUserData, $vvsObservationData, $vvsaction);
                         $vvsObservationRoleData = $vvsUserData->obsroles;
                         $vvsUserRole = $vvsObservationRoleData[0]->ROLE_ID;
                         $vvsObservationTableOutput = ObservationResource::transformObservation($vvsObservationData,$vvsUserData);                        
                         $vvsObservationDecalarion = $this->getDeclaration($vvsObservationData->ID, $vvsObservationData->STAGE_ID, $vvsaction);                        
                         $isActionTakenSection = false;
                         
                         if($vvsObservationData->ACTION_OWNER_ID == $request->CREATED_BY && in_array($vvsObservationData->STAGE_ID,[4,5,9,7,8])){
                            $isActionTakenSection = true;
                         }
                         if($vvsObservationData->CREATED_BY == $request->CREATED_BY && in_array($vvsObservationData->STAGE_ID,[7,8])){
                            $isActionTakenSection = true;
                         }
                         $vvsObservationRecalculatedOutput = [                             
                             "OBSERVATION_FILES" => [
                                 "EDITABLE"      => ((in_array($vvsObservationData->STAGE_ID,[1]) && ($vvsObservationData->CREATED_BY == $request->CREATED_BY))?true:false),
                                 "VALUE"         => $this->vvsObservationFileProcess->getObservationFiles($vvsObservationData->observationFiles, $vvsObservationData, $request->CREATED_BY, $vvsaction)
                             ],
                             "ACTION_TAKEN_FILES" => [
                                "EDITABLE"      => ((in_array($vvsObservationData->STAGE_ID,[4,5,9]) && ($vvsObservationData->ACTION_OWNER_ID == $request->CREATED_BY))?true:false),
                                "VALUE"         => $this->vvsObservationFileProcess->getObservationActionTakenFiles($vvsObservationData->actionTakenFiles, $vvsObservationData, $request->CREATED_BY, $vvsaction)
                            ],
                            "IS_ACTION_TAKEN_VIEW" => $isActionTakenSection,             
                             "IS_DRAFT_BTN"      => $vvsButtonAccess["IS_DRAFT_BTN"],
                             "IS_SUBMIT_BTN"     => $vvsButtonAccess["IS_SUBMIT_BTN"],
                             //"IS_FORWARD_BTN"    => $vvsButtonAccess["IS_FORWARD_BTN"],
                             "IS_SEND_BACK_BTN"  => $vvsButtonAccess["IS_SEND_BACK_BTN"],
                             "IS_APPROVE_BTN"    => $vvsButtonAccess["IS_APPROVE_BTN"],
                             "IS_REJECT_BTN"     => $vvsButtonAccess["IS_REJECT_BTN"],
                             "IS_CLOSE_REQ_BTN"  => $vvsButtonAccess["IS_CLOSE_REQ_BTN"],
                             "IS_CLOSE_BTN"      => $vvsButtonAccess["IS_CLOSE_BTN"],
                             "IS_REPORTER_APPROVE_BTN"    => $vvsButtonAccess["IS_REPORTER_APPROVE_BTN"],
                             "IS_REPORTER_REJECT_BTN"     => $vvsButtonAccess["IS_REPORTER_REJECT_BTN"], 
                             "DECLARATION_1"     => $vvsObservationDecalarion["DECLARATION_1"],
                             "DECLARATION_2"     => $vvsObservationDecalarion["DECLARATION_2"]
                         ];
                         $vvsObservationOutput = array_merge($vvsObservationTableOutput, $vvsObservationRecalculatedOutput);
                     }
                     return $this->successMessage($vvsObservationOutput);
                 }
             }
 
             return $this->failureMessage($errorMessage);
         } catch (ValidationException $e) {
             return $this->failureMessage(config('constants.SOMETHING_WRONG'));
         }
     }
     
     private function getDeclaration($Observation_id,$stageId, $vvsaction)
    {
        $afterSubmit = $stageId;
        if (in_array($stageId, [1])) {
          $afterSubmit = 1;
        }
        $vvsObservationInitDeclOne = $this->vvsObservationDeclService->getMapDeclarationOne($Observation_id,$afterSubmit);
        $vvsObservationInitDeclTwo = $this->vvsObservationDeclService->getMapDeclarationTwo($Observation_id,$afterSubmit);
        $vvsObservationOutput["DECLARATION_1"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsObservationOutput["DECLARATION_1"]["VALUE"] = ObservationMapDeclarationResource::collection($vvsObservationInitDeclOne);
        $vvsObservationOutput["DECLARATION_2"]["EDITABLE"] = (($afterSubmit==1 && $vvsaction!="view")?true:false);
        $vvsObservationOutput["DECLARATION_2"]["VALUE"] = ObservationMapDeclarationResource::collection($vvsObservationInitDeclTwo);
        return $vvsObservationOutput;

    }

    

    private function ObservationButtonAceess($userDetails, $observationDetails, $vvsaction)
    {
        $vvsObservationOutput = [
            "IS_DRAFT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SUBMIT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_FORWARD_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_SEND_BACK_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_APPROVE_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_REJECT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_CLOSE_REQ_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_CLOSE_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_REPORTER_APPROVE_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
            "IS_REPORTER_REJECT_BTN" => ["EDITABLE"=>false,"VALUE"=>[]],
        ];

        $vvsObservationUerRoleData = $userDetails->obsroles;
        //$vvsUserRole = $vvsObservationUerRoleData[0]->ROLE_ID;

        $userId = $userDetails->ID;
        //$stageId = $observationDetails->STAGE_ID;

        $this->handleInitiatorPart($vvsObservationOutput, $userId, $observationDetails, $vvsaction);
        $this->handleReviewerPart($vvsObservationOutput, $userId, $observationDetails, $vvsaction);
        

        return $vvsObservationOutput;
    }

    private function handleInitiatorPart(&$vvsObservationOutput, $userId, $observationDetails, $vvsaction)
    {
        if ($userId == $observationDetails->CREATED_BY && $vvsaction != "view") {
            if (in_array($observationDetails->STAGE_ID,[1])) {
                $vvsObservationOutput["IS_DRAFT_BTN"]["EDITABLE"] = true;
                $vvsObservationOutput["IS_SUBMIT_BTN"]["EDITABLE"] = true;
                $vvsObservationOutput["IS_DRAFT_BTN"]["VALUE"] =  [];
                $vvsObservationOutput["IS_SUBMIT_BTN"]["VALUE"] =  [];
            }
            if (in_array($observationDetails->STAGE_ID,[7])) {
                $vvsObservationCloseDecl = $this->vvsObservationDeclService->getObservationCloseDeclList();
                $vvsObservationOutput["IS_CLOSE_BTN"]["EDITABLE"] = true;
                $vvsObservationOutput["IS_SEND_BACK_BTN"]["EDITABLE"] = true;
                $vvsObservationOutput["IS_CLOSE_BTN"]["VALUE"] =  ObservationMstDeclarationResource::collection($vvsObservationCloseDecl);;
                $vvsObservationOutput["IS_SEND_BACK_BTN"]["VALUE"] =  [];
            }
            if(in_array($observationDetails->STAGE_ID,[6])){
                $vvsObservationOutput["IS_REPORTER_APPROVE_BTN"]["EDITABLE"] = true;
                $vvsObservationCloseDecl = $this->vvsObservationDeclService->getObservationApproveDeclList();
                $vvsObservationOutput["IS_REPORTER_APPROVE_BTN"]["VALUE"] = ObservationMstDeclarationResource::collection($vvsObservationCloseDecl);
                $vvsObservationOutput["IS_REPORTER_REJECT_BTN"]["EDITABLE"] = true;
            }
        }
    }

    private function handleReviewerPart(&$vvsObservationOutput, $userId, $observationDetails, $vvsaction)
    {
        if ($vvsaction != "view" && $observationDetails->ACTION_OWNER_ID == $userId) {
            if(in_array($observationDetails->STAGE_ID,[2,10])){
                $vvsObservationOutput["IS_APPROVE_BTN"]["EDITABLE"] = true;
                $vvsObservationCloseDecl = $this->vvsObservationDeclService->getObservationApproveDeclList();
                $vvsObservationOutput["IS_APPROVE_BTN"]["VALUE"] = ObservationMstDeclarationResource::collection($vvsObservationCloseDecl);
                $vvsObservationOutput["IS_REJECT_BTN"]["EDITABLE"] = true;
            }
            if(in_array($observationDetails->STAGE_ID,[4,5,9])) {
                $vvsObservationOutput["IS_CLOSE_REQ_BTN"]["EDITABLE"] = true;
                $vvsObservationSuspendDecl = $this->vvsObservationDeclService->getObservationCloseReqDeclList();
                $vvsObservationOutput["IS_CLOSE_REQ_BTN"]["VALUE"] = ObservationMstDeclarationResource::collection($vvsObservationSuspendDecl);
                //$vvsObservationOutput["IS_REJECT_BTN"]["EDITABLE"] = true;
            }
        }
    }

    /**
     * @param Request $request
     * @return ObservationResource
     */
    public function observationAdd(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
         
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
           
            $roleIds = array_map(function($item) {
                                    return $item['ROLE_ID'];
                                }, $vvsUserData ->obsroles->toArray());
            if(in_array(11,$roleIds) && !in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","CLOSE","SEND_BACK","REPORTER_APPROVE","REPORTER_REJECT"])){
                return $this->failureMessage("Sorry! You are not permitted to create a Observation.");
            }
            if(in_array(12,$roleIds) && !in_array(strtoupper($requestData->ACTION),["MOVE_FORWARD","REQUEST_FOR_CLOSURE","APPROVE","REJECT"])){
                return $this->failureMessage("Sorry! You are not permitted to take the selected action.");
            }
            
            

            //forcefully sending action irrespective of stage
                //ntbd
           
            if(in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE"])){

                $vvsObservationDataValidation = $request->ObservationAddValidation();
            }elseif(!in_array(strtoupper($requestData->ACTION),["DRAFT","SAVE","RENEW"])){
                $vvsObservationDataValidation = $request->ObservationSaveValidation();
            }else{
                $vvsObservationDataValidation = "";
            }
           
            if( $vvsObservationDataValidation == "" ){
                //data saving in Observation and associate table
                $ObservationDataSaved = $this->vvsObservationService->save($requestData);
                if( $ObservationDataSaved ){
                    $saveMsg = "saved";
                    if(strtoupper($requestData->ACTION) == "DRAFT"){
                        $saveMsg = "drafted by reporter";
                    }
                    else if(strtoupper($requestData->ACTION) == "SAVE"){
                        $saveMsg = "reported by reporter";
                    }
                    else if(strtoupper($requestData->ACTION) == "MOVE_FORWARD"){
                        $saveMsg = "reviewed and approved by action owner";
                    }
                    else if(strtoupper($requestData->ACTION) == "SEND_BACK"){
                        $saveMsg = "reviewed by reporter and sent back to action owner";
                    }
                    else if(strtoupper($requestData->ACTION) == "APPROVE"){
                        $saveMsg = "accepted timeline by action owner";
                    }
                    else if(strtoupper($requestData->ACTION) == "REJECT"){
                        $saveMsg = "revised timeline by action owner";
                    } 
                    else if(strtoupper($requestData->ACTION) == "REQUEST_FOR_CLOSURE"){
                        $saveMsg = "requested for closure by action owner";
                    }
                    else if(strtoupper($requestData->ACTION) == "CLOSE"){
                        $saveMsg = "closed by reporter";
                    }
                    else if(strtoupper($requestData->ACTION) == "REPORTER_APPROVE"){
                        $saveMsg = "accepted timeline by reporter";
                    }
                    else if(strtoupper($requestData->ACTION) == "REPORTER_REJECT"){
                        $saveMsg = "revised timeline by reporter";
                    }
                    return $this->successMessage("Observation (Ref. No. ".$ObservationDataSaved.") data has been ".$saveMsg.".");
                }else{
                    return $this->failureMessage(config('constants.SOMETHING_WRONG')." - data not saving.");
                }
            }else{
                return $this->failureMessage($vvsObservationDataValidation);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function observationDetailsExport(Request $request)
    {
        if(!isset($request->X_KEY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $vvsRequestData = $this->customDecrypt($request->X_KEY);
            $vvsObservationData = $this->vvsObservationService->getObservationDetails($vvsRequestData);
            $vvsObservationOutput = (new ObservationResource($vvsObservationData))->transformObservationReport($vvsObservationData);
            $observationActionTaken = $this->vvsObservationActivityLogService->actionTakenLogExport($vvsRequestData->OBS_ID);
            $vvsObservationOutput["ACTION_HISTORY"] = [];
            foreach ($observationActionTaken as $value){
            $vvsObservationOutput["ACTION_HISTORY"][] = (new ObservationActionHistoryResource($value))->transformActionTakenReport($value);
            }
            return $this->successMessage([$vvsObservationOutput]);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return ObservationResource
     */
    public function observationDownloadableList(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $validationErrorData = $this->vvsObservationListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                
                $observationDownloadableData = $this->vvsObservationService->getObservationDownloadableList($requestData);
                $searchCriteria = $this->vvsObservationService->getSearchCriteriaList($requestData);
                $vvsObservationTableOutput = [];
                foreach ($observationDownloadableData as $value){
                    $vvsObservationTableOutput[] = (new ObservationResource($value))->transformObservationListReport($value);
                }
                
                $output = ["SEARCH_CRITERIA" => $searchCriteria, "OBSERVATION_LIST" => $vvsObservationTableOutput,];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function commentLog(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $observationComments = $this->vvsObservationService->commentLog($requestData -> OBS_ID);
            return $this->successMessage($observationComments);
           
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
    public function actionTakenLog(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            //$requestData -> CREATED_BY = $request -> CREATED_BY;
            $observationActionTaken = $this->vvsObservationActivityLogService->actionTakenLog($requestData->OBS_ID);
            $actionTakenOutput = ObservationActionHistoryResource::collection($observationActionTaken);
            return $this->successMessage($actionTakenOutput);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    public function obsAddDeclarationM(Request $request){
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData->CREATED_BY = $request->CREATED_BY;
            //checking role access for action
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);

            $roleIds = array_map(function($item) {
                return $item['ROLE_ID'];
            }, $vvsUserData ->obsroles->toArray());
            if(in_array(11,$roleIds) && !in_array(strtoupper($requestData->ACTION),["DECLARATIONM"])){
            return $this->failureMessage("Sorry! You are not permitted to save Declaration.");
            }

            $obsDataSaved = $this->vvsObservationService->saveObsDeclarationM($requestData);
            if( $obsDataSaved ){
                return $this->successMessage("Declaration data has been saved successfully");
            }
            
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        } 
    }
}