<?php

namespace App\Repositories\OBSERVATION;

use App\Http\Requests\OBSERVATION\MasterListRequest;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

use App\Http\Traits\EncDecService;
use App\Services\OBSERVATION\ObservationMstTypeServices;
use App\Services\OBSERVATION\ObservationServices;
use App\Services\OBSERVATION\ObservationMstLocationServices;
use App\Services\LocationServices;
use App\Services\OBSERVATION\ObservationMstStageServices;
use App\Services\OBSERVATION\ObservationMstDeclarationServices;
use App\Services\OBSERVATION\ObservationMstLikelihoodServices;
use App\Services\OBSERVATION\ObservationMstSeverityServices;
use App\Services\OBSERVATION\ObservationCheckListServices;
use App\Services\OBSERVATION\ObservationMstReportedByServices;
use App\Services\UserServices;

use App\Http\Resources\OBSERVATION\ObservationMstTypeResource;
use App\Http\Resources\OBSERVATION\LocationResource;
use App\Http\Resources\OBSERVATION\ObservationMstStageResource;
use App\Http\Resources\OBSERVATION\ObservationCheckListOptionResource;
use App\Http\Resources\OBSERVATION\ObservationCheckListResource;
use App\Http\Resources\OBSERVATION\ObservationMstDeclarationResource;
use App\Http\Resources\OBSERVATION\ObservationMstSeverityResource;
use App\Http\Resources\OBSERVATION\ObservationMstLikelihoodResource;
use App\Http\Resources\OBSERVATION\ObservationReportedByResource;
use App\Http\Resources\OBSERVATION\ObservationReferenceResource;


class ObservationMasterListRepository implements ObservationMasterListInterface
{
    use EncDecService;
    public $vvsObservationTypeService;
    public $vvsLocationService;
    public $vvsObservationStageService;
    public $vvsObservationDeclService;
    public $vvsObservationSeverityService;
    public $vvsObservationLikelihoodService;
    public $vvsObservationListRequest;
    public $vvsObservationService;
    public $vvsObservationReportedByService;
    public $vvsUserService;
    
    public function __construct()
    {
      $this->vvsObservationTypeService = new ObservationMstTypeServices();
      $this->vvsLocationService = new ObservationMstLocationServices();
      $this->vvsObservationStageService = new ObservationMstStageServices();
      $this->vvsObservationDeclService = new ObservationMstDeclarationServices();
      $this->vvsUserService = new UserServices();
      $this->vvsObservationListRequest = new MasterListRequest();
      $this->vvsObservationSeverityService = new ObservationMstSeverityServices();
      $this->vvsObservationLikelihoodService = new ObservationMstLikelihoodServices();
      $this->vvsObservationReportedByService = new ObservationMstReportedByServices();
      $this->vvsObservationService = new ObservationServices();
    }

   public function masterListObservation(Request $request){
        try {
            if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $vvsRawRequest = $this->customDecrypt($request->X_KEY);
            $vvsValidationErrorData = $this->vvsObservationListRequest->masterAPIInputValidation($vvsRawRequest);
            if (trim($vvsValidationErrorData) != "") {
                return $this->failureMessage($vvsValidationErrorData);
            }

            //Observation TYPE
            $vvsObservationtypes = $this->vvsObservationTypeService->getObservationTypeList();
            $vvsMasterData["VVSObservationTypes"] = ObservationMstTypeResource::collection($vvsObservationtypes);             

            //Observation STAGES
            $vvsObservationStages = $this->vvsObservationStageService->getObservationStageList();
            $vvsMasterData["VVSObservationStages"] = ObservationMstStageResource::collection($vvsObservationStages);

            //LOCATIONS
            $vvsObservationLocations = $this->vvsLocationService->getLocationList($vvsRawRequest);
            $vvsMasterData["VVSObservationLocations"] = LocationResource::collection($vvsObservationLocations);

            //Observation DECLARATION
            $vvsObservationDeclarationsOne = $this->vvsObservationDeclService->getObservationInitialDeclListOne();
            $vvsMasterData["ObservationDeclarationsOne"] = ObservationMstDeclarationResource::collection($vvsObservationDeclarationsOne);

            $vvsObservationDeclarationsTwo = $this->vvsObservationDeclService->getObservationInitialDeclListTwo();
            $vvsMasterData["ObservationDeclarationsTwo"] = ObservationMstDeclarationResource::collection($vvsObservationDeclarationsTwo);

            $vvsObservationDeclarationsPopOne = $this->vvsObservationDeclService->getObservationDeclListPopOne();
            $vvsMasterData["ObservationDeclarationsPopOne"] = ObservationMstDeclarationResource::collection($vvsObservationDeclarationsPopOne);

            $vvsObservationSeverity = $this->vvsObservationSeverityService->getObservationSeverityList();
            $vvsMasterData["ObservationSeverity"] = ObservationMstSeverityResource::collection($vvsObservationSeverity);

            
            $vvsObservationLikelihood = $this->vvsObservationLikelihoodService->getObservationLikelihoodList();
            $vvsMasterData["ObservationLikelihood"] = ObservationMstLikelihoodResource::collection($vvsObservationLikelihood);
            
            $vvsObsReportedBy = $this->vvsObservationReportedByService->getObsReportedByList($vvsRawRequest);
            $vvsMasterData["ObservationReportedByList"] = ObservationReportedByResource::collection($vvsObsReportedBy);

            $vvsObsReportedBy = $this->vvsObservationReportedByService->getObsactionOwnerByList($vvsRawRequest);
            $vvsMasterData["ActionOwnerList"] = ObservationReportedByResource::collection($vvsObsReportedBy);

            $vvsObservationRef = $this->vvsObservationService->getAllObservation($vvsRawRequest);
            $vvsMasterData["ObservationReference"] = ObservationReferenceResource::collection($vvsObservationRef);
            
            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

   

}
