<?php

namespace App\Repositories\OBSERVATION;

use App\Http\Controllers\Controller;
use App\Services\OBSERVATION\ObservationServices;


class ObservationFileProcess extends Controller
{
    public $vvsObservationService;

    /**
     * ObservationFileProcess constructor.
     */

     public function __construct()
     {
         $this->vvsObservationService = new ObservationServices();
         
     }

    protected function getFileTypeFromUrl($url)
    {
        $vvsreturnData = "unknown";
        $vvsurlArray = explode(".", $url);
        $vvsurlLastElement = end($vvsurlArray);
        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
            $vvsreturnData = 'image';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['PDF'])) {
            $vvsreturnData = 'application/pdf';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['MP4'])) {
            $vvsreturnData = 'video';
        }
        return $vvsreturnData;
    }

    public function getObservationFiles($vvsObservationFiles, $vvsObservationData, $userId, $vvsaction = null)
    {
        $vvsObservationFileArray = [];

        $vvsUploadPath = config('constants.OBS_FILE_UPLOAD_PATH');

        if (!empty($vvsObservationFiles)) {
            foreach ($vvsObservationFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsObservationFileArray[$key1][$key2] = $value2;

                    if ($key2 == 'FILE_NAME') {
                        $vvsImagePath = asset('public/' . $vvsUploadPath . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsObservationFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath, '', $value2);
                        $vvsObservationFileArray[$key1]['OBSERVATION_FILE'] = $vvsImagePath;
                        $vvsObservationFileArray[$key1]['MEDIA_TYPE_NAME'] = $this->getFileTypeFromUrl($vvsImagePath);
                        $vvsObservationFileArray[$key1]['IS_DELETE'] = ((in_array($vvsObservationData->STAGE_ID,[1]) && ($vvsObservationData->CREATED_BY == $userId))?true:false);
                    }
                }
            }
        }

        return $vvsObservationFileArray;
    }

    public function getObservationActionTakenFiles($vvsObservationFiles, $vvsObservationData, $userId, $vvsaction = null)
    {
        $vvsObservationFileArray = [];

        $vvsUploadPath = config('constants.OBS_FILE_UPLOAD_PATH');

        if (!empty($vvsObservationFiles)) {
            foreach ($vvsObservationFiles as $key1 => $value1) {
                $fileArray = $value1->toArray();
                foreach ($fileArray as $key2 => $value2) {
                    $vvsObservationFileArray[$key1][$key2] = $value2;

                    if ($key2 == 'FILE_NAME') {
                        $vvsImagePath = asset('public/' . $vvsUploadPath . $value2);
                        $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);

                        $vvsObservationFileArray[$key1][$key2] = str_replace('./' . $vvsUploadPath, '', $value2);
                        $vvsObservationFileArray[$key1]['ACTION_TAKEN_FILE'] = $vvsImagePath;
                        $vvsObservationFileArray[$key1]['MEDIA_TYPE_NAME'] = $this->getFileTypeFromUrl($vvsImagePath);
                        $vvsObservationFileArray[$key1]['IS_DELETE'] = ((in_array($vvsObservationData->STAGE_ID,[4,5,9]) && ($vvsObservationData->ACTION_OWNER_ID == $userId))?true:false);
                    }
                }
            }
        }

        return $vvsObservationFileArray;
    }

   
 
}
