<?php

namespace App\Repositories\Master;

use App\Http\Controllers\Controller;
use App\Services\Master\MasterWorkerServices;


class MasterWorkerFileProcess extends Controller
{
    public $vvsWorkerService;

    /**
     * PtwFileProcess constructor.
     */

     public function __construct()
     {
         $this->vvsWorkerService = new MasterWorkerServices();
         
     }

    protected function getFileTypeFromUrl($url)
    {
        $vvsreturnData = "unknown";
        $vvsurlArray = explode(".", $url);
        $vvsurlLastElement = end($vvsurlArray);
        if (in_array(strtoupper($vvsurlLastElement), ['PNG', 'JPEG', 'JPG'])) {
            $vvsreturnData = 'image';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['PDF'])) {
            $vvsreturnData = 'application/pdf';
        } elseif (in_array(strtoupper($vvsurlLastElement), ['MP4'])) {
            $vvsreturnData = 'video';
        }
        return $vvsreturnData;
    }

    public function getWorkerFiles($vvsWorkerdata)
    {
        $vvsWorkerFileArray = []; 
        if ($vvsWorkerdata->FILE_NAME) {
            $vvsUploadPath = config('constants.WORKER_FILE_UPLOAD_PATH');
            $vvsImagePath = asset('public/' . $vvsUploadPath . $vvsWorkerdata->FILE_NAME);
            $vvsImagePath = str_replace('public/public/', 'public/', $vvsImagePath);
            $vvsWorkerFileArray['WORKER_FILE'] = $vvsImagePath;
            $vvsWorkerFileArray['FILE_CAPTION'] = $vvsWorkerdata->FILE_CAPTION;
            $vvsWorkerFileArray['FILE_NAME'] = $vvsWorkerdata->FILE_NAME;
            $vvsWorkerFileArray['MEDIA_TYPE_NAME'] = $this->getFileTypeFromUrl($vvsImagePath);
            $vvsWorkerFileArray['IS_DELETE'] = $vvsWorkerdata->IS_ACTIVE == 0;            
        }
        return $vvsWorkerFileArray;
    }

    
 
}
