<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\MasterUserAccessListRequest;
use App\Http\Requests\Master\MasterUserAccessAddRequest;
use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterUserAccessServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterUserAccessResource;
use App\Http\Resources\Master\MasterUserAccessMasterListResource;
use App\Http\Resources\Master\MasterUserAccessSiteListResource;
use App\Models\UserMapRole;

class MasterUserAccessRepository implements MasterUserAccessInterface
{
    use EncDecService;
    public $vvsMasterUserAccessService;
    public $vvsMasterUserAccessListRequest;
    public $vvsMasterUserAccessAddRequest;
    public $vvsUserService;

    /**
     * MasterUserAccessRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterUserAccessService = new MasterUserAccessServices();
        $this->vvsMasterUserAccessListRequest = new MasterUserAccessListRequest();
        $this->vvsMasterUserAccessAddRequest = new MasterUserAccessAddRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return MasterUserAccessResource
     */
    public function listUserAccess(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsMasterUserAccessListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterUserAccessData = $this->vvsMasterUserAccessService->getMasterUserAccessList($requestData);
                // prd($vvsMasterUserAccessData);
                $masterUserAccessTotalCount = $vvsMasterUserAccessData['total'];
                foreach ($vvsMasterUserAccessData['data'] as $user) {
                    $user->UserRole = $vvsUserRole;
                }
        
                $masterUserAccessList = MasterUserAccessResource::collection($vvsMasterUserAccessData['data']);
                
                $output = ["USER_LIST" => $masterUserAccessList,"TOTAL_NO" => $masterUserAccessTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
     /**
     * @param Request $request
     * @return MasterUserAccessResource
     */
    public function masterListUserAccess(Request $request)
    {
        try {
            if (!isset($request->X_KEY) || empty($request->CREATED_BY)){
                return $this->failureMessage("Request pattern is not valid.");
            }
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            if (!$vvsUserData->toArray()) {
                return $this->failureMessage("Token mismatch");
            }
            $vvsRawRequest = $this->customDecrypt($request->X_KEY);

            $vvsModulenames = $this->vvsMasterUserAccessService->getModuleNameList();
            $vvsMasterData["VVSModuleNames"] = MasterUserAccessMasterListResource::collection($vvsModulenames);

            $vvsSites = $this->vvsMasterUserAccessService->getSiteList();
            $vvsMasterData["VVSSites"] = MasterUserAccessSiteListResource::collection($vvsSites);

            $sitesResourceCollection = MasterUserAccessSiteListResource::collection($vvsSites);

            // Convert resource collection to array
            $vvsSitesArray = $sitesResourceCollection->resolve();
            // Manually add the new data
            $vvsSitesArray[] = [
                "KEY" => 0,
                "VALUE" => "All _VOIS IN"
            ];

            $vvsMasterData["VVSSitesWithAll"] = $vvsSitesArray;

            return $this->successMessage( $vvsMasterData);
            
        }catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterUserAccessResource
     */
    public function userAccessAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $request->userAccessAddValidation();
            if (trim($validationErrorData) === "") {
                $userDataSaved = $this->vvsMasterUserAccessService->userAccessAdd($requestData, $vvsUserRole);
                //return $this->successMessage("Worker (ID ".$workerDataSaved.") data has been saved.");
                return $this->successMessage($userDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterUserAccessResource
     */
    public function userAccessDetails(Request $request)
    {
        if (!isset($request->X_KEY) || empty($request->CREATED_BY)) {
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                $vvsUserData = $this->vvsMasterUserAccessService->getUserDetails($requestData);
                $vvsUserTableOutput = (new MasterUserAccessResource($vvsUserData))->transformUser($vvsUserData);
                return $this->successMessage($vvsUserTableOutput);
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}