<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\MasterTypeTopicListRequest;
use App\Http\Requests\Master\MasterTypeTopicAddRequest;
use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterTypeTopicServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterTypeTopicResource;
// use App\Http\Resources\Master\MasterUserAccessMasterListResource;
use App\Models\UserMapRole;

class MasterTypeTopicRepository implements MasterTypeTopicInterface
{
    use EncDecService;
    public $vvsMasterTypeTopicService;
    public $vvsMasterTypeTopicListRequest;
    public $vvsMasterTypeTopicAddRequest;
    public $vvsUserService;

    /**
     * MasterTypeTopicRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterTypeTopicService = new MasterTypeTopicServices();
        $this->vvsMasterTypeTopicListRequest = new MasterTypeTopicListRequest();
        $this->vvsMasterTypeTopicAddRequest = new MasterTypeTopicAddRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return MasterTypeTopicResource
     */
    public function lisTypeTopic(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsMasterTypeTopicListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterTypeTopicData = $this->vvsMasterTypeTopicService->getMasterTypeTopicList($requestData);
                // prd($vvsMasterUserAccessData);
                $masterTypeTopicTotalCount = $vvsMasterTypeTopicData['total'];
                foreach ($vvsMasterTypeTopicData['data'] as $user) {
                    $user->UserRole = $vvsUserRole;
                }
        
                $masterTypeTopicList = MasterTypeTopicResource::collection($vvsMasterTypeTopicData['data']);
                
                $output = ["TYPE_TOPIC_LIST" => $masterTypeTopicList,"TOTAL_NO" => $masterTypeTopicTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
    //  /**
    //  * @param Request $request
    //  * @return MasterTypeTopicResource
    //  */
    // public function masterListUserAccess(Request $request)
    // {
    //     try {
    //         if (!isset($request->X_KEY) || empty($request->CREATED_BY)){
    //             return $this->failureMessage("Request pattern is not valid.");
    //         }
    //         $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
    //         if (!$vvsUserData->toArray()) {
    //             return $this->failureMessage("Token mismatch");
    //         }
    //         $vvsRawRequest = $this->customDecrypt($request->X_KEY);

    //         $vvsModulenames = $this->vvsMasterTypeTopicService->getModuleNameList();
    //         $vvsMasterData["VVSModuleNames"] = MasterUserAccessMasterListResource::collection($vvsModulenames);
    //         return $this->successMessage( $vvsMasterData);
            
    //     }catch (ValidationException $e) {
    //         return $this->failureMessage(config('constants.SOMETHING_WRONG'));
    //     }
    // }

    /**
     * @param Request $request
     * @return MasterTypeTopicResource
     */
    public function typeTopicAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            // prd(11);
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = "";
            // $validationErrorData = $request->userAccessAddValidation();
            if (trim($validationErrorData) === "") {
                $userDataSaved = $this->vvsMasterTypeTopicService->typeTopicAdd($requestData, $vvsUserRole);
                //return $this->successMessage("Worker (ID ".$workerDataSaved.") data has been saved.");
                return $this->successMessage($userDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterTypeTopicResource
     */
    public function typeTopicDetails(Request $request)
    {
        if (!isset($request->X_KEY) || empty($request->CREATED_BY)) {
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                $vvsTypeTopicData = $this->vvsMasterTypeTopicService->getTopicDetails($requestData);
                $vvsTypeTopicTableOutput = MasterTypeTopicResource::transformTypeTopic($vvsTypeTopicData);
                return $this->successMessage($vvsTypeTopicTableOutput);
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}