<?php

namespace App\Repositories\Master;

use App\Http\Requests\Master\SkillListRequest;
use App\Http\Requests\Master\SkillAddRequest;

use Illuminate\Http\Request;
use App\Http\Traits\EncDecService;
use App\Services\Master\MasterSkillServices;
use App\Services\UserServices;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\Master\MasterSkillResource;
use App\Models\UserMapRole;

class MasterSkillRepository implements MasterSkillInterface
{
    use EncDecService;
    public $vvsMasterSkillService;
    public $vvsSkillListRequest;
    public $vvsSkillAddRequest;
    public $vvsUserService;

    /**
     * MasterSkillRepository constructor.
     */

    public function __construct()
    {
        $this->vvsMasterSkillService = new MasterSkillServices();
        $this->vvsSkillListRequest = new SkillListRequest();
        $this->vvsSkillAddRequest = new SkillAddRequest();
        $this->vvsUserService = new UserServices();
    }

    /**
     * @param Request $request
     * @return MasterSkillResource
     */
    public function listSkill(Request $request)
    {
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = $this->vvsSkillListRequest->listAPIInputValidation($requestData);
            if ($validationErrorData == "") {
                $vvsMasterSkillData = $this->vvsMasterSkillService->getMasterSkillList($requestData);
                $masterSkillTotalCount = $vvsMasterSkillData['total'];
                foreach ($vvsMasterSkillData['data'] as $location) {
                    $location->UserRole = $vvsUserRole;
                }
                $masterSkillList = MasterSkillResource::collection($vvsMasterSkillData['data']);
                
                $output = ["SKILL_LIST" => $masterSkillList,"TOTAL_NO" => $masterSkillTotalCount];
                return $this->successMessage($output);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterSkillResource
     */
    public function skillAdd(Request $request)
    {
        if(!isset($request->X_KEY) || empty($request->CREATED_BY)){
            return $this->failureMessage("Request pattern is not valid.");
        }
        $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
        if (!$vvsUserData->toArray()) {
            return $this->failureMessage("Invalid User Id");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $requestData -> CREATED_BY = $request -> CREATED_BY;
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $vvsMasterUerRoleData = $vvsUserData->masterroles;
            $vvsUserRole = "";
            if (isset($vvsMasterUerRoleData) && !empty($vvsMasterUerRoleData) && isset($vvsMasterUerRoleData[0])) {
                $vvsUserRole = $vvsMasterUerRoleData[0]->ROLE_ID;
            }
            $validationErrorData = "";
            $validationErrorData = $request->skillAddValidation();
            if (trim($validationErrorData) === "") {
                $skillDataSaved = $this->vvsMasterSkillService->skillAdd($requestData, $vvsUserRole);
                return $this->successMessage($skillDataSaved);
            } else {
                return $this->failureMessage($validationErrorData);
            }
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }

    /**
     * @param Request $request
     * @return MasterSkillResource
     */
    public function skillDetails(Request $request)
    {
        if (!isset($request->X_KEY) || empty($request->CREATED_BY)) {
            return $this->failureMessage("Request pattern is not valid.");
        }
        try {
            $requestData = $this->customDecrypt($request->X_KEY);
            $vvsUserData = $this->vvsUserService->getUserDetails($request->CREATED_BY);
            $errorMessage = "";
            if (!$vvsUserData->toArray()) {
                $errorMessage = "Token mismatch";
            } else {
                $vvsSkillData = $this->vvsMasterSkillService->getSkillDetails($requestData);
                $vvsPtwMstTypeTableOutput = MasterSkillResource::transformSkill($vvsSkillData);
                return $this->successMessage($vvsPtwMstTypeTableOutput);
            }
            return $this->failureMessage($errorMessage);
        } catch (ValidationException $e) {
            return $this->failureMessage(config('constants.SOMETHING_WRONG'));
        }
    }
}